/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.validation;

import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.TimePointUnit;
import org.apache.flink.table.planner.expressions.utils.ScalarTypesTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001y3AAE\n\u0001E!)\u0011\u0006\u0001C\u0001U!)Q\u0006\u0001C\u0001]!)\u0001\t\u0001C\u0001]!)!\t\u0001C\u0001]!)A\t\u0001C\u0001]!)a\t\u0001C\u0001]!)\u0001\n\u0001C\u0001]!)!\n\u0001C\u0001]!)A\n\u0001C\u0001]!)a\n\u0001C\u0001]!)\u0001\u000b\u0001C\u0001]!)!\u000b\u0001C\u0001]!)A\u000b\u0001C\u0001]!)a\u000b\u0001C\u0001]!)\u0001\f\u0001C\u0001]!)!\f\u0001C\u0001]!)A\f\u0001C\u0001]\ti2kY1mCJ4UO\\2uS>t7OV1mS\u0012\fG/[8o)\u0016\u001cHO\u0003\u0002\u0015+\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005Y9\u0012aC3yaJ,7o]5p]NT!\u0001G\r\u0002\u000fAd\u0017M\u001c8fe*\u0011!dG\u0001\u0006i\u0006\u0014G.\u001a\u0006\u00039u\tQA\u001a7j].T!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO\u000e\u00011C\u0001\u0001$!\t!s%D\u0001&\u0015\t1S#A\u0003vi&d7/\u0003\u0002)K\t\u00192kY1mCJ$\u0016\u0010]3t)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012a\u000b\t\u0003Y\u0001i\u0011aE\u0001\u0010i\u0016\u001cH/\u00138wC2LGMQ5ocQ\tq\u0006\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014G\u0001\u0003V]&$\bF\u0001\u00027!\t9d(D\u00019\u0015\tI$(A\u0002ba&T!a\u000f\u001f\u0002\u000f),\b/\u001b;fe*\u0011QhH\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u007fa\u0012A\u0001V3ti\u0006yA/Z:u\u0013:4\u0018\r\\5e\u0005&t'\u0007\u000b\u0002\u0004m\u0005yA/Z:u\u0013:4\u0018\r\\5e\u0005&t7\u0007\u000b\u0002\u0005m\u0005!B/Z:u\u0013:4\u0018\r\\5e)J,hnY1uKFB#!\u0002\u001c\u0002)Q,7\u000f^%om\u0006d\u0017\u000e\u001a+sk:\u001c\u0017\r^33Q\t1a'A\u000buKN$\u0018J\u001c<bY&$7+\u001e2tiJLgnZ\u0019)\u0005\u001d1\u0014!\u0006;fgRLeN^1mS\u0012\u001cVOY:ue&twM\r\u0015\u0003\u0011Y\n!\u0006^3tiRKW.Z:uC6\u0004\u0018\t\u001a3XSRDwK]8oORKW.Z:uC6\u0004\u0018J\u001c;feZ\fG\u000e\u000b\u0002\nm\u0005AC/Z:u)&lWm\u001d;b[B\fE\rZ,ji\"<&o\u001c8h)&lWm\u001d;b[B4uN]7bi\"\u0012!BN\u0001\"i\u0016\u001cH\u000fV5nKN$\u0018-\u001c9BI\u0012<\u0016\u000e\u001e5Xe>tw-U;b]RLG/\u001f\u0015\u0003\u0017Y\nqf]2bY\u0006LeNV1mS\u0012\fG/[8o\u000bb\u001cW\r\u001d;j_:$\u0015N\u001a4fe\u0016tGo\u00149fe\u0006tGm\u001d+fgRD#\u0001\u0004\u001c\u0002=Q,7\u000f\u001e+j[\u0016\u001cH/Y7q\t&4gmV5uQ^\u0013xN\\4US6,\u0007FA\u00077\u0003\u0015\"Xm\u001d;US6,7\u000f^1na\u0012KgMZ,ji\"<&o\u001c8h)&lW-\u00118e+:LG\u000f\u000b\u0002\u000fm\u00051B/Z:u\u0013:4\u0018\r\\5e'R\u0014\u0018N\\4U_6\u000b\u0007\u000f\u000b\u0002\u0010m\u0005iA/Z:u\u0013:4\u0018\r\\5e\u0013\u001aD#\u0001\u0005\u001c\u0002'Q,7\u000f^%om\u0006d\u0017\u000e\u001a+p\u0005\u0006\u001cXM\u000e\u001b)\u0005E1\u0004")
public class ScalarFunctionsValidationTest
extends ScalarTypesTestBase {
    @Test
    public void testInvalidBin1() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("BIN(f12)", "101010"));
    }

    @Test
    public void testInvalidBin2() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("BIN(f15)", "101010"));
    }

    @Test
    public void testInvalidBin3() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("BIN(f16)", "101010"));
    }

    @Test
    public void testInvalidTruncate1() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("TRUNCATE('abc', 'def')", "FAIL"));
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("TRUNCATE(f12, f0)", "FAIL"));
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("TRUNCATE(f12,f12)", "FAIL"));
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("TRUNCATE(f12, cast(f28 as DOUBLE))", "FAIL"));
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("TRUNCATE(f12,f15)", "FAIL"));
    }

    @Test
    public void testInvalidTruncate2() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("TRUNCATE('abc')", "FAIL"));
    }

    @Test
    public void testInvalidSubstring1() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi((Expression)package$.MODULE$.LiteralStringExpression("test").substring((Object)package$.MODULE$.LiteralDoubleExpression(2.0).toExpr()), "FAIL"));
    }

    @Test
    public void testInvalidSubstring2() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi((Expression)package$.MODULE$.LiteralStringExpression("test").substring((Object)package$.MODULE$.LiteralStringExpression("test").toExpr()), "FAIL"));
    }

    @Test
    public void testTimestampAddWithWrongTimestampInterval() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.testSqlApi("TIMESTAMPADD(XXX, 1, timestamp '2016-02-24'))", "2016-06-16"));
    }

    @Test
    public void testTimestampAddWithWrongTimestampFormat() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.testSqlApi("TIMESTAMPADD(YEAR, 1, timestamp '2016-02-24'))", "2016-06-16"));
    }

    @Test
    public void testTimestampAddWithWrongQuantity() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("TIMESTAMPADD(YEAR, 1.0, timestamp '2016-02-24 12:42:25')", "2016-06-16"));
    }

    @Test
    public void scalaInValidationExceptionDifferentOperandsTest() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).in((Object[])new Expression[]{package$.MODULE$.string2Literal("Hi"), package$.MODULE$.string2Literal("Hello world"), package$.MODULE$.string2Literal("Comment#1")}), "TRUE"));
    }

    @Test
    public void testTimestampDiffWithWrongTime() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi(package$.MODULE$.timestampDiff(TimePointUnit.DAY, package$.MODULE$.string2Literal("2016-02-24"), package$.MODULE$.string2Literal("2016-02-27")), "FAIL"));
    }

    @Test
    public void testTimestampDiffWithWrongTimeAndUnit() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi(package$.MODULE$.timestampDiff(TimePointUnit.MINUTE, package$.MODULE$.string2Literal("2016-02-24"), package$.MODULE$.string2Literal("2016-02-27")), "FAIL"));
    }

    @Test
    public void testInvalidStringToMap() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("STR_TO_MAP('k1:v1;k2:v2', ';')", "EXCEPTION")).withMessageContaining("Invalid number of arguments to function 'STR_TO_MAP'");
    }

    @Test
    public void testInvalidIf() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("IF(f7 > 5, f0, f1)", "FAIL")).withMessageContaining("Cannot apply 'IF' to arguments");
    }

    @Test
    public void testInvalidToBase64() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("TO_BASE64(11)", "FAIL")).withMessageContaining("Cannot apply 'TO_BASE64' to arguments of type 'TO_BASE64(<INTEGER>)'");
    }
}

