/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.validation;

import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.RowTypeTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0002\u0004\u0001+!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0001C!)1\u0007\u0001C\u0001C!)Q\u0007\u0001C\u0001C\t)\"k\\<UsB,g+\u00197jI\u0006$\u0018n\u001c8UKN$(BA\u0004\t\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003\u0013)\t1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0002D\u0001\ba2\fgN\\3s\u0015\tia\"A\u0003uC\ndWM\u0003\u0002\u0010!\u0005)a\r\\5oW*\u0011\u0011CE\u0001\u0007CB\f7\r[3\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0005eA\u0011!B;uS2\u001c\u0018BA\u000e\u0019\u0005=\u0011vn\u001e+za\u0016$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u0007\u0003A!Xm\u001d;F[B$\u0018PU8x)f\u0004X\rF\u0001#!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0011)f.\u001b;)\u0005\tI\u0003C\u0001\u00162\u001b\u0005Y#B\u0001\u0017.\u0003\r\t\u0007/\u001b\u0006\u0003]=\nqA[;qSR,'O\u0003\u00021%\u0005)!.\u001e8ji&\u0011!g\u000b\u0002\u0005)\u0016\u001cH/A\buKN$h*\u001e7m%><H+\u001f9fQ\t\u0019\u0011&A\fuKN$8+\u001d7S_^LE\u000e\\3hC2\f5mY3tg\"\u0012A!\u000b")
public class RowTypeValidationTest
extends RowTypeTestBase {
    @Test
    public void testEmptyRowType() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.testSqlApi("Row()", "FAIL"));
    }

    @Test
    public void testNullRowType() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testAllApis(package$.MODULE$.string2Literal("FAIL"), "Row(NULL)", "FAIL"));
    }

    @Test
    public void testSqlRowIllegalAccess() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).get("f2"), "f5.f2", "FAIL"));
    }
}

