/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.validation;

import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.ArrayTypeTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u00193AAC\u0006\u00015!)\u0011\u0005\u0001C\u0001E!)Q\u0005\u0001C\u0001M!)\u0001\b\u0001C\u0001M!)!\b\u0001C\u0001M!)A\b\u0001C\u0001M!)a\b\u0001C\u0001M!)\u0001\t\u0001C\u0001M!)!\t\u0001C\u0001M!)A\t\u0001C\u0001M\t9\u0012I\u001d:bsRK\b/\u001a,bY&$\u0017\r^5p]R+7\u000f\u001e\u0006\u0003\u00195\t!B^1mS\u0012\fG/[8o\u0015\tqq\"A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\t\u0012\u0003\u001d\u0001H.\u00198oKJT!AE\n\u0002\u000bQ\f'\r\\3\u000b\u0005Q)\u0012!\u00024mS:\\'B\u0001\f\u0018\u0003\u0019\t\u0007/Y2iK*\t\u0001$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00017A\u0011AdH\u0007\u0002;)\u0011a$D\u0001\u0006kRLGn]\u0005\u0003Au\u0011\u0011#\u0011:sCf$\u0016\u0010]3UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\t1\"\u0001\u000fuKN$\u0018*\u001c9mS\u000eLG\u000fV=qK\u000e\u000b7\u000f^!se\u0006L8+\u001d7\u0015\u0003\u001d\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012A!\u00168ji\"\u0012!A\f\t\u0003_Yj\u0011\u0001\r\u0006\u0003cI\n1!\u00199j\u0015\t\u0019D'A\u0004kkBLG/\u001a:\u000b\u0005U:\u0012!\u00026v]&$\u0018BA\u001c1\u0005\u0011!Vm\u001d;\u0002#Q,7\u000f^#naRL\u0018I\u001d:bsN\u000bH\u000e\u000b\u0002\u0004]\u0005\u0001B/Z:u\u001dVdG.\u0011:sCf\u001c\u0016\u000f\u001c\u0015\u0003\t9\n!\u0004^3ti\u0012KgMZ3sK:$H+\u001f9fg\u0006\u0013(/Y=Tc2D#!\u0002\u0018\u0002'Q,7\u000f^#mK6,g\u000e\u001e(p]\u0006\u0013(/Y=)\u0005\u0019q\u0013A\u0006;fgR,E.Z7f]RtuN\\!se\u0006L8+\u001d7)\u0005\u001dq\u0013!\u0007;fgR\u001c\u0015M\u001d3j]\u0006d\u0017\u000e^=P]:{g.\u0011:sCfD#\u0001\u0003\u0018\u00029Q,7\u000f^\"be\u0012Lg.\u00197jif|eNT8o\u0003J\u0014\u0018-_*rY\"\u0012\u0011B\f")
public class ArrayTypeValidationTest
extends ArrayTypeTestBase {
    @Test
    public void testImplicitTypeCastArraySql() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("ARRAY['string', 12]", "FAIL"));
    }

    @Test
    public void testEmptyArraySql() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("ARRAY[]", "FAIL"));
    }

    @Test
    public void testNullArraySql() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("ARRAY[NULL]", "FAIL"));
    }

    @Test
    public void testDifferentTypesArraySql() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("ARRAY[1, TRUE]", "FAIL"));
    }

    @Test
    public void testElementNonArray() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).element(), "FAIL"));
    }

    @Test
    public void testElementNonArraySql() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("ELEMENT(f0)", "FAIL"));
    }

    @Test
    public void testCardinalityOnNonArray() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).cardinality(), "FAIL"));
    }

    @Test
    public void testCardinalityOnNonArraySql() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("CARDINALITY(f0)", "FAIL"));
    }
}

