/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase$;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00154A\u0001E\t\u0001=!)Q\u0005\u0001C\u0001M!)\u0011\u0006\u0001C\u0001U!)A\b\u0001C\u0001U!)a\b\u0001C\u0001U!)\u0001\t\u0001C\u0001U!)!\t\u0001C\u0001U!)A\t\u0001C\u0001U!)a\t\u0001C\u0001U!)\u0001\n\u0001C\u0001U!)!\n\u0001C\u0001U!)A\n\u0001C\u0001U!)a\n\u0001C\u0001U!)\u0001\u000b\u0001C\u0001U!)!\u000b\u0001C!'\")!\f\u0001C!7\n\t2+\u001d7FqB\u0014Xm]:j_:$Vm\u001d;\u000b\u0005I\u0019\u0012aC3yaJ,7o]5p]NT!\u0001F\u000b\u0002\u000fAd\u0017M\u001c8fe*\u0011acF\u0001\u0006i\u0006\u0014G.\u001a\u0006\u00031e\tQA\u001a7j].T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO\u000e\u00011C\u0001\u0001 !\t\u00013%D\u0001\"\u0015\t\u0011\u0013#A\u0003vi&d7/\u0003\u0002%C\t\u0011R\t\u001f9sKN\u001c\u0018n\u001c8UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002)\u00015\t\u0011#A\fuKN$8i\\7qCJL7o\u001c8Gk:\u001cG/[8ogR\t1\u0006\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TF\u0001\u0003V]&$\bF\u0001\u00023!\t\u0019$(D\u00015\u0015\t)d'A\u0002ba&T!a\u000e\u001d\u0002\u000f),\b/\u001b;fe*\u0011\u0011hG\u0001\u0006UVt\u0017\u000e^\u0005\u0003wQ\u0012A\u0001V3ti\u0006!B/Z:u\u0019><\u0017nY1m\rVt7\r^5p]ND#a\u0001\u001a\u0002/Q,7\u000f^!sSRDW.\u001a;jG\u001a+hn\u0019;j_:\u001c\bF\u0001\u00033\u0003M!Xm\u001d;ESZLG-\u001a$v]\u000e$\u0018n\u001c8tQ\t)!'A\nuKN$8\u000b\u001e:j]\u001e4UO\\2uS>t7\u000f\u000b\u0002\u0007e\u0005AB/Z:u\u0007>tG-\u001b;j_:\fGNR;oGRLwN\\:)\u0005\u001d\u0011\u0014a\u0007;fgR$\u0016\u0010]3D_:4XM]:j_:4UO\\2uS>t7\u000f\u000b\u0002\te\u0005iB/Z:u-\u0006dW/Z\"p]N$(/^2u_J4UO\\2uS>t7\u000f\u000b\u0002\ne\u0005)B/Z:u\t\u0006$X\rV5nK\u001a+hn\u0019;j_:\u001c\bF\u0001\u00063\u0003I!Xm\u001d;BeJ\f\u0017PR;oGRLwN\\:)\u0005-\u0011\u0014!\u0005;fgRD\u0015m\u001d5Gk:\u001cG/[8og\"\u0012ABM\u0001\u0012i\u0016\u001cHOT;mY\u0006\u0014G.Z\"bg\u0016\u001c\bFA\u00073\u0003!!Xm\u001d;ECR\fW#\u0001+\u0011\u0005UCV\"\u0001,\u000b\u0005];\u0012!\u0002;za\u0016\u001c\u0018BA-W\u0005\r\u0011vn^\u0001\tif\u0004X-\u00138g_V\tA\f\u0005\u0002^G6\taL\u0003\u0002`A\u0006IA/\u001f9fkRLGn\u001d\u0006\u0003C\n\fAA[1wC*\u0011QgF\u0005\u0003Iz\u00131BU8x)f\u0004X-\u00138g_\u0002")
public class SqlExpressionTest
extends ExpressionTestBase {
    @Test
    public void testComparisonFunctions() {
        this.testSqlApi("1 = 1", "TRUE");
        this.testSqlApi("1 <> 1", "FALSE");
        this.testSqlApi("5 > 2", "TRUE");
        this.testSqlApi("2 >= 2", "TRUE");
        this.testSqlApi("5 < 2", "FALSE");
        this.testSqlApi("2 <= 2", "TRUE");
        this.testSqlApi("x'0c' <= x'0b'", "FALSE");
        this.testSqlApi("x'0c' > x'0b'", "TRUE");
        this.testSqlApi("x'0c' = x'0c'", "TRUE");
        this.testSqlApi("x'0c' <> x'0c'", "FALSE");
        this.testSqlApi("1 IS NULL", "FALSE");
        this.testSqlApi("1 IS NOT NULL", "TRUE");
        this.testSqlApi("NULLIF(1,1) IS DISTINCT FROM NULLIF(1,1)", "FALSE");
        this.testSqlApi("NULLIF(1,1) IS NOT DISTINCT FROM NULLIF(1,1)", "TRUE");
        this.testSqlApi("NULLIF(1,1) IS NOT DISTINCT FROM NULLIF(1,1)", "TRUE");
        this.testSqlApi("12 BETWEEN 11 AND 13", "TRUE");
        this.testSqlApi("12 BETWEEN ASYMMETRIC 13 AND 11", "FALSE");
        this.testSqlApi("12 BETWEEN SYMMETRIC 13 AND 11", "TRUE");
        this.testSqlApi("12 NOT BETWEEN 11 AND 13", "FALSE");
        this.testSqlApi("12 NOT BETWEEN ASYMMETRIC 13 AND 11", "TRUE");
        this.testSqlApi("12 NOT BETWEEN SYMMETRIC 13 AND 11", "FALSE");
        this.testSqlApi("'TEST' LIKE '%EST'", "TRUE");
        this.testSqlApi("'%EST' LIKE '.%EST' ESCAPE '.'", "TRUE");
        this.testSqlApi("'TEST' NOT LIKE '%EST'", "FALSE");
        this.testSqlApi("'%EST' NOT LIKE '.%EST' ESCAPE '.'", "FALSE");
        this.testSqlApi("'TEST' SIMILAR TO '.EST'", "TRUE");
        this.testSqlApi("'TEST' NOT SIMILAR TO '.EST'", "FALSE");
        this.testSqlApi("'TEST' IN ('west', 'TEST', 'rest')", "TRUE");
        this.testSqlApi("'TEST' IN ('west', 'rest')", "FALSE");
        this.testSqlApi("'TEST' NOT IN ('west', 'TEST', 'rest')", "FALSE");
        this.testSqlApi("'TEST' NOT IN ('west', 'rest')", "TRUE");
    }

    @Test
    public void testLogicalFunctions() {
        this.testSqlApi("TRUE OR FALSE", "TRUE");
        this.testSqlApi("TRUE AND FALSE", "FALSE");
        this.testSqlApi("NOT TRUE", "FALSE");
        this.testSqlApi("TRUE IS FALSE", "FALSE");
        this.testSqlApi("TRUE IS NOT FALSE", "TRUE");
        this.testSqlApi("TRUE IS TRUE", "TRUE");
        this.testSqlApi("TRUE IS NOT TRUE", "FALSE");
        this.testSqlApi("NULLIF(TRUE,TRUE) IS UNKNOWN", "TRUE");
        this.testSqlApi("NULLIF(TRUE,TRUE) IS NOT UNKNOWN", "FALSE");
    }

    @Test
    public void testArithmeticFunctions() {
        this.testSqlApi("+5", "5");
        this.testSqlApi("-5", "-5");
        this.testSqlApi("5+5", "10");
        this.testSqlApi("5-5", "0");
        this.testSqlApi("5*5", "25");
        this.testSqlApi("5/5", "1");
        this.testSqlApi("5%2", "1");
        this.testSqlApi("POWER(5, 5)", "3125.0");
        this.testSqlApi("POWER(-1, 0.5)", "NaN");
        this.testSqlApi("ABS(-5)", "5");
        this.testSqlApi("MOD(-26, 5)", "-1");
        this.testSqlApi("SQRT(4)", "2.0");
        this.testSqlApi("LN(1)", "0.0");
        this.testSqlApi("LOG10(1)", "0.0");
        this.testSqlApi("EXP(0)", "1.0");
        this.testSqlApi("CEIL(2.5)", "3");
        this.testSqlApi("CEILING(2.5)", "3");
        this.testSqlApi("FLOOR(2.5)", "2");
        this.testSqlApi("SIN(2.5)", "0.5984721441039564");
        this.testSqlApi("SINH(2.5)", "6.0502044810397875");
        this.testSqlApi("COS(2.5)", "-0.8011436155469337");
        this.testSqlApi("TAN(2.5)", "-0.7470222972386603");
        this.testSqlApi("COT(2.5)", "-1.3386481283041514");
        this.testSqlApi("ASIN(0.5)", "0.5235987755982989");
        this.testSqlApi("ACOS(0.5)", "1.0471975511965979");
        this.testSqlApi("ATAN(0.5)", "0.4636476090008061");
        this.testSqlApi("ATAN2(0.5, 0.5)", "0.7853981633974483");
        this.testSqlApi("COSH(2.5)", "6.132289479663686");
        this.testSqlApi("TANH(2.5)", "0.9866142981514303");
        this.testSqlApi("DEGREES(0.5)", "28.64788975654116");
        this.testSqlApi("RADIANS(0.5)", "0.008726646259971648");
        this.testSqlApi("SIGN(-1.1)", "-1.0");
        this.testSqlApi("ROUND(-12.345, 2)", "-12.35");
        this.testSqlApi("PI()", "3.141592653589793");
        this.testSqlApi("E()", "2.718281828459045");
        this.testSqlApi("truncate(42.345)", "42");
        this.testSqlApi("truncate(cast(42.345 as decimal(5, 3)), 2)", "42.34");
    }

    @Test
    public void testDivideFunctions() {
        this.testSqlApi("1.0/8.0", "0.125000");
        this.testSqlApi("2.0/3.0", "0.666667");
        this.testSqlApi("-2/3.0", "-0.666667");
        this.testSqlApi("2.0/(-3)", "-0.666666666667");
        this.testSqlApi("-7.9/2", "-3.950000000000");
        this.testSqlApi("1.0/400", "0.002500000000");
        this.testSqlApi("1.0/100000000000", "0.000000000010000000000");
        this.testSqlApi("1.0/cast(100 as TINYINT)", "0.010000");
        this.testSqlApi("1.0/cast(10000 as SMALLINT)", "0.0001000");
        String divisorZeroException = "Division by zero";
        this.testExpectedSqlException("1/cast(0.00 as decimal)", divisorZeroException, ArithmeticException.class);
        this.testExpectedSqlException("1/cast(0.00 as double)", divisorZeroException, ArithmeticException.class);
        this.testExpectedSqlException("1/cast(0.00 as float)", divisorZeroException, ArithmeticException.class);
        this.testExpectedSqlException("1/cast(0 as tinyint)", divisorZeroException, ArithmeticException.class);
        this.testExpectedSqlException("1/cast(0 as smallint)", divisorZeroException, ArithmeticException.class);
        this.testExpectedSqlException("1/0", divisorZeroException, ArithmeticException.class);
        this.testExpectedSqlException("1/cast(0 as bigint)", divisorZeroException, ArithmeticException.class);
    }

    @Test
    public void testStringFunctions() {
        this.testSqlApi("'test' || 'string'", "teststring");
        this.testSqlApi("CHAR_LENGTH('string')", "6");
        this.testSqlApi("CHARACTER_LENGTH('string')", "6");
        this.testSqlApi("UPPER('string')", "STRING");
        this.testSqlApi("LOWER('STRING')", "string");
        this.testSqlApi("POSITION('STR' IN 'STRING')", "1");
        this.testSqlApi("TRIM(BOTH ' STRING ')", "STRING");
        this.testSqlApi("TRIM(LEADING 'x' FROM 'xxxxSTRINGxxxx')", "STRINGxxxx");
        this.testSqlApi("TRIM(TRAILING 'x' FROM 'xxxxSTRINGxxxx')", "xxxxSTRING");
        this.testSqlApi("OVERLAY('This is a old string' PLACING 'new' FROM 11 FOR 3)", "This is a new string");
        this.testSqlApi("SUBSTRING('hello world', 2)", "ello world");
        this.testSqlApi("SUBSTRING('hello world', 2, 3)", "ell");
        this.testSqlApi("SUBSTRING('hello world', 2, 300)", "ello world");
        this.testSqlApi("SUBSTR('hello world', 2, 3)", "ell");
        this.testSqlApi("SUBSTR('hello world', 2)", "ello world");
        this.testSqlApi("SUBSTR('hello world', 2, 300)", "ello world");
        this.testSqlApi("SUBSTR('hello world', 0, 3)", "hel");
        this.testSqlApi("INITCAP('hello world')", "Hello World");
        this.testSqlApi("REGEXP_REPLACE('foobar', 'oo|ar', '')", "fb");
        this.testSqlApi("REGEXP_EXTRACT('foothebar', 'foo(.*?)(bar)', 2)", "bar");
        this.testSqlApi("REPEAT('This is a test String.', 2)", "This is a test String.This is a test String.");
        this.testSqlApi("REPLACE('hello world', 'world', 'flink')", "hello flink");
    }

    @Test
    public void testConditionalFunctions() {
        this.testSqlApi("CASE 2 WHEN 1, 2 THEN 2 ELSE 3 END", "2");
        this.testSqlApi("CASE WHEN 1 = 2 THEN 2 WHEN 1 = 1 THEN 3 ELSE 3 END", "3");
        this.testSqlApi("NULLIF(1, 1)", "NULL");
        this.testSqlApi("COALESCE(NULL, 5)", "5");
    }

    @Test
    public void testTypeConversionFunctions() {
        this.testSqlApi("CAST(2 AS DOUBLE)", "2.0");
    }

    @Test
    public void testValueConstructorFunctions() {
        this.testSqlApi("ROW('hello world', 12)", "(hello world, 12)");
        this.testSqlApi("('hello world', 12)", "(hello world, 12)");
        this.testSqlApi("('foo', ('bar', 12))", "(foo, (bar, 12))");
        this.testSqlApi("ARRAY[TRUE, FALSE][2]", "FALSE");
        this.testSqlApi("ARRAY[TRUE, TRUE]", "[TRUE, TRUE]");
        this.testSqlApi("MAP['k1', 'v1', 'k2', 'v2']['k2']", "v2");
        this.testSqlApi("MAP['k1', CAST(true AS VARCHAR(256)), 'k2', 'foo']['k1']", "TRUE");
    }

    @Test
    public void testDateTimeFunctions() {
        this.testSqlApi("DATE '1990-10-14'", "1990-10-14");
        this.testSqlApi("TIME '12:12:12'", "12:12:12");
        this.testSqlApi("TIMESTAMP '1990-10-14 12:12:12.123'", "1990-10-14 12:12:12.123");
        this.testSqlApi("INTERVAL '10 00:00:00.004' DAY TO SECOND", "+10 00:00:00.004");
        this.testSqlApi("INTERVAL '10 00:12' DAY TO MINUTE", "+10 00:12:00.000");
        this.testSqlApi("INTERVAL '2-10' YEAR TO MONTH", "+2-10");
        this.testSqlApi("EXTRACT(DAY FROM DATE '1990-12-01')", "1");
        this.testSqlApi("EXTRACT(DAY FROM INTERVAL '19 12:10:10.123' DAY TO SECOND(3))", "19");
        this.testSqlApi("FLOOR(TIME '12:44:31' TO MINUTE)", "12:44:00");
        this.testSqlApi("CEIL(TIME '12:44:31' TO MINUTE)", "12:45:00");
        this.testSqlApi("QUARTER(DATE '2016-04-12')", "2");
    }

    @Test
    public void testArrayFunctions() {
        this.testSqlApi("CARDINALITY(ARRAY[TRUE, TRUE, FALSE])", "3");
        this.testSqlApi("ELEMENT(ARRAY['HELLO WORLD'])", "HELLO WORLD");
    }

    @Test
    public void testHashFunctions() {
        this.testSqlApi("MD5('')", "d41d8cd98f00b204e9800998ecf8427e");
        this.testSqlApi("MD5('test')", "098f6bcd4621d373cade4e832627b4f6");
        this.testSqlApi("SHA1('')", "da39a3ee5e6b4b0d3255bfef95601890afd80709");
        this.testSqlApi("SHA1('test')", "a94a8fe5ccb19ba61c4c0873d391e987982fbbd3");
        this.testSqlApi("SHA224('')", "d14a028c2a3a2bc9476102bb288234c415a2b01f828ea62ac5b3e42f");
        this.testSqlApi("SHA2('', 224)", "d14a028c2a3a2bc9476102bb288234c415a2b01f828ea62ac5b3e42f");
        this.testSqlApi("SHA224('test')", "90a3ed9e32b2aaf4c61c410eb925426119e1a9dc53d4286ade99a809");
        this.testSqlApi("SHA2('test', 224)", "90a3ed9e32b2aaf4c61c410eb925426119e1a9dc53d4286ade99a809");
        this.testSqlApi("SHA256('')", "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855");
        this.testSqlApi("SHA2('', 256)", "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855");
        this.testSqlApi("SHA256('test')", "9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08");
        this.testSqlApi("SHA2('test', 256)", "9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08");
        this.testSqlApi("SHA384('')", "38b060a751ac96384cd9327eb1b1e36a21fdb71114be07434c0cc7bf63f6e1da274edebfe76f65fbd51ad2f14898b95b");
        this.testSqlApi("SHA2('', 384)", "38b060a751ac96384cd9327eb1b1e36a21fdb71114be07434c0cc7bf63f6e1da274edebfe76f65fbd51ad2f14898b95b");
        this.testSqlApi("SHA384('test')", "768412320f7b0aa5812fce428dc4706b3cae50e02a64caa16a782249bfe8efc4b7ef1ccb126255d196047dfedf17a0a9");
        this.testSqlApi("SHA2('test', 384)", "768412320f7b0aa5812fce428dc4706b3cae50e02a64caa16a782249bfe8efc4b7ef1ccb126255d196047dfedf17a0a9");
        this.testSqlApi("SHA512('')", "cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e");
        this.testSqlApi("SHA2('',512)", "cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e");
        this.testSqlApi("SHA512('test')", "ee26b0dd4af7e749aa1a8ee3c10ae9923f618980772e473f8819a5d4940e0db27ac185f8a0e1d5f84f88bc887fd67b143732c304cc5fa9ad8e6f57f50028a8ff");
        this.testSqlApi("SHA2('test',512)", "ee26b0dd4af7e749aa1a8ee3c10ae9923f618980772e473f8819a5d4940e0db27ac185f8a0e1d5f84f88bc887fd67b143732c304cc5fa9ad8e6f57f50028a8ff");
        this.testSqlApi("MD5(CAST(NULL AS VARCHAR))", "NULL");
        this.testSqlApi("SHA1(CAST(NULL AS VARCHAR))", "NULL");
        this.testSqlApi("SHA224(CAST(NULL AS VARCHAR))", "NULL");
        this.testSqlApi("SHA256(CAST(NULL AS VARCHAR))", "NULL");
        this.testSqlApi("SHA384(CAST(NULL AS VARCHAR))", "NULL");
        this.testSqlApi("SHA512(CAST(NULL AS VARCHAR))", "NULL");
        this.testSqlApi("SHA2(CAST(NULL AS VARCHAR), 256)", "NULL");
    }

    @Test
    public void testNullableCases() {
        this.testSqlApi("TO_BASE64(FROM_BASE64(cast(NUll as varchar)))", this.nullable());
        this.testSqlApi("FROM_BASE64(cast(NUll as varchar))", this.nullable());
    }

    @Override
    public Row testData() {
        return new Row(0);
    }

    @Override
    public RowTypeInfo typeInfo() {
        return new RowTypeInfo(new TypeInformation[0]);
    }

    public SqlExpressionTest() {
        super(ExpressionTestBase$.MODULE$.$lessinit$greater$default$1());
    }
}

