/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.ArrayTypeTestBase;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.math.BigDecimal;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u00113AAC\u0006\u00011!)q\u0004\u0001C\u0001A!)1\u0005\u0001C\u0001I!)a\u0007\u0001C\u0001I!)\u0001\b\u0001C\u0001I!)!\b\u0001C\u0001I!)A\b\u0001C\u0001I!)a\b\u0001C\u0001I!)\u0001\t\u0001C\u0001I!)!\t\u0001C\u0001I\ti\u0011I\u001d:bsRK\b/\u001a+fgRT!\u0001D\u0007\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u001d=\tq\u0001\u001d7b]:,'O\u0003\u0002\u0011#\u0005)A/\u00192mK*\u0011!cE\u0001\u0006M2Lgn\u001b\u0006\u0003)U\ta!\u00199bG\",'\"\u0001\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001I\u0002C\u0001\u000e\u001e\u001b\u0005Y\"B\u0001\u000f\f\u0003\u0015)H/\u001b7t\u0013\tq2DA\tBeJ\f\u0017\u0010V=qKR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#A\u0011\u0011\u0005\t\u0002Q\"A\u0006\u00027Q,7\u000f^%oaV$H+\u001f9f\u000f\u0016tWM]1mSj\fG/[8o)\u0005)\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#\u0001B+oSRD#A\u0001\u0017\u0011\u00055\"T\"\u0001\u0018\u000b\u0005=\u0002\u0014aA1qS*\u0011\u0011GM\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0019T#A\u0003kk:LG/\u0003\u00026]\t!A+Z:u\u0003E!Xm\u001d;BeJ\f\u0017\u0010T5uKJ\fGn\u001d\u0015\u0003\u00071\na\u0002^3ti\u0006\u0013(/Y=GS\u0016dG\r\u000b\u0002\u0005Y\u0005\u0019B/Z:u\u0003J\u0014\u0018-_(qKJ\fG/[8og\"\u0012Q\u0001L\u0001\u0015i\u0016\u001cH/\u0011:sCf$\u0016\u0010]3DCN$\u0018N\\4)\u0005\u0019a\u0013!\t;fgR\f%O]1z\u0013:$W\r_*uCRL7m\u00115fG.4uN\u001d+bE2,\u0007FA\u0004-\u0003}!Xm\u001d;BeJ\f\u00170\u00138eKb\u001cF/\u0019;jG\u000eCWmY6G_J\u001c\u0016\u000f\u001c\u0015\u0003\u00111\nq\u0005^3tiJ+G/\u001e:o\u001dVdGn\u00165f]\u0006\u0013(/Y=J]\u0012,\u0007pT;u\u001f\u001a\u0014u.\u001e8eg\"\u0012\u0011\u0002\f")
public class ArrayTypeTest
extends ArrayTypeTestBase {
    @Test
    public void testInputTypeGeneralization() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.double2Literal(2.0), org.apache.flink.table.api.package$.MODULE$.double2Literal(3.0)})), "ARRAY[1, cast(2.0 AS DOUBLE), cast(3.0 AS DOUBLE)]", "[1.0, 2.0, 3.0]");
    }

    @Test
    public void testArrayLiterals() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.int2Literal(2), org.apache.flink.table.api.package$.MODULE$.int2Literal(3)})), "ARRAY[1, 2, 3]", "[1, 2, 3]");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.boolean2Literal(true), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.boolean2Literal(true), org.apache.flink.table.api.package$.MODULE$.boolean2Literal(true)})), "ARRAY[TRUE, TRUE, TRUE]", "[TRUE, TRUE, TRUE]");
        this.testTableApi(org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.scalaDec2Literal(package$.MODULE$.BigDecimal().apply(1)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.scalaDec2Literal(package$.MODULE$.BigDecimal().apply(1))})), "[1, 1]");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]))})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "ARRAY[ARRAY[ARRAY[1], ARRAY[1]]]", "[[[1], [1]]]");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.int2Literal(2), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.int2Literal(9)})), "ARRAY[1 + 1, 3 * 3]", "[2, 9]");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.INT()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.int2Literal(1)})), "ARRAY[NULLIF(1,1), 1]", "[NULL, 1]");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.INT()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.int2Literal(1)})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "ARRAY[ARRAY[NULLIF(1,1), 1]]", "[[NULL, 1]]");
        this.testTableApi(org.apache.flink.table.api.package$.MODULE$.array2ArrayConstructor((Object)new int[]{1, 2, 3}), "[1, 2, 3]");
        this.testTableApi(org.apache.flink.table.api.package$.MODULE$.array2ArrayConstructor((Object)new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)}), "[1, 2, 3]");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.array2ArrayConstructor((Object)new LocalDate[]{DateTimeTestUtil$.MODULE$.localDate("1985-04-11"), DateTimeTestUtil$.MODULE$.localDate("2018-07-26")}), "ARRAY[DATE '1985-04-11', DATE '2018-07-26']", "[1985-04-11, 2018-07-26]");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.array2ArrayConstructor((Object)new LocalTime[]{DateTimeTestUtil$.MODULE$.localTime("14:15:16"), DateTimeTestUtil$.MODULE$.localTime("17:18:19")}), "ARRAY[TIME '14:15:16', TIME '17:18:19']", "[14:15:16, 17:18:19]");
        this.testTableApi(org.apache.flink.table.api.package$.MODULE$.array2ArrayConstructor((Object)new LocalDateTime[]{DateTimeTestUtil$.MODULE$.localDateTime("1985-04-11 14:15:16"), DateTimeTestUtil$.MODULE$.localDateTime("2018-07-26 17:18:19")}), "[1985-04-11 14:15:16, 2018-07-26 17:18:19]");
        this.testSqlApi("ARRAY[TIMESTAMP '1985-04-11 14:15:16', TIMESTAMP '2018-07-26 17:18:19']", "[1985-04-11 14:15:16, 2018-07-26 17:18:19]");
        this.testTableApi(org.apache.flink.table.api.package$.MODULE$.array2ArrayConstructor((Object)new LocalDateTime[]{LocalDateTime.of(1985, 4, 11, 14, 15, 16, 123456789), LocalDateTime.of(2018, 7, 26, 17, 18, 19, 123456789)}), "[1985-04-11 14:15:16.123456789, 2018-07-26 17:18:19.123456789]");
        this.testTableApi(org.apache.flink.table.api.package$.MODULE$.array2ArrayConstructor((Object)new LocalDateTime[]{LocalDateTime.of(1985, 4, 11, 14, 15, 16, 123456700), LocalDateTime.of(2018, 7, 26, 17, 18, 19, 123456700)}), "[1985-04-11 14:15:16.1234567, 2018-07-26 17:18:19.1234567]");
        this.testTableApi(org.apache.flink.table.api.package$.MODULE$.array2ArrayConstructor((Object)new LocalDateTime[]{LocalDateTime.of(1985, 4, 11, 14, 15, 16, 123456000), LocalDateTime.of(2018, 7, 26, 17, 18, 19, 123456000)}), "[1985-04-11 14:15:16.123456, 2018-07-26 17:18:19.123456]");
        this.testTableApi(org.apache.flink.table.api.package$.MODULE$.array2ArrayConstructor((Object)new LocalDateTime[]{LocalDateTime.of(1985, 4, 11, 14, 15, 16, 123400000), LocalDateTime.of(2018, 7, 26, 17, 18, 19, 123400000)}), "[1985-04-11 14:15:16.1234, 2018-07-26 17:18:19.1234]");
        this.testSqlApi("ARRAY[TIMESTAMP '1985-04-11 14:15:16.123456789', TIMESTAMP '2018-07-26 17:18:19.123456789']", "[1985-04-11 14:15:16.123456789, 2018-07-26 17:18:19.123456789]");
        this.testSqlApi("ARRAY[TIMESTAMP '1985-04-11 14:15:16.1234567', TIMESTAMP '2018-07-26 17:18:19.1234567']", "[1985-04-11 14:15:16.1234567, 2018-07-26 17:18:19.1234567]");
        this.testSqlApi("ARRAY[TIMESTAMP '1985-04-11 14:15:16.123456', TIMESTAMP '2018-07-26 17:18:19.123456']", "[1985-04-11 14:15:16.123456, 2018-07-26 17:18:19.123456]");
        this.testSqlApi("ARRAY[TIMESTAMP '1985-04-11 14:15:16.1234', TIMESTAMP '2018-07-26 17:18:19.1234']", "[1985-04-11 14:15:16.1234, 2018-07-26 17:18:19.1234]");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.array2ArrayConstructor((Object)new BigDecimal[]{package$.MODULE$.BigDecimal().apply(2.0002), package$.MODULE$.BigDecimal().apply(2.0003)}), "ARRAY[CAST(2.0002 AS DECIMAL(10,4)), CAST(2.0003 AS DECIMAL(10,4))]", "[2.0002, 2.0003]");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.array2ArrayConstructor((Object)((Object[])new boolean[][]{{true}})), "ARRAY[ARRAY[TRUE]]", "[[TRUE]]");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.array2ArrayConstructor((Object)((Object[])new int[][]{{1, 2, 3}, {3, 2, 1}})), "ARRAY[ARRAY[1, 2, 3], ARRAY[3, 2, 1]]", "[[1, 2, 3], [3, 2, 1]]");
        this.testSqlApi("ARRAY[CAST(1 AS DOUBLE), CAST(2 AS FLOAT)]", "[1.0, 2.0]");
    }

    @Test
    public void testArrayField() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))})), "ARRAY[f0, f1]", "[NULL, 42]");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))})), "ARRAY[f0, f1]", "[NULL, 42]");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")), "f2", "[1, 2, 3]");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")), "f3", "[1984-03-12, 1984-02-10]");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")), "f5", "[[1, 2, 3], NULL]");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")), "f6", "[1, NULL, NULL, 4]");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")), "f2", "[1, 2, 3]");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "f2[1]", "1");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).at((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "f3[1]", "1984-03-12");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).at((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), "f3[2]", "1984-02-10");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).at((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1))).at((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), "f5[1][2]", "2");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).at((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2))).at((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), "f5[2][2]", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).at((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2))).at((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), "f4[2][2]", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).at((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "f11[1]", "1");
    }

    @Test
    public void testArrayOperations() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).cardinality(), "CARDINALITY(f2)", "3");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).cardinality(), "CARDINALITY(f4)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).cardinality(), "CARDINALITY(f11)", "1");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9")).element(), "ELEMENT(f9)", "1");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).element(), "ELEMENT(f8)", "4.0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f10")).element(), "ELEMENT(f10)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).element(), "ELEMENT(f4)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).element(), "ELEMENT(f11)", "1");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$eq$eq$eq((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).at((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1))), "f2 = f5[1]", "TRUE");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.array(org.apache.flink.table.api.package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.int2Literal(2), org.apache.flink.table.api.package$.MODULE$.int2Literal(3)}))), "f6 = ARRAY[1, 2, 3]", "FALSE");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$bang$eq$eq((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).at((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1))), "f2 <> f5[1]", "FALSE");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "f2 = f7", "FALSE");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$bang$eq$eq(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "f2 <> f7", "TRUE");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11"))), "f11 = f11", "TRUE");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9"))), "f11 = f9", "TRUE");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).$bang$eq$eq(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11"))), "f11 <> f11", "FALSE");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).$bang$eq$eq(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9"))), "f11 <> f9", "FALSE");
    }

    @Test
    public void testArrayTypeCasting() {
        this.testTableApi((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).cast(DataTypes.ARRAY((DataType)DataTypes.DATE())), "[1984-03-12, 1984-02-10]");
    }

    @Test
    public void testArrayIndexStaticCheckForTable() {
        Assertions.assertThatThrownBy(() -> this.testTableApi((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(0)), "1")).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"The provided index must be a valid SQL index starting from 1")});
    }

    @Test
    public void testArrayIndexStaticCheckForSql() {
        this.testExpectedSqlException("f2[0]", "Array element access needs an index starting at 1 but was 0.", this.testExpectedSqlException$default$3());
    }

    @Test
    public void testReturnNullWhenArrayIndexOutOfBounds() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(4)), "f2[4]", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).at((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(3)), "f11[4]", "NULL");
    }
}

