/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.table.api.SqlParserEOFException;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.delegation.ParserImpl;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ParserImplTest {
    private final PlannerMocks plannerMocks = PlannerMocks.create(true);
    private final Supplier<FlinkPlannerImpl> plannerSupplier = this.plannerMocks::getPlanner;
    private final Parser parser = new ParserImpl(this.plannerMocks.getCatalogManager(), this.plannerSupplier, () -> this.plannerSupplier.get().parser(), this.plannerMocks.getPlannerContext().getRexFactory());
    private static final List<TestSpec> TEST_SPECS = Arrays.asList(TestSpec.forStatement("ClEaR").summary("CLEAR"), TestSpec.forStatement("hElP").summary("HELP"), TestSpec.forStatement("qUIT").summary("QUIT"), TestSpec.forStatement("ExIT").summary("QUIT"), TestSpec.forStatement("REsEt").summary("RESET"), TestSpec.forStatement("REsEt execution.runtime-type").summary("RESET execution.runtime-type"), TestSpec.forStatement("   SEt ").summary("SET"), TestSpec.forStatement("SET execution.runtime-type=batch").summary("SET execution.runtime-type=batch"), TestSpec.forStatement("SET pipeline.jars = /path/to/test-_-jar.jar").summary("SET pipeline.jars=/path/to/test-_-jar.jar"), TestSpec.forStatement("USE test.db1").summary("USE test.db1"), TestSpec.forStatement("SHOW tables").summary("SHOW TABLES"), TestSpec.forStatement("SET pipeline.name = 'test name'").summary("SET pipeline.name=test name"), TestSpec.forStatement("SET pipeline.name = ' '").summary("SET pipeline.name= "), TestSpec.forStatement("SET execution.runtime-type=").error("SQL parse failed. Encountered \"execution\" at line 1, column 5"));

    ParserImplTest() {
    }

    @Test
    void testParseLegalStatements() {
        for (TestSpec spec : TEST_SPECS) {
            if (spec.expectedSummary != null) {
                Operation op = (Operation)this.parser.parse(spec.statement).get(0);
                Assertions.assertThat((String)op.asSummaryString()).isEqualTo(spec.expectedSummary);
            }
            if (spec.expectedError == null) continue;
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parser.parse(spec.statement)).isInstanceOf(SqlParserException.class)).hasMessageContaining(spec.expectedError);
        }
    }

    @Test
    void testPartialParse() {
        Assertions.assertThatThrownBy(() -> this.parser.parse("select A From")).isInstanceOf(SqlParserEOFException.class);
    }

    @Test
    void testPartialParseWithStatementSet() {
        Assertions.assertThatThrownBy(() -> this.parser.parse("Execute Statement Set Begin insert into A select * from B")).isInstanceOf(SqlParserEOFException.class);
    }

    @Test
    void testCompletionTest() {
        this.verifySqlCompletion("QU", 1, new String[]{"QUIT"});
        this.verifySqlCompletion("SE", 1, new String[]{"SET"});
        this.verifySqlCompletion("", 0, new String[]{"CLEAR", "HELP", "EXIT", "QUIT", "RESET", "SET"});
        this.verifySqlCompletion("SELECT a fram b", 10, new String[]{"FETCH", "FROM"});
    }

    private void verifySqlCompletion(String statement, int position, String[] expectedHints) {
        Object[] hints = this.parser.getCompletionHints(statement, position);
        Assertions.assertThat((Object[])hints).isEqualTo((Object)expectedHints);
    }

    static class TestSpec {
        private final String statement;
        @Nullable
        private String expectedSummary;
        @Nullable
        private String expectedError;

        private TestSpec(String statement) {
            this.statement = statement;
        }

        static TestSpec forStatement(String statement) {
            return new TestSpec(statement);
        }

        TestSpec summary(String expectedSummary) {
            this.expectedSummary = expectedSummary;
            return this;
        }

        TestSpec error(String expectedError) {
            this.expectedError = expectedError;
            return this;
        }
    }
}

