/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.agg.batch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.OneInputStreamTask;
import org.apache.flink.streaming.runtime.tasks.OneInputStreamTaskTestHarness;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.planner.codegen.agg.AggTestBase;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.util.RowDataTestUtil;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.util.function.FunctionWithException;
import org.assertj.core.api.Assertions;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m3QAB\u0004\u0002\u0002aAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013\u0005!\u0005\u0003\u0004,\u0001\u0001\u0006Ia\t\u0005\u0006Y\u0001!\t!\f\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0002\u0011\u0005\u0006$8\r[!hOR+7\u000f\u001e\"bg\u0016T!\u0001C\u0005\u0002\u000b\t\fGo\u00195\u000b\u0005)Y\u0011aA1hO*\u0011A\"D\u0001\bG>$WmZ3o\u0015\tqq\"A\u0004qY\u0006tg.\u001a:\u000b\u0005A\t\u0012!\u0002;bE2,'B\u0001\n\u0014\u0003\u00151G.\u001b8l\u0015\t!R#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002-\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0007\t\u00035mi\u0011!C\u0005\u00039%\u00111\"Q4h)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011aB\u0001\u0011O2|'-\u00197PkR\u0004X\u000f\u001e+za\u0016,\u0012a\t\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nq\u0001\\8hS\u000e\fGN\u0003\u0002)\u001f\u0005)A/\u001f9fg&\u0011!&\n\u0002\b%><H+\u001f9f\u0003E9Gn\u001c2bY>+H\u000f];u)f\u0004X\rI\u0001\u0004e><HC\u0001\u00185!\ty#'D\u00011\u0015\t\tt\"\u0001\u0003eCR\f\u0017BA\u001a1\u000599UM\\3sS\u000e\u0014vn\u001e#bi\u0006DQ!\u000e\u0003A\u0002Y\nA!\u0019:hgB\u0019qG\u000f\u001f\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?!\t9T(\u0003\u0002?q\t\u0019\u0011I\\=\u0002\u0019Q,7\u000f^(qKJ\fGo\u001c:\u0015\t\u0005#5\u000b\u0017\t\u0003o\tK!a\u0011\u001d\u0003\tUs\u0017\u000e\u001e\u0005\u0006k\u0015\u0001\r!\u0012\t\u0006o\u0019C5eI\u0005\u0003\u000fb\u0012a\u0001V;qY\u0016\u001c\u0004cA%O!6\t!J\u0003\u0002L\u0019\u0006Iq\u000e]3sCR|'o\u001d\u0006\u0003\u001b>\tqA];oi&lW-\u0003\u0002P\u0015\n12i\u001c3f\u000f\u0016tw\n]3sCR|'OR1di>\u0014\u0018\u0010\u0005\u00020#&\u0011!\u000b\r\u0002\b%><H)\u0019;b\u0011\u0015!V\u00011\u0001V\u0003\u0015Ig\u000e];u!\r9d\u000bU\u0005\u0003/b\u0012Q!\u0011:sCfDQ!W\u0003A\u0002i\u000ba\"\u001a=qK\u000e$X\rZ(viB,H\u000fE\u00028-:\u0002")
public abstract class BatchAggTestBase
extends AggTestBase {
    private final RowType globalOutputType = RowType.of((LogicalType[])((LogicalType[])((Object[])new LogicalType[]{VarCharType.STRING_TYPE, VarCharType.STRING_TYPE, new BigIntType(), new DoubleType(), new BigIntType()})), (String[])((String[])((Object[])new String[]{"f0", "f4", "agg1Output", "agg2Output", "agg3Output"})));

    public RowType globalOutputType() {
        return this.globalOutputType;
    }

    public GenericRowData row(Seq<Object> args) {
        return GenericRowData.of((Object[])((Object[])((TraversableOnce)args.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object = x0$1;
            if (object instanceof String) {
                String string = (String)object;
                return StringData.fromString((String)string);
            }
            if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                return BoxesRunTime.boxToLong((long)l);
            }
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                return BoxesRunTime.boxToDouble((double)d);
            }
            if (object instanceof Object) {
                Object object2 = object;
                return object2;
            }
            throw new MatchError(object);
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.AnyRef())));
    }

    public void testOperator(Tuple3<CodeGenOperatorFactory<RowData>, RowType, RowType> args, RowData[] input, GenericRowData[] expectedOutput) {
        OneInputStreamTaskTestHarness testHarness = new OneInputStreamTaskTestHarness((FunctionWithException)new FunctionWithException<Environment, OneInputStreamTask<RowData, RowData>, Exception>(null){

            public OneInputStreamTask<RowData, RowData> apply(Environment t) {
                return new OneInputStreamTask(t);
            }
        }, 1, 1, (TypeInformation)InternalTypeInfo.of((RowType)((RowType)args._2())), (TypeInformation)InternalTypeInfo.of((RowType)((RowType)args._3())));
        testHarness.memorySize = 0x320000L;
        testHarness.setupOutputForSingletonOperatorChain();
        StreamConfig streamConfig = testHarness.getStreamConfig();
        streamConfig.setStreamOperatorFactory((StreamOperatorFactory)args._1());
        streamConfig.setOperatorID(new OperatorID());
        streamConfig.setManagedMemoryFractionOperatorOfUseCase(ManagedMemoryUseCase.OPERATOR, 0.99);
        testHarness.invoke();
        testHarness.waitForTaskRunning();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])input)).foreach((Function1 & Serializable & scala.Serializable)row -> {
            testHarness.processElement((Object)new StreamRecord((Object)row, 0L));
            return BoxedUnit.UNIT;
        });
        testHarness.waitForInputProcessing();
        testHarness.endInput();
        testHarness.waitForTaskCompletion();
        ArrayList<GenericRowData> outputs = new ArrayList<GenericRowData>();
        LinkedBlockingQueue outQueue = testHarness.getOutput();
        while (!outQueue.isEmpty()) {
            outputs.add(RowDataTestUtil.toGenericRowDeeply((RowData)((RowData)((StreamRecord)outQueue.poll()).getValue()), (List)((RowType)args._3()).getChildren()));
        }
        Assertions.assertThat((Object[])((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(outputs).asScala()).toArray(ClassTag$.MODULE$.AnyRef()))).isEqualTo(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedOutput)).toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public BatchAggTestBase() {
        super(true);
    }
}

