/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import org.apache.flink.table.functions.SqlLikeUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FlinkSqlLikeUtilsTest {
    FlinkSqlLikeUtilsTest() {
    }

    @Test
    void testSqlLike() {
        Assertions.assertThat((boolean)SqlLikeUtils.like((String)"abc", (String)"a.c", (String)"\\")).isEqualTo(false);
        Assertions.assertThat((boolean)SqlLikeUtils.like((String)"a.c", (String)"a.c", (String)"\\")).isEqualTo(true);
        Assertions.assertThat((boolean)SqlLikeUtils.like((String)"abcd", (String)"a.*d", (String)"\\")).isEqualTo(false);
        Assertions.assertThat((boolean)SqlLikeUtils.like((String)"abcde", (String)"%c.e", (String)"\\")).isEqualTo(false);
        Assertions.assertThat((boolean)SqlLikeUtils.like((String)"a-c", (String)"a\\_c")).isEqualTo(false);
        Assertions.assertThat((boolean)SqlLikeUtils.like((String)"a_c", (String)"a\\_c")).isEqualTo(true);
        Assertions.assertThat((String)SqlLikeUtils.sqlToRegexLike((String)".", (CharSequence)"\\")).isEqualTo("\\.");
        Assertions.assertThat((String)SqlLikeUtils.sqlToRegexLike((String)"c", (CharSequence)"\\")).isEqualTo("c");
        Assertions.assertThat((String)SqlLikeUtils.sqlToRegexLike((String)"_", (CharSequence)"\\")).isEqualTo(".");
        Assertions.assertThat((String)SqlLikeUtils.sqlToRegexLike((String)"%", (CharSequence)"\\")).isEqualTo("(?s:.*)");
        Assertions.assertThat((String)SqlLikeUtils.sqlToRegexLike((String)"\\_", (CharSequence)"\\")).isEqualTo("_");
        Assertions.assertThat((String)SqlLikeUtils.sqlToRegexLike((String)"\\%", (CharSequence)"\\")).isEqualTo("%");
        Assertions.assertThat((String)SqlLikeUtils.sqlToRegexLike((String)"\\\\", (CharSequence)"\\")).isEqualTo("\\\\");
        Assertions.assertThat((String)SqlLikeUtils.sqlToRegexLike((String)"&&", (CharSequence)"&")).isEqualTo("&");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlLikeUtils.sqlToRegexLike((String)"\\a", (CharSequence)"\\")).isInstanceOf(RuntimeException.class)).hasMessageContaining("Invalid escape");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlLikeUtils.sqlToRegexLike((String)"\\", (CharSequence)"\\")).isInstanceOf(RuntimeException.class)).hasMessageContaining("Invalid escape");
        Assertions.assertThat((boolean)SqlLikeUtils.similar((String)"abc", (String)"a.c", (String)"\\")).isEqualTo(true);
        Assertions.assertThat((boolean)SqlLikeUtils.similar((String)"a.c", (String)"a.c", (String)"\\")).isEqualTo(true);
        Assertions.assertThat((boolean)SqlLikeUtils.similar((String)"abcd", (String)"a.*d", (String)"\\")).isEqualTo(true);
    }
}

