/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.analyze;

import java.time.Duration;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.AggregatePhaseStrategy;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.PlanKind;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Enumeration;
import scala.Function0;
import scala.runtime.BoxedUnit;

@ExtendWith(value={ParameterizedTestExtension.class})
class GroupAggregationAnalyzerTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(TableConfig.getDefault());
    @Parameter
    private boolean isMiniBatchEnabled;
    @Parameter(value=1)
    private AggregatePhaseStrategy strategy;
    @Parameter(value=2)
    private long miniBatchLatency;
    @Parameter(value=3)
    private long miniBatchSize;
    private final String query = "SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM MyTable";

    GroupAggregationAnalyzerTest() {
    }

    @BeforeEach
    void before() {
        this.util.getTableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)this.isMiniBatchEnabled).set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)this.strategy).set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(this.miniBatchLatency)).set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)this.miniBatchSize);
        this.util.getTableEnv().executeSql("CREATE TABLE MyTable (\n  a BIGINT,\n  b INT NOT NULL,\n  c VARCHAR,\n  d BIGINT\n) WITH (\n  'connector' = 'values',\n  'bounded' = 'false')");
        this.util.getTableEnv().executeSql("CREATE TABLE MySink (\n  avg_a DOUBLE,\n  cnt BIGINT,\n  cnt_b BIGINT,\n  min_b BIGINT,\n  max_c VARCHAR\n) WITH (\n  'connector' = 'values',\n  'sink-insert-only' = 'false')");
    }

    @TestTemplate
    void testSelect() {
        this.util.doVerifyPlan("SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM MyTable", new ExplainDetail[]{ExplainDetail.PLAN_ADVICE}, false, new Enumeration.Value[]{PlanKind.OPT_REL_WITH_ADVICE()}, false);
    }

    @TestTemplate
    void testInsertInto() {
        this.util.doVerifyPlanInsert(String.format("INSERT INTO MySink\n%s", "SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM MyTable"), new ExplainDetail[]{ExplainDetail.PLAN_ADVICE}, false, new Enumeration.Value[]{PlanKind.OPT_REL_WITH_ADVICE()});
    }

    @TestTemplate
    void testStatementSet() {
        StatementSet stmtSet = this.util.getTableEnv().createStatementSet();
        this.util.getTableEnv().executeSql("CREATE TABLE MySink2 LIKE MySink");
        this.util.getTableEnv().executeSql("CREATE TABLE MySink3 (\n  b INT NOT NULL,\n  sum_a BIGINT,\n  cnt_c BIGINT\n  ) WITH (\n  'connector' = 'values',\n  'sink-insert-only' = 'false')");
        stmtSet.addInsertSql(String.format("INSERT INTO MySink\n%s", "SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM MyTable"));
        stmtSet.addInsertSql(String.format("INSERT INTO MySink2\n%s", "SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM MyTable"));
        stmtSet.addInsertSql("INSERT INTO MySink3\nSELECT \n  b, \n  SUM(a) AS sum_a,\n  COUNT(c) AS cnt_c\nFROM MyTable\nGROUP BY b");
        this.util.doVerifyPlan(stmtSet, new ExplainDetail[]{ExplainDetail.PLAN_ADVICE}, false, new Enumeration.Value[]{PlanKind.OPT_REL_WITH_ADVICE()}, (Function0<BoxedUnit>)((Function0)() -> BoxedUnit.UNIT), false);
    }

    @TestTemplate
    void testSubplanReuse() {
        this.util.doVerifyPlan("WITH r AS (SELECT c, SUM(a) a, SUM(b) b FROM MyTable GROUP BY c)\nSELECT * FROM r r1, r r2 WHERE r1.a = CAST(r2.b AS BIGINT) AND r2.a > 1", new ExplainDetail[]{ExplainDetail.PLAN_ADVICE}, false, new Enumeration.Value[]{PlanKind.OPT_REL_WITH_ADVICE()}, false);
    }

    @TestTemplate
    void testUserDefinedAggCalls() {
        StatementSet stmtSet = this.util.getTableEnv().createStatementSet();
        this.util.addTemporarySystemFunction("weightedAvg", JavaUserDefinedAggFunctions.WeightedAvgWithMerge.class);
        this.util.addTemporarySystemFunction("weightedAvgWithoutMerge", JavaUserDefinedAggFunctions.WeightedAvg.class);
        this.util.getTableEnv().executeSql("CREATE TABLE MySink1 (\n  avg_a_1 DOUBLE\n) WITH (\n  'connector' = 'values',\n  'sink-insert-only' = 'false')");
        this.util.getTableEnv().executeSql("CREATE TABLE MySink2 (avg_a_2 DOUBLE) LIKE MySink1");
        stmtSet.addInsertSql("INSERT INTO MySink1\nSELECT \n  weightedAvg(a, d) AS avg_a_1\nFROM MyTable");
        stmtSet.addInsertSql("INSERT INTO MySink2\nSELECT \n  weightedAvg(a, d) AS avg_a_1,\n  weightedAvgWithoutMerge(a, d) AS avg_a_2\nFROM MyTable");
        this.util.doVerifyPlan(stmtSet, new ExplainDetail[]{ExplainDetail.PLAN_ADVICE}, false, new Enumeration.Value[]{PlanKind.OPT_REL_WITH_ADVICE()}, (Function0<BoxedUnit>)((Function0)() -> BoxedUnit.UNIT), false);
    }

    @Parameters(name="isMiniBatchEnabled={0}, strategy={1}, miniBatchLatency={2}, miniBatchSize={3}")
    private static Object[][] data() {
        return new Object[][]{{true, AggregatePhaseStrategy.ONE_PHASE, 10L, 5L}, {true, AggregatePhaseStrategy.AUTO, 10L, 5L}, {false, AggregatePhaseStrategy.ONE_PHASE, 0L, -1L}, {false, AggregatePhaseStrategy.AUTO, 10L, 5L}};
    }
}

