/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.stream.sql.validation;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.stream.sql.validation.OverWindowValidationTest$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.ScalaStreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001}2AAB\u0004\u00011!)\u0011\u0005\u0001C\u0001E!9Q\u0005\u0001b\u0001\n\u00131\u0003B\u0002\u0016\u0001A\u0003%q\u0005C\u0003,\u0001\u0011\u0005A\u0006C\u0003>\u0001\u0011\u0005AF\u0001\rPm\u0016\u0014x+\u001b8e_^4\u0016\r\\5eCRLwN\u001c+fgRT!\u0001C\u0005\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0002\u000b\u0017\u0005\u00191/\u001d7\u000b\u00051i\u0011AB:ue\u0016\fWN\u0003\u0002\u000f\u001f\u0005\u0019\u0011\r]5\u000b\u0005A\t\u0012!\u0002;bE2,'B\u0001\n\u0014\u0003\u00151G.\u001b8l\u0015\t!R#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002-\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0007\t\u00035}i\u0011a\u0007\u0006\u00039u\tQ!\u001e;jYNT!AH\b\u0002\u000fAd\u0017M\u001c8fe&\u0011\u0001e\u0007\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005\u0019\u0003C\u0001\u0013\u0001\u001b\u00059\u0011AC:ue\u0016\fW.\u0016;jYV\tq\u0005\u0005\u0002\u001bQ%\u0011\u0011f\u0007\u0002\u0019'\u000e\fG.Y*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0017aC:ue\u0016\fW.\u0016;jY\u0002\nq\u0002^3ti6+H\u000e^5XS:$wn\u001e\u000b\u0002[A\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t!QK\\5uQ\t!A\u0007\u0005\u00026w5\taG\u0003\u0002\u000fo)\u0011\u0001(O\u0001\bUV\u0004\u0018\u000e^3s\u0015\tQT#A\u0003kk:LG/\u0003\u0002=m\t!A+Z:u\u0003i!Xm\u001d;J]Z\fG.\u001b3Pm\u0016\u0014\u0018iZ4sK\u001e\fG/[8oQ\t)A\u0007")
public class OverWindowValidationTest
extends TableTestBase {
    private final ScalaStreamTableTestUtil streamUtil = this.scalaStreamTestUtil();

    private ScalaStreamTableTestUtil streamUtil() {
        return this.streamUtil;
    }

    @Test
    public void testMultiWindow() {
        String sqlQuery = "SELECT c, count(a) OVER (PARTITION BY c ORDER BY proctime RANGE UNBOUNDED preceding), sum(a) OVER (PARTITION BY b ORDER BY proctime RANGE UNBOUNDED preceding) from T1";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.streamUtil().tableEnv().sqlQuery(sqlQuery)).toDataStream());
    }

    @Test
    public void testInvalidOverAggregation() {
        this.streamUtil().addTemporarySystemFunction("overAgg", (UserDefinedFunction)new JavaUserDefinedAggFunctions.OverAgg0());
        String sqlQuery = "SELECT overAgg(c, a) FROM MyTable";
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.streamUtil().tableEnv().sqlQuery(sqlQuery));
    }

    public OverWindowValidationTest() {
        this.streamUtil().addDataStream("T1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.stream.sql.validation.OverWindowValidationTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }
}

