/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.stream;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import java.time.Duration;
import java.util.Collection;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.stream.ExplainTest$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.utils.TestSinkUtil$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.DataType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001\u0002\u000f\u001e\u0001)B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0006u\u0001!\ta\u000f\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003A\u0011\u0019A\u0005\u0001)A\u0005\u0003\"9\u0011\n\u0001b\u0001\n\u0013Q\u0005B\u0002(\u0001A\u0003%1\nC\u0004P\u0001\t\u0007I\u0011\u0001)\t\r]\u0003\u0001\u0015!\u0003R\u0011\u001dA\u0006A1A\u0005\u0002ACa!\u0017\u0001!\u0002\u0013\t\u0006b\u0002.\u0001\u0005\u0004%\t\u0001\u0015\u0005\u00077\u0002\u0001\u000b\u0011B)\t\u000bq\u0003A\u0011A/\t\u000b-\u0004A\u0011A/\t\u000bA\u0004A\u0011A/\t\u000bI\u0004A\u0011A/\t\u000bQ\u0004A\u0011A/\t\u000bY\u0004A\u0011A/\t\u000ba\u0004A\u0011A/\t\u000bi\u0004A\u0011A/\t\u000bq\u0004A\u0011A/\t\u000by\u0004A\u0011A/\t\r\u0005\u0005\u0001\u0001\"\u0001^\u000f\u001d\ty#\bE\u0001\u0003c1a\u0001H\u000f\t\u0002\u0005M\u0002B\u0002\u001e\u001a\t\u0003\tY\u0004C\u0004\u0002>e!\t!a\u0010\u0003\u0017\u0015C\b\u000f\\1j]R+7\u000f\u001e\u0006\u0003=}\taa\u001d;sK\u0006l'B\u0001\u0011\"\u0003\r\t\u0007/\u001b\u0006\u0003E\r\nQ\u0001^1cY\u0016T!\u0001J\u0013\u0002\u000b\u0019d\u0017N\\6\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0002\u0001'\t\u00011\u0006\u0005\u0002-c5\tQF\u0003\u0002/_\u0005)Q\u000f^5mg*\u0011\u0001'I\u0001\ba2\fgN\\3s\u0013\t\u0011TFA\u0007UC\ndW\rV3ti\n\u000b7/Z\u0001\tKb$XM\u001c3fIB\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u0002=}A\u0011Q\bA\u0007\u0002;!)1G\u0001a\u0001i\u0005aQ\r\u001f;sC\u0012+G/Y5mgV\t\u0011\tE\u00026\u0005\u0012K!a\u0011\u001c\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u00153U\"A\u0010\n\u0005\u001d{\"!D#ya2\f\u0017N\u001c#fi\u0006LG.A\u0007fqR\u0014\u0018\rR3uC&d7\u000fI\u0001\u0005kRLG.F\u0001L!\taC*\u0003\u0002N[\t\u00192\u000b\u001e:fC6$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\u0006)Q\u000f^5mA\u000511\u000b\u0016*J\u001d\u001e+\u0012!\u0015\t\u0003%Vk\u0011a\u0015\u0006\u0003)\u0006\nQ\u0001^=qKNL!AV*\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fqa\u0015+S\u0013:;\u0005%\u0001\u0003M\u001f:;\u0015!\u0002'P\u001d\u001e\u0003\u0013aA%O)\u0006!\u0011J\u0014+!\u0003\u0019\u0011WMZ8sKR\ta\f\u0005\u00026?&\u0011\u0001M\u000e\u0002\u0005+:LG\u000f\u000b\u0002\u000eEB\u00111-[\u0007\u0002I*\u0011\u0001%\u001a\u0006\u0003M\u001e\fqA[;qSR,'O\u0003\u0002iO\u0005)!.\u001e8ji&\u0011!\u000e\u001a\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017A\u0007;fgR,\u0005\u0010\u001d7bS:$\u0016M\u00197f'>,(oY3TG\u0006t\u0007F\u0001\bn!\t\u0019g.\u0003\u0002pI\naA+Z:u)\u0016l\u0007\u000f\\1uK\u0006IB/Z:u\u000bb\u0004H.Y5o\t\u0006$\u0018m\u0015;sK\u0006l7kY1oQ\tyQ.A\u000buKN$X\t\u001f9mC&tw+\u001b;i\r&dG/\u001a:)\u0005Ai\u0017A\u0005;fgR,\u0005\u0010\u001d7bS:<\u0016\u000e\u001e5BO\u001eD#!E7\u0002'Q,7\u000f^#ya2\f\u0017N\\,ji\"Tu.\u001b8)\u0005Ii\u0017\u0001\u0006;fgR,\u0005\u0010\u001d7bS:<\u0016\u000e\u001e5V]&|g\u000e\u000b\u0002\u0014[\u0006\u0019B/Z:u\u000bb\u0004H.Y5o/&$\bnU8si\"\u0012A#\\\u0001\u001ai\u0016\u001cH/\u0012=qY\u0006LgnV5uQNKgn\u001a7f'&t7\u000e\u000b\u0002\u0016[\u0006IB/Z:u\u000bb\u0004H.Y5o/&$\b.T;mi&\u001c\u0016N\\6tQ\t1R.\u0001\u000euKN$X*\u001b8j\u0005\u0006$8\r[%oi\u0016\u0014h/\u00197J]\u001a,'\u000f\u000b\u0002\u0018[\":\u0001!a\u0002\u0002\u0014\u0005U\u0001\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055A-A\u0005fqR,gn]5p]&!\u0011\u0011CA\u0006\u0005))\u0005\u0010^3oI^KG\u000f[\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003/\u0019#!!\u0007\u0011\t\u0005m\u00111F\u0007\u0003\u0003;QA!a\b\u0002\"\u0005i\u0001/\u0019:b[\u0016$XM]5{K\u0012TA!a\t\u0002&\u0005QQ\r\u001f;f]NLwN\\:\u000b\u0007!\f9CC\u0002\u0002*\r\n\u0011\u0002^3tiV$\u0018\u000e\\:\n\t\u00055\u0012Q\u0004\u0002\u001b!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$X\t\u001f;f]NLwN\\\u0001\f\u000bb\u0004H.Y5o)\u0016\u001cH\u000f\u0005\u0002>3M\u0019\u0011$!\u000e\u0011\u0007U\n9$C\u0002\u0002:Y\u0012a!\u00118z%\u00164GCAA\u0019\u0003)\u0001\u0018M]1nKR,'o\u001d\u000b\u0003\u0003\u0003\u0002R!a\u0011\u0002LQj!!!\u0012\u000b\u0007%\u000b9E\u0003\u0002\u0002J\u0005!!.\u0019<b\u0013\u0011\ti%!\u0012\u0003\u0015\r{G\u000e\\3di&|g\u000eK\u0004\u001c\u0003#\n9&!\u0017\u0011\t\u0005m\u00111K\u0005\u0005\u0003+\niB\u0001\u0006QCJ\fW.\u001a;feN\fAA\\1nK\u0006\u0012\u00111L\u0001\rKb$XM\u001c3fIvZ\b' ")
public class ExplainTest
extends TableTestBase {
    private final ExplainDetail[] extraDetails;
    private final StreamTableTestUtil util;
    private final DataType STRING;
    private final DataType LONG;
    private final DataType INT;

    @Parameters(name="extended={0}")
    public static Collection<Object> parameters() {
        return ExplainTest$.MODULE$.parameters();
    }

    private ExplainDetail[] extraDetails() {
        return this.extraDetails;
    }

    private StreamTableTestUtil util() {
        return this.util;
    }

    public DataType STRING() {
        return this.STRING;
    }

    public DataType LONG() {
        return this.LONG;
    }

    public DataType INT() {
        return this.INT;
    }

    @BeforeEach
    public void before() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)4));
    }

    @TestTemplate
    public void testExplainTableSourceScan() {
        this.util().verifyExplain("SELECT * FROM MyTable", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainDataStreamScan() {
        this.util().verifyExplain("SELECT * FROM MyTable1", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithFilter() {
        this.util().verifyExplain("SELECT * FROM MyTable1 WHERE mod(a, 2) = 0", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithAgg() {
        this.util().verifyExplain("SELECT COUNT(*) FROM MyTable1 GROUP BY a", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithJoin() {
        this.util().verifyExplain("SELECT a, b, c, e, f FROM MyTable1, MyTable2 WHERE a = d", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithUnion() {
        this.util().verifyExplain("SELECT * FROM MyTable1 UNION ALL SELECT * FROM MyTable2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithSort() {
        this.util().verifyExplain("SELECT * FROM MyTable1 ORDER BY a LIMIT 5", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithSingleSink() {
        Table table = this.util().tableEnv().sqlQuery("SELECT * FROM MyTable1 WHERE a > 10");
        TestSinkUtil$.MODULE$.addValuesSink(this.util().tableEnv(), "appendSink", (List<String>)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), (List<DataType>)new .colon.colon((Object)this.INT(), (List)new .colon.colon((Object)this.LONG(), (List)new .colon.colon((Object)this.STRING(), (List)Nil$.MODULE$))), ChangelogMode.insertOnly(), TestSinkUtil$.MODULE$.addValuesSink$default$6());
        this.util().verifyExplainInsert(table, "appendSink", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithMultiSinks() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        Table table = this.util().tableEnv().sqlQuery("SELECT a, COUNT(*) AS cnt FROM MyTable1 GROUP BY a");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        Table table1 = this.util().tableEnv().sqlQuery("SELECT * FROM TempTable WHERE cnt > 10");
        TestSinkUtil$.MODULE$.addValuesSink(this.util().tableEnv(), "upsertSink1", (List<String>)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"cnt", (List)Nil$.MODULE$)), (List<DataType>)new .colon.colon((Object)this.INT(), (List)new .colon.colon((Object)this.LONG(), (List)Nil$.MODULE$)), ChangelogMode.upsert(), (List<String>)new .colon.colon((Object)"a", (List)Nil$.MODULE$));
        stmtSet.addInsert("upsertSink1", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT * FROM TempTable WHERE cnt < 10");
        TestSinkUtil$.MODULE$.addValuesSink(this.util().tableEnv(), "upsertSink2", (List<String>)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"cnt", (List)Nil$.MODULE$)), (List<DataType>)new .colon.colon((Object)this.INT(), (List)new .colon.colon((Object)this.LONG(), (List)Nil$.MODULE$)), ChangelogMode.upsert(), (List<String>)new .colon.colon((Object)"a", (List)Nil$.MODULE$));
        stmtSet.addInsert("upsertSink2", table2);
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testMiniBatchIntervalInfer() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        this.util().addDataStream("T1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple3<Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((Timestamp)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.api.stream.ExplainTest$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addDataStream("T2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cnt")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "goods")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple6<Object, String, Object, String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple6<Object, String, Object, String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple6<Object, String, Object, String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple6<Object, String, Object, String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple6<Object, String, Object, String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple6((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[4])), (Object)((Timestamp)fields[5]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.api.stream.ExplainTest$$anon$9 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableWithWatermark("T3", this.util().tableEnv().from("T1"), "rowtime", 0L);
        this.util().addTableWithWatermark("T4", this.util().tableEnv().from("T2"), "rowtime", 0L);
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(3L));
        Table table = this.util().tableEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                                         |SELECT id1, T3.rowtime AS ts, text\n                                         |  FROM T3, T4\n                                         |WHERE id1 = id2\n                                         |      AND T3.rowtime > T4.rowtime - INTERVAL '5' MINUTE\n                                         |      AND T3.rowtime < T4.rowtime + INTERVAL '3' MINUTE\n      ")).stripMargin());
        this.util().tableEnv().createTemporaryView("TempTable", table);
        Table table1 = this.util().tableEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                                          |SELECT id1, LISTAGG(text, '#')\n                                          |FROM TempTable\n                                          |GROUP BY id1, TUMBLE(ts, INTERVAL '8' SECOND)\n      ")).stripMargin());
        TestSinkUtil$.MODULE$.addValuesSink(this.util().tableEnv(), "appendSink1", (List<String>)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$)), (List<DataType>)new .colon.colon((Object)this.INT(), (List)new .colon.colon((Object)this.STRING(), (List)Nil$.MODULE$)), ChangelogMode.insertOnly(), TestSinkUtil$.MODULE$.addValuesSink$default$6());
        stmtSet.addInsert("appendSink1", table1);
        Table table2 = this.util().tableEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                               |SELECT id1, LISTAGG(text, '*')\n                               |FROM TempTable\n                               |GROUP BY id1, HOP(ts, INTERVAL '12' SECOND, INTERVAL '6' SECOND)\n      ")).stripMargin());
        TestSinkUtil$.MODULE$.addValuesSink(this.util().tableEnv(), "appendSink2", (List<String>)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$)), (List<DataType>)new .colon.colon((Object)this.INT(), (List)new .colon.colon((Object)this.STRING(), (List)Nil$.MODULE$)), ChangelogMode.insertOnly(), TestSinkUtil$.MODULE$.addValuesSink$default$6());
        stmtSet.addInsert("appendSink2", table2);
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    public ExplainTest(boolean extended) {
        this.extraDetails = extended ? (ExplainDetail[])((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE, ExplainDetail.ESTIMATED_COST}) : (ExplainDetail[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ExplainDetail.class));
        this.util = this.streamTestUtil(this.streamTestUtil$default$1());
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.stream.ExplainTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.api.stream.ExplainTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.api.stream.ExplainTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.STRING = DataTypes.STRING();
        this.LONG = DataTypes.BIGINT();
        this.INT = DataTypes.INT();
    }
}

