/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class StatementSetImplTest {
    TableEnvironmentInternal tableEnv;

    StatementSetImplTest() {
    }

    @BeforeEach
    void setup() {
        this.tableEnv = (TableEnvironmentInternal)TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
    }

    @Test
    void testGetJsonPlan() {
        String srcTableDdl = "CREATE TABLE MyTable (\n  a bigint,\n  b int,\n  c varchar\n) with (\n  'connector' = 'values',\n  'bounded' = 'false')";
        this.tableEnv.executeSql(srcTableDdl);
        String sinkTableDdl = "CREATE TABLE MySink (\n  a bigint,\n  b int,\n  c varchar\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tableEnv.executeSql(sinkTableDdl);
        StatementSet stmtSet = this.tableEnv.createStatementSet();
        stmtSet.addInsertSql("INSERT INTO MySink SELECT * FROM MyTable");
        String jsonPlan = stmtSet.compilePlan().asJsonString();
        String expected = TableTestUtil.readFromResource("/jsonplan/testGetJsonPlan.out");
        Assertions.assertThat((String)TableTestUtil.replaceFlinkVersion(TableTestUtil.replaceExecNodeId(jsonPlan))).isEqualTo(TableTestUtil.replaceExecNodeId(expected));
    }
}

