/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableITCase$;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.utils.TableITCaseBase;
import org.apache.flink.table.planner.utils.TestTableSourceSinks$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.test.junit5.InjectClusterClient;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001\u0002\u000b\u0016\u0001\u0001BQ!\u000b\u0001\u0005\u0002)B\u0011\"\f\u0001A\u0002\u0003\u0007I\u0011\u0001\u0018\t\u0013q\u0002\u0001\u0019!a\u0001\n\u0003i\u0004\"\u0003#\u0001\u0001\u0004\u0005\t\u0015)\u00030\u0011%!\u0006\u00011AA\u0002\u0013\u0005Q\u000bC\u0005Z\u0001\u0001\u0007\t\u0019!C\u00015\"IA\f\u0001a\u0001\u0002\u0003\u0006KA\u0016\u0005\n?\u0002\u0001\r\u00111A\u0005\u0002\u0001D\u0011\u0002\u001a\u0001A\u0002\u0003\u0007I\u0011A3\t\u0013\u001d\u0004\u0001\u0019!A!B\u0013\t\u0007\"\u00025\u0001\t\u0003I\u0007\"B:\u0001\t\u0003I\u0007\"\u0002=\u0001\t\u0003I\bBBA\u001b\u0001\u0011\u0005\u0011\u000e\u0003\u0004\u0002:\u0001!\t![\u0004\b\u0003+*\u0002\u0012AA,\r\u0019!R\u0003#\u0001\u0002Z!1\u0011&\u0005C\u0001\u0003CBq!a\u0019\u0012\t\u0003\t)GA\u0006UC\ndW-\u0013+DCN,'B\u0001\f\u0018\u0003\r\t\u0007/\u001b\u0006\u00031e\tQ\u0001^1cY\u0016T!AG\u000e\u0002\u000b\u0019d\u0017N\\6\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0005\u0005\u0002#O5\t1E\u0003\u0002%K\u0005)Q\u000f^5mg*\u0011aeF\u0001\ba2\fgN\\3s\u0013\tA3EA\bUC\ndW-\u0013+DCN,')Y:f\u0003\u0019a\u0014N\\5u}Q\t1\u0006\u0005\u0002-\u00015\tQ#\u0001\u0007uC\ndW-\u00128w\u001d\u0006lW-F\u00010!\t\u0001\u0014H\u0004\u00022oA\u0011!'N\u0007\u0002g)\u0011AgH\u0001\u0007yI|w\u000e\u001e \u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003qU\n\u0001\u0003^1cY\u0016,eN\u001e(b[\u0016|F%Z9\u0015\u0005y\u0012\u0005CA A\u001b\u0005)\u0014BA!6\u0005\u0011)f.\u001b;\t\u000f\r\u001b\u0011\u0011!a\u0001_\u0005\u0019\u0001\u0010J\u0019\u0002\u001bQ\f'\r\\3F]Zt\u0015-\\3!Q\u0011!aIU*\u0011\u0005\u001d\u0003V\"\u0001%\u000b\u0005%S\u0015!\u00049be\u0006lW\r^3sSj,GM\u0003\u0002L\u0019\u0006QQ\r\u001f;f]NLwN\\:\u000b\u00055s\u0015!\u00026v]&$(BA(\u001a\u0003%!Xm\u001d;vi&d7/\u0003\u0002R\u0011\nI\u0001+\u0019:b[\u0016$XM]\u0001\u0006m\u0006dW/Z\u000f\u0002\u0001\u0005Y\u0011n]*ue\u0016\fW.\u001b8h+\u00051\u0006CA X\u0013\tAVGA\u0004C_>dW-\u00198\u0002\u001f%\u001c8\u000b\u001e:fC6LgnZ0%KF$\"AP.\t\u000f\r3\u0011\u0011!a\u0001-\u0006a\u0011n]*ue\u0016\fW.\u001b8hA!\"qA\u0012*_;\u0005\t\u0011\u0001\u0002;F]Z,\u0012!\u0019\t\u0003Y\tL!aY\u000b\u0003!Q\u000b'\r\\3F]ZL'o\u001c8nK:$\u0018\u0001\u0003;F]Z|F%Z9\u0015\u0005y2\u0007bB\"\n\u0003\u0003\u0005\r!Y\u0001\u0006i\u0016sg\u000fI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002}!\u00121b\u001b\t\u0003YFl\u0011!\u001c\u0006\u0003-9T!a\u001c9\u0002\u000f),\b/\u001b;fe*\u0011Q*H\u0005\u0003e6\u0014!BQ3g_J,W)Y2i\u0003-!Xm\u001d;Fq\u0016\u001cW\u000f^3)\u00051)\bC\u00017w\u0013\t9XN\u0001\u0007UKN$H+Z7qY\u0006$X-\u0001\u000buKN$8i\u001c7mK\u000e$x+\u001b;i\u00072|7/\u001a\u000b\u0003}iDQa_\u0007A\u0002q\fQb\u00197vgR,'o\u00117jK:$\bgA?\u0002\u0010A)a0a\u0002\u0002\f5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011a\u00029s_\u001e\u0014\u0018-\u001c\u0006\u0004\u0003\u000bI\u0012AB2mS\u0016tG/C\u0002\u0002\n}\u0014Qb\u00117vgR,'o\u00117jK:$\b\u0003BA\u0007\u0003\u001fa\u0001\u0001B\u0006\u0002\u0012i\f\t\u0011!A\u0003\u0002\u0005M!aA0%cE!\u0011QCA\u000e!\ry\u0014qC\u0005\u0004\u00033)$a\u0002(pi\"Lgn\u001a\t\u0004\u007f\u0005u\u0011bAA\u0010k\t\u0019\u0011I\\=)\u0007i\f\u0019\u0003\u0005\u0003\u0002&\u0005=RBAA\u0014\u0015\u0011\tI#a\u000b\u0002\r),h.\u001b;6\u0015\r\ti#G\u0001\u0005i\u0016\u001cH/\u0003\u0003\u00022\u0005\u001d\"aE%oU\u0016\u001cGo\u00117vgR,'o\u00117jK:$\bFA\u0007v\u0003q!Xm\u001d;Fq\u0016\u001cW\u000f^3XSRDW\u000b\u001d3bi\u0016\u001c\u0005.\u00198hKND#AD;\u00027Q,7\u000f^\"pY2,7\r^,ji\"lU\u000f\u001c;j%><H/[7fQ\tyQ\u000f\u000b\u0004\u0001\u0003\u007f\u0011\u00161\n\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011QI7\u0002\u0013\u0015DH/\u001a8tS>t\u0017\u0002BA%\u0003\u0007\u0012!\"\u0012=uK:$w+\u001b;iY\t\tie\t\u0002\u0002PA\u0019q)!\u0015\n\u0007\u0005M\u0003J\u0001\u000eQCJ\fW.\u001a;fe&TX\r\u001a+fgR,\u0005\u0010^3og&|g.A\u0006UC\ndW-\u0013+DCN,\u0007C\u0001\u0017\u0012'\r\t\u00121\f\t\u0004\u007f\u0005u\u0013bAA0k\t1\u0011I\\=SK\u001a$\"!a\u0016\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002hA1\u0011\u0011NA:\u0003oj!!a\u001b\u000b\t\u00055\u0014qN\u0001\u0005kRLGN\u0003\u0002\u0002r\u0005!!.\u0019<b\u0013\u0011\t)(a\u001b\u0003\u0015\r{G\u000e\\3di&|g\u000e\r\u0003\u0002z\u0005\u0005\u0005#B \u0002|\u0005}\u0014bAA?k\t)\u0011I\u001d:bsB!\u0011QBAA\t-\t\u0019iEA\u0001\u0002\u0003\u0015\t!a\u0005\u0003\u0007}##\u0007K\u0004\u0014\u0003\u000f\u000bi)a$\u0011\u0007\u001d\u000bI)C\u0002\u0002\f\"\u0013!\u0002U1sC6,G/\u001a:t\u0003\u0011q\u0017-\\3\"\u0005\u0005E\u0015\u0001E>1{jJ7o\u0015;sK\u0006lWh_\u0019~\u0001")
public class TableITCase
extends TableITCaseBase {
    @Parameter(value=0)
    private String tableEnvName;
    @Parameter(value=1)
    private boolean isStreaming;
    private TableEnvironment tEnv;

    @Parameters(name="{0}:isStream={1}")
    public static Collection<Object> parameters() {
        return TableITCase$.MODULE$.parameters();
    }

    public String tableEnvName() {
        return this.tableEnvName;
    }

    public void tableEnvName_$eq(String x$1) {
        this.tableEnvName = x$1;
    }

    public boolean isStreaming() {
        return this.isStreaming;
    }

    public void isStreaming_$eq(boolean x$1) {
        this.isStreaming = x$1;
    }

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    public void tEnv_$eq(TableEnvironment x$1) {
        this.tEnv = x$1;
    }

    @BeforeEach
    public void setup() {
        EnvironmentSettings settings = this.isStreaming() ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
        String string = this.tableEnvName();
        if ("TableEnvironment".equals(string)) {
            this.tEnv_$eq((TableEnvironment)TableEnvironmentImpl.create((EnvironmentSettings)settings));
        } else if ("StreamTableEnvironment".equals(string)) {
            this.tEnv_$eq((TableEnvironment)StreamTableEnvironment.create((StreamExecutionEnvironment)StreamExecutionEnvironment.getExecutionEnvironment(), (EnvironmentSettings)settings));
        } else {
            throw new UnsupportedOperationException(new StringBuilder(26).append("unsupported tableEnvName: ").append(this.tableEnvName()).toString());
        }
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable(this.tEnv(), "MyTable");
    }

    @TestTemplate
    public void testExecute() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |select id, concat(concat(`first`, ' '), `last`) as `full name`\n        |from MyTable where mod(id, 2) = 0\n      ")).stripMargin();
        Table table = this.tEnv().sqlQuery(query);
        TableResult tableResult = table.execute();
        Assertions.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assertions.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assertions.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.INT()), Column.physical((String)"full name", (DataType)DataTypes.STRING())}), (Object)tableResult.getResolvedSchema());
        List<Object> expected = Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{2, "Bob Taylor"}), Row.of((Object[])new Object[]{4, "Peter Smith"}), Row.of((Object[])new Object[]{6, "Sally Miller"}), Row.of((Object[])new Object[]{8, "Kelly Williams"})});
        tableResult.await();
        CloseableIterator it = tableResult.collect();
        List actual = CollectionUtil.iteratorToList((Iterator)it);
        it.close();
        actual.sort(new Comparator<Row>(null){

            public Comparator<Row> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<Row> thenComparing(Comparator<? super Row> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<Row> thenComparing(Function<? super Row, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<Row> thenComparing(Function<? super Row, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<Row> thenComparingInt(ToIntFunction<? super Row> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<Row> thenComparingLong(ToLongFunction<? super Row> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<Row> thenComparingDouble(ToDoubleFunction<? super Row> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(Row o1, Row o2) {
                return Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o1.getField(0))).compareTo(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o2.getField(0))));
            }
        });
        Assertions.assertEquals(expected, (Object)actual);
    }

    @TestTemplate
    public void testCollectWithClose(@InjectClusterClient ClusterClient<?> clusterClient) {
        String sourceDdl = new StringOps(Predef$.MODULE$.augmentString("\n        |create table unbounded_source (\n        |  id int\n        |) with (\n        |  'connector' = 'datagen',\n        |  'number-of-rows' = '10000',\n        |  'rows-per-second' = '1' -- slow producing speed to make sure that\n        |                          -- source is not finished when job is cancelled\n        |)\n        |")).stripMargin();
        this.tEnv().executeSql(sourceDdl);
        String query = "select id from unbounded_source where mod(id, 2) = 0";
        Table table = this.tEnv().sqlQuery(query);
        TableResult tableResult = table.execute();
        Assertions.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assertions.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        CloseableIterator it = tableResult.collect();
        it.close();
        JobClient jobClient = (JobClient)tableResult.getJobClient().get();
        JobID jobId = jobClient.getJobID();
        clusterClient.requestJobResult(jobId).get();
        Assertions.assertEquals((Object)JobStatus.CANCELED, jobClient.getJobStatus().get());
    }

    @TestTemplate
    public void testExecuteWithUpdateChanges() {
        TableResult tableResult = this.tEnv().sqlQuery("select count(*) as c from MyTable").execute();
        Assertions.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assertions.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assertions.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"c", (DataType)((DataType)DataTypes.BIGINT().notNull()))}), (Object)tableResult.getResolvedSchema());
        List<Object> expected = this.isStreaming() ? Arrays.asList((Object[])new Row[]{Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{8L})}) : Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{8L})});
        List actual = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        Assertions.assertEquals(expected, (Object)actual);
    }

    @TestTemplate
    public void testCollectWithMultiRowtime() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE TABLE MyTableWithRowtime1 (\n                      |  ts AS TO_TIMESTAMP_LTZ(id, 3),\n                      |  WATERMARK FOR ts AS ts - INTERVAL '1' MINUTE)\n                      |LIKE MyTable")).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE TABLE MyTableWithRowtime2 (\n                      |  ts AS TO_TIMESTAMP_LTZ(id, 3),\n                      |  WATERMARK FOR ts AS ts - INTERVAL '1' MINUTE)\n                      |LIKE MyTable")).stripMargin());
        TableResult tableResult = this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                        |SELECT MyTableWithRowtime1.ts, MyTableWithRowtime2.ts\n                        |FROM MyTableWithRowtime1, MyTableWithRowtime2\n                        |WHERE\n                        |  MyTableWithRowtime1.first = MyTableWithRowtime2.first AND\n                        |  MyTableWithRowtime1.ts = MyTableWithRowtime2.ts")).stripMargin());
        IndexedSeq expected = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 8).map((Function1 & Serializable & scala.Serializable)i -> TableITCase.$anonfun$testCollectWithMultiRowtime$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        List actual = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.containsInAnyOrder((Object[])((Object[])expected.toArray(ClassTag$.MODULE$.apply(Row.class)))));
    }

    public static final /* synthetic */ Row $anonfun$testCollectWithMultiRowtime$1(int i) {
        return Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{Instant.ofEpochMilli(i), Instant.ofEpochMilli(i)});
    }
}

