/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableEnvironmentITCase$;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.legacy.api.TableSchema;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.TestSinkUtil$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.planner.utils.TestTableSourceSinks$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MutableList;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\t\rd\u0001\u0002\u00192\u0001qB\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\")1\u000b\u0001C\u0001)\"I\u0011\f\u0001a\u0001\u0002\u0004%\tA\u0017\u0005\nK\u0002\u0001\r\u00111A\u0005\u0002\u0019D\u0011\u0002\u001c\u0001A\u0002\u0003\u0005\u000b\u0015B.\t\u0013e\u0004\u0001\u0019!a\u0001\n\u0003Q\b\"\u0003@\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0000\u0011)\t\u0019\u0001\u0001a\u0001\u0002\u0003\u0006Ka\u001f\u0005\n\u0003\u000b\u0001!\u0019!C\u0005\u0003\u000fA\u0001\"a\u0004\u0001A\u0003%\u0011\u0011\u0002\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\ty\u0002\u0001C\u0001\u0003'Aq!!\u000b\u0001\t\u0003\t\u0019\u0002C\u0004\u0002.\u0001!\t!a\u0005\t\u000f\u0005E\u0002\u0001\"\u0001\u0002\u0014!9\u0011Q\u0007\u0001\u0005\u0002\u0005M\u0001bBA\u001d\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003{\u0001A\u0011AA\n\u0011\u001d\t\t\u0005\u0001C\u0001\u0003'Aq!!\u0012\u0001\t\u0003\t\u0019\u0002C\u0004\u0002J\u0001!\t!a\u0005\t\u000f\u00055\u0003\u0001\"\u0001\u0002\u0014!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0001bBA+\u0001\u0011\u0005\u00111\u0003\u0005\b\u00033\u0002A\u0011AA\n\u0011\u001d\ti\u0006\u0001C\u0001\u0003'Aq!!\u0019\u0001\t\u0003\t\u0019\u0002C\u0004\u0002f\u0001!\t!a\u0005\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0001bBA;\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003s\u0002A\u0011AA\n\u0011\u001d\ti\b\u0001C\u0001\u0003\u007fBq!!*\u0001\t\u0013\t9\u000bC\u0004\u0002&\u0002!I!!,\t\u000f\u0005M\u0006\u0001\"\u0003\u00026\"9\u0011\u0011\u0018\u0001\u0005\n\u0005m\u0006bBA`\u0001\u0011%\u0011\u0011\u0019\u0005\b\u0003\u000f\u0004A\u0011BAe\u0011\u001d\ty\r\u0001C\u0005\u0003#Dq!!6\u0001\t\u0013\t9\u000eC\u0004\u0002^\u0002!I!a8\b\u000f\t}\u0011\u0007#\u0001\u0003\"\u00191\u0001'\rE\u0001\u0005GAaaU\u0017\u0005\u0002\t\u0015\u0002b\u0002B\u0014[\u0011\u0005!\u0011\u0006\u0002\u0017)\u0006\u0014G.Z#om&\u0014xN\\7f]RLEkQ1tK*\u0011!gM\u0001\u0004CBL'B\u0001\u001b6\u0003\u0015!\u0018M\u00197f\u0015\t1t'A\u0003gY&t7N\u0003\u00029s\u00051\u0011\r]1dQ\u0016T\u0011AO\u0001\u0004_J<7\u0001A\n\u0003\u0001u\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012a!\u00118z%\u00164\u0017\u0001\u0004;bE2,WI\u001c<OC6,\u0007CA#M\u001d\t1%\n\u0005\u0002H\u007f5\t\u0001J\u0003\u0002Jw\u00051AH]8pizJ!aS \u0002\rA\u0013X\rZ3g\u0013\tieJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0017~\n1\"[:TiJ,\u0017-\\5oOB\u0011a(U\u0005\u0003%~\u0012qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0004+^C\u0006C\u0001,\u0001\u001b\u0005\t\u0004\"B\"\u0004\u0001\u0004!\u0005\"B(\u0004\u0001\u0004\u0001\u0016A\u0003;f[B4u\u000e\u001c3feV\t1\f\u0005\u0002]G6\tQL\u0003\u0002_?\u0006!a-\u001b7f\u0015\t\u0001\u0017-A\u0002oS>T\u0011AY\u0001\u0005U\u00064\u0018-\u0003\u0002e;\n!\u0001+\u0019;i\u00039!X-\u001c9G_2$WM]0%KF$\"a\u001a6\u0011\u0005yB\u0017BA5@\u0005\u0011)f.\u001b;\t\u000f-,\u0011\u0011!a\u00017\u0006\u0019\u0001\u0010J\u0019\u0002\u0017Q,W\u000e\u001d$pY\u0012,'\u000f\t\u0015\u0003\r9\u0004\"a\\<\u000e\u0003AT!!\u001d:\u0002\u0005%|'B\u0001\u001at\u0015\t!X/A\u0004kkBLG/\u001a:\u000b\u0005YL\u0014!\u00026v]&$\u0018B\u0001=q\u0005\u001d!V-\u001c9ESJ\fA\u0001^#omV\t1\u0010\u0005\u0002Wy&\u0011Q0\r\u0002\u0011)\u0006\u0014G.Z#om&\u0014xN\\7f]R\f\u0001\u0002^#om~#S-\u001d\u000b\u0004O\u0006\u0005\u0001bB6\t\u0003\u0003\u0005\ra_\u0001\u0006i\u0016sg\u000fI\u0001\tg\u0016$H/\u001b8hgV\u0011\u0011\u0011\u0002\t\u0004-\u0006-\u0011bAA\u0007c\t\u0019RI\u001c<je>tW.\u001a8u'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002O\"\u001aA\"a\u0006\u0011\t\u0005e\u00111D\u0007\u0002e&\u0019\u0011Q\u0004:\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0011uKN$X\t_3dkR,Gk^5dKV\u001b\u0018N\\4TC6,G+\u00192mK\u0016sg\u000fK\u0002\u000e\u0003G\u0001B!!\u0007\u0002&%\u0019\u0011q\u0005:\u0003\u0019Q+7\u000f\u001e+f[Bd\u0017\r^3\u0002?Q,7\u000f^#ya2\f\u0017N\\!oI\u0016CXmY;uKNKgn\u001a7f'&t7\u000eK\u0002\u000f\u0003G\tA\u0004^3ti\u0016CXmY;uKN\u000bHnV5uQ&s7/\u001a:u\u0013:$x\u000eK\u0002\u0010\u0003G\t\u0011\u0005^3ti\u0016CXmY;uKN\u000bHnV5uQ&s7/\u001a:u\u001fZ,'o\u001e:ji\u0016D3\u0001EA\u0012\u0003y!Xm\u001d;Fq\u0016\u001cW\u000f^3Tc2\fe\u000eZ#yK\u000e,H/Z%og\u0016\u0014H\u000fK\u0002\u0012\u0003G\tQ\u0004^3ti\u0016CXmY;uKN\u000bH.\u00118e)>$\u0015\r^1TiJ,\u0017-\u001c\u0015\u0004%\u0005\r\u0012!\b;fgR$v\u000eR1uCN#(/Z1n\u0003:$W\t_3dkR,7+\u001d7)\u0007M\t\u0019#A\u0011uKN$hI]8n)>$\u0015\r^1TiJ,\u0017-\\!oI\u0016CXmY;uKN\u000bH\u000eK\u0002\u0015\u0003G\t\u0011\u0003^3ti\u0016CXmY;uK&s7/\u001a:uQ\r)\u00121E\u0001\u0013i\u0016\u001cH/\u0012=fGV$X-\u00138tKJ$(\u0007K\u0002\u0017\u0003G\t!\u0004^3ti\u0016CXmY;uK&s7/\u001a:u\u001fZ,'o\u001e:ji\u0016D3aFA\u0012\u0003A!Xm\u001d;UC\ndW\rR'M'ft7\rK\u0002\u0019\u0003G\t\u0001\u0003^3tiN#\u0018\r^3nK:$8+\u001a;)\u0007e\t\u0019#A\fuKN$X\t_3dkR,7\u000b^1uK6,g\u000e^*fi\"\u001a!$a\t\u0002;Q,7\u000f^*uCR,W.\u001a8u'\u0016$x+\u001b;i\u001fZ,'o\u001e:ji\u0016D3aGA\u0012\u0003\u0019\"Xm\u001d;Ti\u0006$X-\\3oiN+GoV5uQN\u000bW.Z*j].$\u0016M\u00197f\u001d\u0006lWm\u001d\u0015\u00049\u0005\r\u0012!\u0005;fgR,\u00050Z2vi\u0016\u001cV\r\\3di\"\u001aQ$a\t\u00023Q,7\u000f^#yK\u000e,H/Z*fY\u0016\u001cG/\u00138uKJt\u0017\r\u001c\u000b\u0004O\u00065\u0004BBA8=\u0001\u0007A)A\u0003rk\u0016\u0014\u00180\u0001\u0012uKN$X\t_3dkR,7+\u001a7fGR<\u0016\u000e\u001e5Va\u0012\fG/Z\"iC:<Wm\u001d\u0015\u0004?\u0005\r\u0012A\t;fgR,\u00050Z2vi\u0016\u001cV\r\\3di^KG\u000f\u001b+j[\u0016\fE\u000f\u001e:jEV$X\rK\u0002!\u0003G\t!\u0003^3ti\u000ecW-\u0019:Pa\u0016\u0014\u0018\r^5p]\"\u001a\u0011%a\t\u0002\u001b\u001d,G\u000fU3sg>tG)\u0019;b+\t\t\t\t\u0005\u0004\u0002\u0004\u00065\u00151\u0013\b\u0005\u0003\u000b\u000bIID\u0002H\u0003\u000fK\u0011\u0001Q\u0005\u0004\u0003\u0017{\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\u000b\tJ\u0001\u0003MSN$(bAAF\u007fAIa(!&E\u00033\u000by\nR\u0005\u0004\u0003/{$A\u0002+va2,G\u0007E\u0002?\u00037K1!!(@\u0005\rIe\u000e\u001e\t\u0004}\u0005\u0005\u0016bAAR\u007f\t1Ai\\;cY\u0016\f\u0011#Y:tKJ$h)\u001b:tiZ\u000bG.^3t)\r9\u0017\u0011\u0016\u0005\u0007\u0003W\u001b\u0003\u0019\u0001#\u0002\u0013Q\f'\r\\3OC6,G#B4\u00020\u0006E\u0006\"B=%\u0001\u0004Y\bBBAVI\u0001\u0007A)\u0001\tbgN,'\u000f\u001e'bgR4\u0016\r\\;fgR\u0019q-a.\t\r\u0005-V\u00051\u0001E\u0003U9W\r^#ya\u0016\u001cG/\u001a3MCN$h+\u00197vKN,\"!!0\u0011\u000b\u0005\r\u0015Q\u0012#\u0002\u0019\u001d,G\u000fV1cY\u0016$\u0015\r^1\u0015\r\u0005u\u00161YAc\u0011\u0015Ix\u00051\u0001|\u0011\u0019\tYk\na\u0001\t\u0006i1\r[3dW\u0016k\u0007\u000f^=ESJ$2aZAf\u0011\u0019\ti\r\u000ba\u0001\t\u00069A-\u001b:QCRD\u0017!\u00033fY\u0016$X\rR5s)\r9\u00171\u001b\u0005\u0007\u0003\u001bL\u0003\u0019\u0001#\u0002\u0015\u0011,G.\u001a;f\r&dW\rF\u0002h\u00033Da!a7+\u0001\u0004!\u0015\u0001\u00029bi\"\fac\u00195fG.Len]3siR\u000b'\r\\3SKN,H\u000e\u001e\u000b\u0006O\u0006\u0005\u00181\u001e\u0005\b\u0003G\\\u0003\u0019AAs\u0003-!\u0018M\u00197f%\u0016\u001cX\u000f\u001c;\u0011\u0007Y\u000b9/C\u0002\u0002jF\u00121\u0002V1cY\u0016\u0014Vm];mi\"9\u0011Q^\u0016A\u0002\u0005=\u0018A\u00034jK2$g*Y7fgB!a(!=E\u0013\r\t\u0019p\u0010\u0002\u000byI,\u0007/Z1uK\u0012t\u0004f\u0002\u0001\u0002x\n\r!Q\u0001\t\u0005\u0003s\fy0\u0004\u0002\u0002|*\u0019\u0011Q :\u0002\u0013\u0015DH/\u001a8tS>t\u0017\u0002\u0002B\u0001\u0003w\u0014!\"\u0012=uK:$w+\u001b;i\u0003\u00151\u0018\r\\;fY\t\u00119a\t\u0002\u0003\nA!!1\u0002B\u000e\u001b\t\u0011iA\u0003\u0003\u0003\u0010\tE\u0011!\u00049be\u0006lW\r^3sSj,GM\u0003\u0003\u0003\u0014\tU\u0011AC3yi\u0016t7/[8og*\u0019aOa\u0006\u000b\u0007\teQ'A\u0005uKN$X\u000f^5mg&!!Q\u0004B\u0007\u0005i\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^#yi\u0016t7/[8o\u0003Y!\u0016M\u00197f\u000b:4\u0018N]8o[\u0016tG/\u0013+DCN,\u0007C\u0001,.'\tiS\b\u0006\u0002\u0003\"\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0015\u0005\t-\u0002C\u0002B\u0017\u0005g\u00119$\u0004\u0002\u00030)\u0019!\u0011G1\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005k\u0011yC\u0001\u0006D_2dWm\u0019;j_:\u0004DA!\u000f\u0003DA)aHa\u000f\u0003@%\u0019!QH \u0003\u000b\u0005\u0013(/Y=\u0011\t\t\u0005#1\t\u0007\u0001\t-\u0011)eLA\u0001\u0002\u0003\u0015\tAa\u0012\u0003\u0007}#\u0013'\u0005\u0003\u0003J\t=\u0003c\u0001 \u0003L%\u0019!QJ \u0003\u000f9{G\u000f[5oOB\u0019aH!\u0015\n\u0007\tMsHA\u0002B]fDsa\fB,\u0005;\u0012y\u0006\u0005\u0003\u0003\f\te\u0013\u0002\u0002B.\u0005\u001b\u0011!\u0002U1sC6,G/\u001a:t\u0003\u0011q\u0017-\\3\"\u0005\t\u0005\u0014\u0001E>1{jJ7o\u0015;sK\u0006lWh_\u0019~\u0001")
public class TableEnvironmentITCase {
    private final String tableEnvName;
    private final boolean isStreaming;
    @TempDir
    private Path tempFolder;
    private TableEnvironment tEnv;
    private final EnvironmentSettings settings;

    @Parameters(name="{0}:isStream={1}")
    public static Collection<Object> parameters() {
        return TableEnvironmentITCase$.MODULE$.parameters();
    }

    public Path tempFolder() {
        return this.tempFolder;
    }

    public void tempFolder_$eq(Path x$1) {
        this.tempFolder = x$1;
    }

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    public void tEnv_$eq(TableEnvironment x$1) {
        this.tEnv = x$1;
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    @BeforeEach
    public void setup() {
        String string = this.tableEnvName;
        if ("TableEnvironment".equals(string)) {
            this.tEnv_$eq((TableEnvironment)TableEnvironmentImpl.create((EnvironmentSettings)this.settings()));
        } else if ("StreamTableEnvironment".equals(string)) {
            this.tEnv_$eq((TableEnvironment)StreamTableEnvironment.create((StreamExecutionEnvironment)StreamExecutionEnvironment.getExecutionEnvironment(), (EnvironmentSettings)this.settings()));
        } else {
            throw new UnsupportedOperationException(new StringBuilder(26).append("unsupported tableEnvName: ").append(this.tableEnvName).toString());
        }
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable(this.tEnv(), "MyTable");
    }

    @TestTemplate
    public void testExecuteTwiceUsingSameTableEnv() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyDir(sink1Path);
        this.checkEmptyDir(sink2Path);
        Table table1 = this.tEnv().sqlQuery("select first from MyTable");
        table1.executeInsert("MySink1").await();
        this.assertFirstValues("MySink1");
        this.checkEmptyDir(sink2Path);
        this.deleteDir(sink1Path);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new File(sink1Path).exists());
        Table table2 = this.tEnv().sqlQuery("select last from MyTable");
        table2.executeInsert("MySink2").await();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new File(sink1Path).exists());
        this.assertLastValues("MySink2");
    }

    @TestTemplate
    public void testExplainAndExecuteSingleSink() {
        String sinkPath = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        Table table1 = this.tEnv().sqlQuery("select first from MyTable");
        table1.executeInsert("MySink1").await();
        this.assertFirstValues("MySink1");
    }

    @TestTemplate
    public void testExecuteSqlWithInsertInto() {
        String sinkPath = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyDir(sinkPath);
        TableResult tableResult = this.tEnv().executeSql("insert into MySink1 select first from MyTable");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1"}));
        this.assertFirstValues("MySink1");
    }

    @TestTemplate
    public void testExecuteSqlWithInsertOverwrite() {
        if (this.isStreaming) {
            return;
        }
        String sinkPath = TempDirUtils.newFolder((Path)this.tempFolder()).toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sinkPath).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        TableResult tableResult1 = this.tEnv().executeSql("insert overwrite MySink select first from MyTable");
        this.checkInsertTableResult(tableResult1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues("MySink");
        TableResult tableResult2 = this.tEnv().executeSql("insert overwrite MySink select first from MyTable");
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues("MySink");
    }

    @TestTemplate
    public void testExecuteSqlAndExecuteInsert() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"last"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyDir(sink1Path);
        this.checkEmptyDir(sink2Path);
        TableResult tableResult = this.tEnv().executeSql("insert into MySink1 select first from MyTable");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1"}));
        this.assertFirstValues("MySink1");
        this.checkEmptyDir(sink2Path);
        this.deleteDir(sink1Path);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new File(sink1Path).exists());
        this.tEnv().sqlQuery("select last from MyTable").executeInsert("MySink2").await();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new File(sink1Path).exists());
        this.assertLastValues("MySink2");
    }

    @TestTemplate
    public void testExecuteSqlAndToDataStream() {
        if (!this.tableEnvName.equals("StreamTableEnvironment")) {
            return;
        }
        StreamExecutionEnvironment streamEnv = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment streamTableEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)streamEnv, (EnvironmentSettings)this.settings());
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable((TableEnvironment)streamTableEnv, "MyTable");
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)streamTableEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyDir(sink1Path);
        Table table = streamTableEnv.sqlQuery("select last from MyTable where id > 0");
        DataStream resultSet = streamTableEnv.toDataStream(table);
        TestingAppendSink sink = new TestingAppendSink();
        resultSet.addSink((SinkFunction)sink);
        TableResult tableResult = streamTableEnv.executeSql("insert into MySink1 select first from MyTable");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1"}));
        this.assertFirstValues((TableEnvironment)streamTableEnv, "MySink1");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sink.isInitialized());
        this.deleteDir(sink1Path);
        streamEnv.execute("test2");
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        this.checkEmptyDir(sink1Path);
    }

    @TestTemplate
    public void testToDataStreamAndExecuteSql() {
        if (!this.tableEnvName.equals("StreamTableEnvironment")) {
            return;
        }
        StreamExecutionEnvironment streamEnv = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment streamTableEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)streamEnv, (EnvironmentSettings)this.settings());
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable((TableEnvironment)streamTableEnv, "MyTable");
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)streamTableEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyDir(sink1Path);
        Table table = streamTableEnv.sqlQuery("select last from MyTable where id > 0");
        DataStream resultSet = streamTableEnv.toDataStream(table);
        TestingAppendSink sink = new TestingAppendSink();
        resultSet.addSink((SinkFunction)sink);
        String insertStmt = "insert into MySink1 select first from MyTable";
        String explain = streamTableEnv.explainSql(insertStmt, new ExplainDetail[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testSqlUpdateAndToDataStream.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(explain));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testSqlUpdateAndToDataStreamWithPlanAdvice.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(streamTableEnv.explainSql(insertStmt, new ExplainDetail[]{ExplainDetail.PLAN_ADVICE})));
        streamEnv.execute("test2");
        this.checkEmptyDir(sink1Path);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        streamTableEnv.executeSql(insertStmt).await();
        this.assertFirstValues((TableEnvironment)streamTableEnv, "MySink1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testFromToDataStreamAndExecuteSql() {
        if (!this.tableEnvName.equals("StreamTableEnvironment")) {
            return;
        }
        StreamExecutionEnvironment streamEnv = StreamExecutionEnvironment.getExecutionEnvironment();
        org.apache.flink.table.api.bridge.scala.StreamTableEnvironment streamTableEnv = StreamTableEnvironment$.MODULE$.create(streamEnv, this.settings());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(streamEnv, this.getPersonData(), new CaseClassTypeInfo<Tuple4<String, Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<String, Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple4<String, Object, Object, String>>(this, fieldSerializers){

                    public Tuple4<String, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[2])), (Object)((String)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.TableEnvironmentITCase$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(streamTableEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "first")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "score")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "last"))}));
        streamTableEnv.createTemporaryView("MyTable", t);
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)streamTableEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyDir(sink1Path);
        Table table = streamTableEnv.sqlQuery("select last from MyTable where id > 0");
        DataStream resultSet = streamTableEnv.toDataStream(table);
        TestingAppendSink sink = new TestingAppendSink();
        resultSet.addSink((SinkFunction)sink);
        String insertStmt = "insert into MySink1 select first from MyTable";
        String explain = streamTableEnv.explainSql(insertStmt, new ExplainDetail[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testFromToDataStreamAndSqlUpdate.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(explain));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testFromToDataStreamAndSqlUpdateWithPlanAdvice.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(streamTableEnv.explainSql(insertStmt, new ExplainDetail[]{ExplainDetail.PLAN_ADVICE})));
        streamEnv.execute("test2");
        this.checkEmptyDir(sink1Path);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        streamTableEnv.executeSql(insertStmt).await();
        this.assertFirstValues((TableEnvironment)streamTableEnv, "MySink1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testExecuteInsert() {
        String sinkPath = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING})), "MySink", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyDir(sinkPath);
        Table table = this.tEnv().sqlQuery("select first from MyTable");
        TableResult tableResult = table.executeInsert("MySink");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues("MySink");
    }

    @TestTemplate
    public void testExecuteInsert2() {
        String sinkPath = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING})), "MySink", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyDir(sinkPath);
        TableResult tableResult = this.tEnv().executeSql("execute insert into MySink select first from MyTable");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues("MySink");
    }

    @TestTemplate
    public void testExecuteInsertOverwrite() {
        if (this.isStreaming) {
            return;
        }
        String sinkPath = TempDirUtils.newFolder((Path)this.tempFolder()).toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sinkPath).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        TableResult tableResult1 = this.tEnv().sqlQuery("select first from MyTable").executeInsert("MySink", true);
        this.checkInsertTableResult(tableResult1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues("MySink");
        TableResult tableResult2 = this.tEnv().sqlQuery("select first from MyTable").executeInsert("MySink", true);
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues("MySink");
    }

    @TestTemplate
    public void testTableDMLSync() {
        this.tEnv().getConfig().set(TableConfigOptions.TABLE_DML_SYNC, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sink1Path = TempDirUtils.newFolder((Path)this.tempFolder()).toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(220).append("\n         |create table MySink1 (\n         |  first string,\n         |  last string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink1Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        String sink2Path = TempDirUtils.newFolder((Path)this.tempFolder()).toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(195).append("\n         |create table MySink2 (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink2Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        String sink3Path = TempDirUtils.newFolder((Path)this.tempFolder()).toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink3 (\n         |  last string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink3Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        TableResult tableResult1 = this.tEnv().sqlQuery("select first, last from MyTable").executeInsert("MySink1", false);
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO MySink2 select first from MySink1");
        stmtSet.addInsertSql("INSERT INTO MySink3 select last from MySink1");
        TableResult tableResult2 = stmtSet.execute();
        this.assertFirstValues("MySink2");
        this.assertLastValues("MySink3");
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink2", "default_catalog.default_database.MySink3"}));
        tableResult1.await();
        tableResult2.await();
    }

    @TestTemplate
    public void testStatementSet() {
        Boolean bl;
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"last"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsert("MySink1", this.tEnv().sqlQuery("select first from MyTable")).addInsertSql("insert into MySink2 select last from MyTable");
        String actual = stmtSet.explain(new ExplainDetail[0]);
        String expected = TableTestUtil$.MODULE$.readFromResource("/explain/testStatementSet.out");
        org.junit.jupiter.api.Assertions.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(expected), (Object)TableTestUtil$.MODULE$.replaceStageId(actual));
        if (this.isStreaming) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testStatementSetWithPlanAdvice.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(stmtSet.explain(new ExplainDetail[]{ExplainDetail.PLAN_ADVICE})));
            bl = BoxedUnit.UNIT;
        } else {
            bl = BoxesRunTime.boxToBoolean((boolean)(Assertions.assertThatThrownBy(() -> stmtSet.explain(new ExplainDetail[]{ExplainDetail.PLAN_ADVICE})).hasMessageContaining("EXPLAIN PLAN_ADVICE is not supported under batch mode.") instanceof UnsupportedOperationException));
        }
        TableResult tableResult = stmtSet.execute();
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1", "default_catalog.default_database.MySink2"}));
        this.assertFirstValues("MySink1");
        this.assertLastValues("MySink2");
    }

    @TestTemplate
    public void testExecuteStatementSet() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"last"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        TableResult tableResult = this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("execute statement set begin\n                                        |insert into MySink1 select first from MyTable;\n                                        |insert into MySink2 select last from MyTable;\n                                        |end")).stripMargin());
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1", "default_catalog.default_database.MySink2"}));
        this.assertFirstValues("MySink1");
        this.assertLastValues("MySink2");
    }

    @TestTemplate
    public void testStatementSetWithOverwrite() {
        if (this.isStreaming) {
            return;
        }
        String sink1Path = TempDirUtils.newFolder((Path)this.tempFolder()).toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(195).append("\n         |create table MySink1 (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink1Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        String sink2Path = TempDirUtils.newFolder((Path)this.tempFolder()).toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink2 (\n         |  last string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink2Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsert("MySink1", this.tEnv().sqlQuery("select first from MyTable"), true);
        stmtSet.addInsertSql("insert overwrite MySink2 select last from MyTable");
        TableResult tableResult1 = stmtSet.execute();
        this.checkInsertTableResult(tableResult1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1", "default_catalog.default_database.MySink2"}));
        this.assertFirstValues("MySink1");
        this.assertLastValues("MySink2");
        stmtSet.addInsert("MySink1", this.tEnv().sqlQuery("select first from MyTable"), true).addInsertSql("insert overwrite MySink2 select last from MyTable");
        TableResult tableResult2 = stmtSet.execute();
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1", "default_catalog.default_database.MySink2"}));
        this.assertFirstValues("MySink1");
        this.assertLastValues("MySink2");
    }

    @TestTemplate
    public void testStatementSetWithSameSinkTableNames() {
        if (this.isStreaming) {
            return;
        }
        String sinkPath = TempDirUtils.newFolder((Path)this.tempFolder()).toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sinkPath).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsert("MySink", this.tEnv().sqlQuery("select first from MyTable"), true);
        stmtSet.addInsertSql("insert overwrite MySink select last from MyTable");
        TableResult tableResult = stmtSet.execute();
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink_1", "default_catalog.default_database.MySink_2"}));
    }

    @TestTemplate
    public void testExecuteSelect() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |select id, concat(concat(`first`, ' '), `last`) as `full name`\n        |from MyTable where mod(id, 2) = 0\n      ")).stripMargin();
        this.testExecuteSelectInternal(query);
        String query2 = new StringOps(Predef$.MODULE$.augmentString("\n        |execute select id, concat(concat(`first`, ' '), `last`) as `full name`\n        |from MyTable where mod(id, 2) = 0\n      ")).stripMargin();
        this.testExecuteSelectInternal(query2);
    }

    public void testExecuteSelectInternal(String query) {
        TableResult tableResult = this.tEnv().executeSql(query);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableResult.getJobClient().isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.INT()), Column.physical((String)"full name", (DataType)DataTypes.STRING())}), (Object)tableResult.getResolvedSchema());
        java.util.List<Object> expected = Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{2, "Bob Taylor"}), Row.of((Object[])new Object[]{4, "Peter Smith"}), Row.of((Object[])new Object[]{6, "Sally Miller"}), Row.of((Object[])new Object[]{8, "Kelly Williams"})});
        java.util.List actual = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        actual.sort(new Comparator<Row>(null){

            public Comparator<Row> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<Row> thenComparing(Comparator<? super Row> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<Row> thenComparing(Function<? super Row, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<Row> thenComparing(Function<? super Row, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<Row> thenComparingInt(ToIntFunction<? super Row> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<Row> thenComparingLong(ToLongFunction<? super Row> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<Row> thenComparingDouble(ToDoubleFunction<? super Row> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(Row o1, Row o2) {
                return Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o1.getField(0))).compareTo(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o2.getField(0))));
            }
        });
        org.junit.jupiter.api.Assertions.assertEquals(expected, (Object)actual);
    }

    @TestTemplate
    public void testExecuteSelectWithUpdateChanges() {
        TableResult tableResult = this.tEnv().sqlQuery("select count(*) as c from MyTable").execute();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableResult.getJobClient().isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"c", (DataType)((DataType)DataTypes.BIGINT().notNull()))}), (Object)tableResult.getResolvedSchema());
        java.util.List<Object> expected = this.isStreaming ? Arrays.asList((Object[])new Row[]{Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{8L})}) : Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{8L})});
        java.util.List actual = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        org.junit.jupiter.api.Assertions.assertEquals(expected, (Object)actual);
    }

    @TestTemplate
    public void testExecuteSelectWithTimeAttribute() {
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Mary"})), (List)Nil$.MODULE$)));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(344).append("\n                       |create table T (\n                       |  name string,\n                       |  pt as proctime()\n                       |) with (\n                       |  'connector' = 'values',\n                       |  'bounded' = 'true',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        TableResult tableResult = this.tEnv().executeSql("select * from T");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableResult.getJobClient().isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"name", (DataType)DataTypes.STRING()), Column.physical((String)"pt", (DataType)((DataType)DataTypes.TIMESTAMP_LTZ((int)3).notNull()))}), (Object)tableResult.getResolvedSchema());
        CloseableIterator it = tableResult.collect();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)it.hasNext());
        Row row = (Row)it.next();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)row.getArity());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Mary", (Object)row.getField(0));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)it.hasNext());
    }

    @TestTemplate
    public void testClearOperation() {
        Object object;
        TestCollectionTableFactory$.MODULE$.reset();
        TableEnvironmentImpl tableEnv = TableEnvironmentImpl.create((EnvironmentSettings)this.settings());
        tableEnv.executeSql("create table dest1(x map<int,bigint>) with('connector' = 'COLLECTION')");
        tableEnv.executeSql("create table dest2(x int) with('connector' = 'COLLECTION')");
        tableEnv.executeSql("create table src(x int) with('connector' = 'COLLECTION')");
        try {
            tableEnv.executeSql("insert into dest1 select count(*) from src");
            object = org.junit.jupiter.api.Assertions.fail((String)"insert is expected to fail due to type mismatch");
        }
        catch (Exception exception) {
            object = BoxedUnit.UNIT;
        }
        tableEnv.executeSql("drop table dest1");
        tableEnv.executeSql("insert into dest2 select x from src").await();
    }

    public List<Tuple4<String, Object, Object, String>> getPersonData() {
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)"Mike", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToDouble((double)12.3), (Object)"Smith"));
        data.$plus$eq((Object)new Tuple4((Object)"Bob", (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)45.6), (Object)"Taylor"));
        data.$plus$eq((Object)new Tuple4((Object)"Sam", (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToDouble((double)7.89), (Object)"Miller"));
        data.$plus$eq((Object)new Tuple4((Object)"Peter", (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToDouble((double)0.12), (Object)"Smith"));
        data.$plus$eq((Object)new Tuple4((Object)"Liz", (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToDouble((double)34.5), (Object)"Williams"));
        data.$plus$eq((Object)new Tuple4((Object)"Sally", (Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToDouble((double)6.78), (Object)"Miller"));
        data.$plus$eq((Object)new Tuple4((Object)"Alice", (Object)BoxesRunTime.boxToInteger((int)7), (Object)BoxesRunTime.boxToDouble((double)90.1), (Object)"Smith"));
        data.$plus$eq((Object)new Tuple4((Object)"Kelly", (Object)BoxesRunTime.boxToInteger((int)8), (Object)BoxesRunTime.boxToDouble((double)2.34), (Object)"Williams"));
        return data.toList();
    }

    private void assertFirstValues(String tableName) {
        this.assertFirstValues(this.tEnv(), tableName);
    }

    private void assertFirstValues(TableEnvironment tEnv, String tableName) {
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mike", "Bob", "Sam", "Peter", "Liz", "Sally", "Alice", "Kelly"}));
        List<String> actual = this.getTableData(tEnv, tableName);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)actual.sorted((Ordering)Ordering.String$.MODULE$));
    }

    private void assertLastValues(String tableName) {
        List<String> actual = this.getTableData(this.tEnv(), tableName);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)actual.sorted((Ordering)Ordering.String$.MODULE$));
    }

    private List<String> getExpectedLastValues() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Smith", "Taylor", "Miller", "Smith", "Williams", "Miller", "Smith", "Williams"}));
    }

    private List<String> getTableData(TableEnvironment tEnv, String tableName) {
        MutableList result = new MutableList();
        try (CloseableIterator iterator = tEnv.executeSql(new StringBuilder(14).append("select * from ").append(tableName).toString()).collect();){
            while (iterator.hasNext()) {
                result.$plus$eq((Object)TestSinkUtil$.MODULE$.rowToString((Row)iterator.next(), TestSinkUtil$.MODULE$.rowToString$default$2()));
            }
        }
        return result.toList();
    }

    private void checkEmptyDir(String dirPath) {
        File dir = new File(dirPath);
        org.junit.jupiter.api.Assertions.assertTrue((!dir.exists() || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).isEmpty() ? 1 : 0) != 0);
    }

    private void deleteDir(String dirPath) {
        File dir = new File(dirPath);
        if (!dir.exists()) {
            return;
        }
        if (dir.isFile()) {
            this.deleteFile(dir.getAbsolutePath());
            return;
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            this.deleteDir(file.getAbsolutePath());
            return BoxedUnit.UNIT;
        });
        dir.delete();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new File(dirPath).exists());
    }

    private void deleteFile(String path) {
        new File(path).delete();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new File(path).exists());
    }

    private void checkInsertTableResult(TableResult tableResult, Seq<String> fieldNames) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableResult.getJobClient().isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList((Object[])fieldNames.toArray(ClassTag$.MODULE$.apply(String.class))), (Object)tableResult.getResolvedSchema().getColumnNames());
        CloseableIterator it = tableResult.collect();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)it.hasNext());
        Seq affectedRowCounts = (Seq)fieldNames.map((Function1 & Serializable & scala.Serializable)x$1 -> -1L, Seq$.MODULE$.canBuildFrom());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Row.of((Object[])((Object[])affectedRowCounts.toArray(ClassTag$.MODULE$.apply(Long.class)))), (Object)it.next());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)it.hasNext());
    }

    public TableEnvironmentITCase(String tableEnvName, boolean isStreaming) {
        this.tableEnvName = tableEnvName;
        this.isStreaming = isStreaming;
        this.settings = isStreaming ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
    }
}

