/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.QueryOperationTestPrograms;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.operations.CollectModifyOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.test.program.SqlTestStep;
import org.apache.flink.table.test.program.TableApiTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.table.test.program.TableTestProgramRunner;
import org.apache.flink.table.test.program.TestStep;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class QueryOperationSqlSerializationTest
implements TableTestProgramRunner {
    public List<TableTestProgram> programs() {
        return Arrays.asList(QueryOperationTestPrograms.SOURCE_QUERY_OPERATION, QueryOperationTestPrograms.VALUES_QUERY_OPERATION, QueryOperationTestPrograms.FILTER_QUERY_OPERATION, QueryOperationTestPrograms.AGGREGATE_QUERY_OPERATION, QueryOperationTestPrograms.AGGREGATE_NO_GROUP_BY_QUERY_OPERATION, QueryOperationTestPrograms.DISTINCT_QUERY_OPERATION, QueryOperationTestPrograms.JOIN_QUERY_OPERATION, QueryOperationTestPrograms.ORDER_BY_QUERY_OPERATION, QueryOperationTestPrograms.WINDOW_AGGREGATE_QUERY_OPERATION, QueryOperationTestPrograms.UNION_ALL_QUERY_OPERATION, QueryOperationTestPrograms.LATERAL_JOIN_QUERY_OPERATION, QueryOperationTestPrograms.SQL_QUERY_OPERATION, QueryOperationTestPrograms.OVER_WINDOW_RANGE, QueryOperationTestPrograms.OVER_WINDOW_ROWS, QueryOperationTestPrograms.OVER_WINDOW_ROWS_UNBOUNDED_NO_PARTITION, QueryOperationTestPrograms.OVER_WINDOW_LAG, QueryOperationTestPrograms.ACCESSING_NESTED_COLUMN);
    }

    @ParameterizedTest
    @MethodSource(value={"supportedPrograms"})
    void testSqlSerialization(TableTestProgram program) {
        TableEnvironment env = QueryOperationSqlSerializationTest.setupEnv(program);
        TableApiTestStep tableApiStep = (TableApiTestStep)program.runSteps.stream().filter(s -> s instanceof TableApiTestStep).findFirst().get();
        SqlTestStep sqlStep = (SqlTestStep)program.runSteps.stream().filter(s -> s instanceof SqlTestStep).findFirst().get();
        Table table = tableApiStep.toTable(env);
        Assertions.assertThat((String)table.getQueryOperation().asSerializableString()).isEqualTo(sqlStep.sql);
    }

    @ParameterizedTest
    @MethodSource(value={"supportedPrograms"})
    void testSqlAsJobNameForQueryOperation(TableTestProgram program) {
        TableEnvironmentImpl env = (TableEnvironmentImpl)QueryOperationSqlSerializationTest.setupEnv(program);
        TableApiTestStep tableApiStep = (TableApiTestStep)program.runSteps.stream().filter(s -> s instanceof TableApiTestStep).findFirst().get();
        SqlTestStep sqlStep = (SqlTestStep)program.runSteps.stream().filter(s -> s instanceof SqlTestStep).findFirst().get();
        Table table = tableApiStep.toTable((TableEnvironment)env);
        QueryOperation queryOperation = table.getQueryOperation();
        CollectModifyOperation sinkOperation = new CollectModifyOperation(queryOperation);
        List transformations = env.getPlanner().translate(Collections.singletonList(sinkOperation));
        StreamGraph streamGraph = (StreamGraph)env.generatePipelineFromQueryOperation(queryOperation, transformations);
        Assertions.assertThat((String)streamGraph.getJobName()).isEqualTo(sqlStep.sql);
    }

    private static TableEnvironment setupEnv(TableTestProgram program) {
        TableEnvironment env = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
        HashMap<String, String> connectorOptions = new HashMap<String, String>();
        connectorOptions.put("connector", "values");
        program.getSetupSourceTestSteps().forEach(s -> s.apply(env, connectorOptions));
        program.getSetupSinkTestSteps().forEach(s -> s.apply(env, connectorOptions));
        program.getSetupFunctionTestSteps().forEach(f -> f.apply(env));
        return env;
    }

    public EnumSet<TestStep.TestKind> supportedSetupSteps() {
        return EnumSet.of(TestStep.TestKind.FUNCTION, new TestStep.TestKind[]{TestStep.TestKind.SOURCE_WITH_DATA, TestStep.TestKind.SOURCE_WITHOUT_DATA, TestStep.TestKind.SOURCE_WITH_RESTORE_DATA, TestStep.TestKind.SINK_WITH_DATA, TestStep.TestKind.SINK_WITH_RESTORE_DATA});
    }

    public EnumSet<TestStep.TestKind> supportedRunSteps() {
        return EnumSet.of(TestStep.TestKind.TABLE_API, TestStep.TestKind.SQL);
    }
}

