/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.QueryOperationTestPrograms;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.test.program.TableApiTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.table.test.program.TableTestProgramRunner;
import org.apache.flink.table.test.program.TestStep;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ExtendWith(value={MiniClusterExtension.class})
public class QueryOperationSqlExecutionTest
implements TableTestProgramRunner {
    @AfterEach
    protected void after() {
        TestValuesTableFactory.clearAllData();
    }

    public List<TableTestProgram> programs() {
        return Arrays.asList(QueryOperationTestPrograms.SOURCE_QUERY_OPERATION, QueryOperationTestPrograms.VALUES_QUERY_OPERATION, QueryOperationTestPrograms.FILTER_QUERY_OPERATION, QueryOperationTestPrograms.AGGREGATE_QUERY_OPERATION, QueryOperationTestPrograms.AGGREGATE_NO_GROUP_BY_QUERY_OPERATION, QueryOperationTestPrograms.DISTINCT_QUERY_OPERATION, QueryOperationTestPrograms.JOIN_QUERY_OPERATION, QueryOperationTestPrograms.ORDER_BY_QUERY_OPERATION, QueryOperationTestPrograms.WINDOW_AGGREGATE_QUERY_OPERATION, QueryOperationTestPrograms.UNION_ALL_QUERY_OPERATION, QueryOperationTestPrograms.LATERAL_JOIN_QUERY_OPERATION, QueryOperationTestPrograms.GROUP_HOP_WINDOW_EVENT_TIME, QueryOperationTestPrograms.SORT_LIMIT_DESC, QueryOperationTestPrograms.GROUP_BY_UDF_WITH_MERGE, QueryOperationTestPrograms.NON_WINDOW_INNER_JOIN, QueryOperationTestPrograms.SQL_QUERY_OPERATION, QueryOperationTestPrograms.OVER_WINDOW_RANGE, QueryOperationTestPrograms.OVER_WINDOW_ROWS, QueryOperationTestPrograms.OVER_WINDOW_ROWS_UNBOUNDED_NO_PARTITION, QueryOperationTestPrograms.OVER_WINDOW_LAG, QueryOperationTestPrograms.ACCESSING_NESTED_COLUMN);
    }

    @ParameterizedTest
    @MethodSource(value={"supportedPrograms"})
    void testSerializedSqlExecution(TableTestProgram program) throws ExecutionException, InterruptedException {
        TableEnvironment env = QueryOperationSqlExecutionTest.setupEnv(program);
        TableApiTestStep tableApiStep = (TableApiTestStep)program.runSteps.stream().filter(s -> s instanceof TableApiTestStep).findFirst().get();
        TableResult tableResult = tableApiStep.applyAsSql(env);
        tableResult.await();
        program.getSetupSinkTestSteps().forEach(s -> {
            List expectedAsStrings = s.getExpectedAsStrings();
            if (this.isAppendOnly(expectedAsStrings)) {
                Assertions.assertThat(TestValuesTableFactory.getResultsAsStrings(s.name)).containsExactlyInAnyOrderElementsOf((Iterable)expectedAsStrings);
            } else {
                Assertions.assertThat(TestValuesTableFactory.getRawResultsAsStrings(s.name)).containsExactlyInAnyOrderElementsOf((Iterable)expectedAsStrings);
            }
        });
    }

    private boolean isAppendOnly(List<String> expectedAsStrings) {
        return expectedAsStrings.stream().allMatch(str -> str.startsWith("+I"));
    }

    private static TableEnvironment setupEnv(TableTestProgram program) {
        TableEnvironment env = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
        HashMap<String, String> connectorOptions = new HashMap<String, String>();
        connectorOptions.put("connector", "values");
        connectorOptions.put("sink-insert-only", "false");
        connectorOptions.put("runtime-source", "NewSource");
        program.getSetupSourceTestSteps().forEach(s -> {
            ArrayList<Row> data = new ArrayList<Row>(s.dataBeforeRestore);
            data.addAll(s.dataAfterRestore);
            String id = TestValuesTableFactory.registerData(data);
            connectorOptions.put("data-id", id);
            s.apply(env, connectorOptions);
        });
        program.getSetupSinkTestSteps().forEach(s -> s.apply(env, connectorOptions));
        program.getSetupFunctionTestSteps().forEach(f -> f.apply(env));
        return env;
    }

    public EnumSet<TestStep.TestKind> supportedSetupSteps() {
        return EnumSet.of(TestStep.TestKind.FUNCTION, new TestStep.TestKind[]{TestStep.TestKind.SOURCE_WITH_DATA, TestStep.TestKind.SOURCE_WITHOUT_DATA, TestStep.TestKind.SOURCE_WITH_RESTORE_DATA, TestStep.TestKind.SINK_WITH_DATA, TestStep.TestKind.SINK_WITH_RESTORE_DATA});
    }

    public EnumSet<TestStep.TestKind> supportedRunSteps() {
        return EnumSet.of(TestStep.TestKind.TABLE_API, TestStep.TestKind.SQL);
    }
}

