/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ExecuteSqlTest$;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.TestLogger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\f\u0019\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006c\u0001!\tA\r\u0005\nm\u0001\u0001\r\u00111A\u0005\u0002]B\u0011B\u0011\u0001A\u0002\u0003\u0007I\u0011A\"\t\u0013%\u0003\u0001\u0019!A!B\u0013A\u0004b\u0002,\u0001\u0005\u0004%Ia\u0016\u0005\u00077\u0002\u0001\u000b\u0011\u0002-\t\u000fq\u0003\u0001\u0019!C\u0001;\"9\u0011\r\u0001a\u0001\n\u0003\u0011\u0007B\u00023\u0001A\u0003&a\fC\u0003f\u0001\u0011\u0005a\rC\u0003m\u0001\u0011%a\rC\u0003n\u0001\u0011%a\rC\u0003o\u0001\u0011%a\rC\u0003p\u0001\u0011%a\rC\u0003q\u0001\u0011%a\rC\u0003r\u0001\u0011%a\rC\u0003s\u0001\u0011%amB\u0004\u0002\u0012aA\t!a\u0005\u0007\r]A\u0002\u0012AA\u000b\u0011\u0019\tD\u0003\"\u0001\u0002\u001e!9\u0011q\u0004\u000b\u0005\u0002\u0005\u0005\"AD#yK\u000e,H/Z*rYR+7\u000f\u001e\u0006\u00033i\t1!\u00199j\u0015\tYB$A\u0003uC\ndWM\u0003\u0002\u001e=\u0005)a\r\\5oW*\u0011q\u0004I\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001db\u0012\u0001B;uS2L!!\u000b\u0014\u0003\u0015Q+7\u000f\u001e'pO\u001e,'/A\u0006jgN#(/Z1nS:<\u0007C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005M*\u0004C\u0001\u001b\u0001\u001b\u0005A\u0002\"\u0002\u0016\u0003\u0001\u0004Y\u0013A\u0003;f[B4u\u000e\u001c3feV\t\u0001\b\u0005\u0002:\u00016\t!H\u0003\u0002<y\u0005!a-\u001b7f\u0015\tid(A\u0002oS>T\u0011aP\u0001\u0005U\u00064\u0018-\u0003\u0002Bu\t!\u0001+\u0019;i\u00039!X-\u001c9G_2$WM]0%KF$\"\u0001R$\u0011\u00051*\u0015B\u0001$.\u0005\u0011)f.\u001b;\t\u000f!#\u0011\u0011!a\u0001q\u0005\u0019\u0001\u0010J\u0019\u0002\u0017Q,W\u000e\u001d$pY\u0012,'\u000f\t\u0015\u0003\u000b-\u0003\"\u0001\u0014+\u000e\u00035S!AT(\u0002\u0005%|'BA\rQ\u0015\t\t&+A\u0004kkBLG/\u001a:\u000b\u0005M\u0003\u0013!\u00026v]&$\u0018BA+N\u0005\u001d!V-\u001c9ESJ\f\u0001b]3ui&twm]\u000b\u00021B\u0011A'W\u0005\u00035b\u00111#\u00128wSJ|g.\\3oiN+G\u000f^5oON\f\u0011b]3ui&twm\u001d\u0011\u0002\tQ,eN^\u000b\u0002=B\u0011AgX\u0005\u0003Ab\u0011\u0001\u0003V1cY\u0016,eN^5s_:lWM\u001c;\u0002\u0011Q,eN^0%KF$\"\u0001R2\t\u000f!K\u0011\u0011!a\u0001=\u0006)A/\u00128wA\u0005yA/Z:u'\"|woQ8mk6t7\u000fF\u0001EQ\tY\u0001\u000e\u0005\u0002jU6\tq*\u0003\u0002l\u001f\naA+Z:u)\u0016l\u0007\u000f\\1uK\u0006\u0001\u0012N\\5u)\u0006\u0014G.Z!oIZKWm^\u0001\u0018g\"|w/\u00117m\u0007>dW/\u001c8t\rJ|W\u000eV1cY\u0016\f!e\u001d5po\u000e{G.^7og^KG\u000f\u001b'jW\u0016\u001cE.Y;tK\u001a\u0013x.\u001c+bE2,\u0017!J:i_^\u001cu\u000e\\;n]N<\u0016\u000e\u001e5O_Rd\u0015n[3DY\u0006,8/\u001a$s_6$\u0016M\u00197f\u0003Y\u0019\bn\\<BY2\u001cu\u000e\\;n]N4%o\\7WS\u0016<\u0018!I:i_^\u001cu\u000e\\;n]N<\u0016\u000e\u001e5MS.,7\t\\1vg\u00164%o\\7WS\u0016<\u0018\u0001J:i_^\u001cu\u000e\\;n]N<\u0016\u000e\u001e5O_Rd\u0015n[3DY\u0006,8/\u001a$s_64\u0016.Z<)\t\u0001!(p\u001f\t\u0003kbl\u0011A\u001e\u0006\u0003o>\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005e4(AC#yi\u0016tGmV5uQ\u0006)a/\u00197vK2\nApI\u0001~!\rq\u0018QB\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u00035\u0001\u0018M]1nKR,'/\u001b>fI*!\u0011QAA\u0004\u0003))\u0007\u0010^3og&|gn\u001d\u0006\u0004'\u0006%!bAA\u00069\u0005IA/Z:ukRLGn]\u0005\u0004\u0003\u001fy(A\u0007)be\u0006lW\r^3sSj,G\rV3ti\u0016CH/\u001a8tS>t\u0017AD#yK\u000e,H/Z*rYR+7\u000f\u001e\t\u0003iQ\u00192\u0001FA\f!\ra\u0013\u0011D\u0005\u0004\u00037i#AB!osJ+g\r\u0006\u0002\u0002\u0014\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0015\u0005\u0005\r\u0002CBA\u0013\u0003S\ti#\u0004\u0002\u0002()\u0011qEP\u0005\u0005\u0003W\t9C\u0001\u0006D_2dWm\u0019;j_:\u0004B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003gq\u0014\u0001\u00027b]\u001eL1\u0001MA\u0019Q\u001d1\u0012\u0011HA \u0003\u0003\u00022A`A\u001e\u0013\r\tid \u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\u0001\u00028b[\u0016\f#!a\u0011\u0002\u0019%\u001c8\u000b\u001e:fC6l4\u0010M?")
public class ExecuteSqlTest
extends TestLogger {
    private final boolean isStreaming;
    @TempDir
    private Path tempFolder;
    private final EnvironmentSettings settings;
    private TableEnvironment tEnv;

    @Parameters(name="isStream={0}")
    public static Collection<Boolean> parameters() {
        return ExecuteSqlTest$.MODULE$.parameters();
    }

    public Path tempFolder() {
        return this.tempFolder;
    }

    public void tempFolder_$eq(Path x$1) {
        this.tempFolder = x$1;
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    public void tEnv_$eq(TableEnvironment x$1) {
        this.tEnv = x$1;
    }

    @TestTemplate
    public void testShowColumns() {
        this.initTableAndView();
        this.showAllColumnsFromTable();
        this.showColumnsWithLikeClauseFromTable();
        this.showColumnsWithNotLikeClauseFromTable();
        this.showAllColumnsFromView();
        this.showColumnsWithLikeClauseFromView();
        this.showColumnsWithNotLikeClauseFromView();
    }

    private void initTableAndView() {
        String createClause = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE IF NOT EXISTS orders (\n         | `user` BIGINT NOT NULl,\n         | `product` VARCHAR(32),\n         | `amount` INT,\n         | PRIMARY KEY(`user`) NOT ENFORCED\n         |) ")).stripMargin();
        String createWithClause = new StringOps(Predef$.MODULE$.augmentString("\n         |with (\n         | 'connector' = 'datagen'\n         |)")).stripMargin();
        if (!this.isStreaming) {
            String sinkPath = TempDirUtils.newFolder((Path)this.tempFolder()).toString();
            createWithClause = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(222).append("\n                            |with (\n                            |  'connector' = 'filesystem',\n                            |  'path' = '").append(sinkPath).append("',\n                            |  'format' = 'testcsv'\n                            |)").toString())).stripMargin();
        }
        this.tEnv().executeSql(new StringBuilder(0).append(createClause).append(createWithClause).toString());
        this.tEnv().executeSql("create view orders_view as select * from orders");
    }

    private void showAllColumnsFromTable() {
        ArrayList expectedResultRows = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{"user", "BIGINT", new Boolean(false), "PRI(user)", null, null}), Row.of((Object[])new Object[]{"product", "VARCHAR(32)", new Boolean(true), null, null, null}), Row.of((Object[])new Object[]{"amount", "INT", new Boolean(true), null, null, null})});
        List resultsWithFrom = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns from orders").collect());
        List resultsWithIn = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns in orders").collect());
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithFrom);
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithIn);
    }

    private void showColumnsWithLikeClauseFromTable() {
        ArrayList expectedResultRows = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{"user", "BIGINT", new Boolean(false), "PRI(user)", null, null}), Row.of((Object[])new Object[]{"product", "VARCHAR(32)", new Boolean(true), null, null, null})});
        List resultsWithFrom = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns from orders like '%_r%'").collect());
        List resultsWithIn = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns in orders like '%_r%'").collect());
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithFrom);
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithIn);
    }

    private void showColumnsWithNotLikeClauseFromTable() {
        ArrayList expectedResultRows = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{"amount", "INT", new Boolean(true), null, null, null})});
        List resultsWithFrom = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns from orders not like '%_r%'").collect());
        List resultsWithIn = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns in orders not like '%_r%'").collect());
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithFrom);
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithIn);
    }

    private void showAllColumnsFromView() {
        ArrayList expectedResultRows = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{"user", "BIGINT", new Boolean(false), null, null, null}), Row.of((Object[])new Object[]{"product", "VARCHAR(32)", new Boolean(true), null, null, null}), Row.of((Object[])new Object[]{"amount", "INT", new Boolean(true), null, null, null})});
        List resultsWithFrom = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns from orders_view").collect());
        List resultsWithIn = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns in orders_view").collect());
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithFrom);
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithIn);
    }

    private void showColumnsWithLikeClauseFromView() {
        ArrayList expectedResultRows = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{"user", "BIGINT", new Boolean(false), null, null, null}), Row.of((Object[])new Object[]{"product", "VARCHAR(32)", new Boolean(true), null, null, null})});
        List resultsWithFrom = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns from orders_view like '%_r%'").collect());
        List resultsWithIn = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns in orders_view like '%_r%'").collect());
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithFrom);
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithIn);
    }

    private void showColumnsWithNotLikeClauseFromView() {
        ArrayList expectedResultRows = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{"amount", "INT", new Boolean(true), null, null, null})});
        List resultsWithFrom = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns from orders_view not like '%_r%'").collect());
        List resultsWithIn = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns in orders_view not like '%_r%'").collect());
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithFrom);
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithIn);
    }

    public ExecuteSqlTest(boolean isStreaming) {
        this.isStreaming = isStreaming;
        this.settings = isStreaming ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
        this.tEnv = TableEnvironment.create((EnvironmentSettings)this.settings());
    }
}

