/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.java.internal.StreamTableEnvironmentImpl;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.CatalogDescriptor;
import org.apache.flink.table.catalog.CatalogStore;
import org.apache.flink.table.catalog.GenericInMemoryCatalogStore;
import org.apache.flink.table.catalog.listener.CatalogListener1;
import org.apache.flink.table.catalog.listener.CatalogListener2;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class EnvironmentTest {
    EnvironmentTest() {
    }

    @Test
    void testPassingExecutionParameters() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        tEnv.getConfig().addConfiguration(new Configuration().set(CoreOptions.DEFAULT_PARALLELISM, (Object)128).set(PipelineOptions.AUTO_WATERMARK_INTERVAL, (Object)Duration.ofMillis(800L)).set(CheckpointingOptions.CHECKPOINTING_INTERVAL, (Object)Duration.ofSeconds(30L)));
        tEnv.createTemporaryView("test", (DataStream)env.fromData((Object[])new Integer[]{1, 2, 3}));
        Table table = tEnv.sqlQuery("SELECT * FROM test");
        tEnv.toDataStream(table);
        Assertions.assertThat((int)env.getParallelism()).isEqualTo(128);
        Assertions.assertThat((long)env.getConfig().getAutoWatermarkInterval()).isEqualTo(800L);
        Assertions.assertThat((long)env.getCheckpointConfig().getCheckpointInterval()).isEqualTo(30000L);
    }

    @Test
    void testEnvironmentSettings() throws ExecutionException, InterruptedException {
        Configuration conf = new Configuration();
        conf.set(TableConfigOptions.TABLE_CATALOG_NAME, (Object)"myCatalog");
        EnvironmentSettings settings = EnvironmentSettings.newInstance().withConfiguration(conf).build();
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)settings);
        Assertions.assertThat((String)((String)tEnv.getConfig().get(TableConfigOptions.TABLE_CATALOG_NAME))).isEqualTo("myCatalog");
        Assertions.assertThat((String)tEnv.getCurrentCatalog()).isEqualTo("myCatalog");
        StreamTableEnvironment stEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)StreamExecutionEnvironment.getExecutionEnvironment(), (EnvironmentSettings)settings);
        Assertions.assertThat((String)((String)stEnv.getConfig().get(TableConfigOptions.TABLE_CATALOG_NAME))).isEqualTo("myCatalog");
        stEnv.getConfig().set(TableConfigOptions.TABLE_CATALOG_NAME, (Object)((String)TableConfigOptions.TABLE_CATALOG_NAME.defaultValue()));
        Assertions.assertThat((String)stEnv.getCurrentCatalog()).isEqualTo("myCatalog");
    }

    @Test
    void testCreateCatalogModificationListenersForTable() {
        Configuration configuration = new Configuration();
        TableEnvironmentImpl env1 = (TableEnvironmentImpl)TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.newInstance().withConfiguration(configuration).build());
        Assertions.assertThat((boolean)env1.getCatalogManager().getCatalogModificationListeners().isEmpty()).isTrue();
        configuration.setString(TableConfigOptions.TABLE_CATALOG_MODIFICATION_LISTENERS.key(), "factory1;factory2");
        TableEnvironmentImpl env2 = (TableEnvironmentImpl)TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.newInstance().withConfiguration(configuration).build());
        Assertions.assertThat(Arrays.asList(CatalogListener1.class.getName(), CatalogListener2.class.getName())).isEqualTo(env2.getCatalogManager().getCatalogModificationListeners().stream().map(c -> c.getClass().getName()).collect(Collectors.toList()));
    }

    @Test
    void testCreateCatalogModificationListenersForStreamTable() {
        Configuration configuration = new Configuration();
        StreamTableEnvironmentImpl env1 = (StreamTableEnvironmentImpl)StreamTableEnvironment.create((StreamExecutionEnvironment)StreamExecutionEnvironment.getExecutionEnvironment(), (EnvironmentSettings)EnvironmentSettings.newInstance().withConfiguration(configuration).build());
        Assertions.assertThat((boolean)env1.getCatalogManager().getCatalogModificationListeners().isEmpty()).isTrue();
        configuration.setString(TableConfigOptions.TABLE_CATALOG_MODIFICATION_LISTENERS.key(), "factory1;factory2");
        StreamTableEnvironmentImpl env2 = (StreamTableEnvironmentImpl)StreamTableEnvironment.create((StreamExecutionEnvironment)StreamExecutionEnvironment.getExecutionEnvironment(), (EnvironmentSettings)EnvironmentSettings.newInstance().withConfiguration(configuration).build());
        Assertions.assertThat(Arrays.asList(CatalogListener1.class.getName(), CatalogListener2.class.getName())).isEqualTo(env2.getCatalogManager().getCatalogModificationListeners().stream().map(c -> c.getClass().getName()).collect(Collectors.toList()));
    }

    @Test
    void testRegisterCatalogStoreUsingTableApi() {
        GenericInMemoryCatalogStore catalogStore = new GenericInMemoryCatalogStore();
        EnvironmentSettings settings = EnvironmentSettings.newInstance().withCatalogStore((CatalogStore)catalogStore).build();
        TableEnvironment tbEnv = TableEnvironment.create((EnvironmentSettings)settings);
        Configuration configuration = new Configuration();
        configuration.setString("type", "generic_in_memory");
        tbEnv.createCatalog("test_catalog", CatalogDescriptor.of((String)"test_catalog", (Configuration)configuration));
        Assertions.assertThat((boolean)catalogStore.contains("test_catalog")).isTrue();
    }
}

