/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.source.split;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.connector.source.TerminatingLogic;
import org.apache.flink.connector.source.split.ValuesSourcePartitionSplit;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.Preconditions;

public class ValuesSourcePartitionSplitSerializer
implements SimpleVersionedSerializer<ValuesSourcePartitionSplit> {
    public int getVersion() {
        return 0;
    }

    public byte[] serialize(ValuesSourcePartitionSplit split) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Object object;
            try (DataOutputStream out = new DataOutputStream(baos);){
                Map<String, String> partition = split.getPartition();
                out.writeUTF(split.splitId());
                out.writeInt(partition.size());
                for (Map.Entry<String, String> entry : partition.entrySet()) {
                    out.writeUTF(entry.getKey());
                    out.writeUTF(entry.getValue());
                }
                TerminatingLogic.writeTo(out, split.getTerminatingLogic());
                out.flush();
                object = baos.toByteArray();
            }
            return object;
        }
    }

    public ValuesSourcePartitionSplit deserialize(int version, byte[] serialized) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            ValuesSourcePartitionSplit valuesSourcePartitionSplit;
            try (DataInputStream in = new DataInputStream(bais);){
                HashMap<String, String> partition = new HashMap<String, String>();
                String splitId = in.readUTF();
                int size = in.readInt();
                for (int i = 0; i < size; ++i) {
                    String key = in.readUTF();
                    String value = in.readUTF();
                    partition.put(key, value);
                }
                TerminatingLogic terminatingLogic = TerminatingLogic.readFrom(in);
                ValuesSourcePartitionSplit split = new ValuesSourcePartitionSplit(partition, terminatingLogic);
                Preconditions.checkArgument((boolean)split.splitId().equals(splitId));
                valuesSourcePartitionSplit = split;
            }
            return valuesSourcePartitionSplit;
        }
    }
}

