/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.source.enumerator;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.source.TerminatingLogic;
import org.apache.flink.connector.source.enumerator.NoOpEnumState;
import org.apache.flink.connector.source.split.ValuesSourceSplit;

public class ValuesSourceEnumerator
implements SplitEnumerator<ValuesSourceSplit, NoOpEnumState> {
    private final SplitEnumeratorContext<ValuesSourceSplit> context;
    private final Queue<ValuesSourceSplit> remainingSplits;
    private final TerminatingLogic terminatingLogic;

    public ValuesSourceEnumerator(SplitEnumeratorContext<ValuesSourceSplit> context, List<ValuesSourceSplit> remainingSplits, TerminatingLogic terminatingLogic) {
        this.context = context;
        this.remainingSplits = new ArrayDeque<ValuesSourceSplit>(remainingSplits);
        this.terminatingLogic = terminatingLogic;
    }

    public void start() {
    }

    public void handleSplitRequest(int subtaskId, @Nullable String requesterHostname) {
        ValuesSourceSplit nextSplit = this.remainingSplits.poll();
        if (nextSplit != null) {
            this.context.assignSplit((SourceSplit)nextSplit, subtaskId);
        } else if (this.terminatingLogic == TerminatingLogic.INFINITE) {
            this.context.assignSplit((SourceSplit)new ValuesSourceSplit(-1, TerminatingLogic.INFINITE), subtaskId);
        } else {
            this.context.signalNoMoreSplits(subtaskId);
        }
    }

    public void addSplitsBack(List<ValuesSourceSplit> splits, int subtaskId) {
        this.remainingSplits.addAll(splits);
    }

    public void addReader(int subtaskId) {
    }

    public NoOpEnumState snapshotState(long checkpointId) throws Exception {
        return new NoOpEnumState();
    }

    public void close() throws IOException {
    }
}

