/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.flink.connector.file.table.FileSystemConnectorOptions;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.SqlCallExpression;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class FileSystemTableSourceWithPartitionsITCase
extends BatchTestBase {
    private static final String TABLE_NAME = "test_table";
    private static final List<Row> TEST_DATA = Arrays.asList(Row.of((Object[])new Object[]{1, 4, 7, 10}), Row.of((Object[])new Object[]{2, 5, 8, 11}), Row.of((Object[])new Object[]{3, 6, 9, 12}));
    private File tempFolder;

    FileSystemTableSourceWithPartitionsITCase() {
    }

    @BeforeEach
    void setup() throws IOException {
        this.tempFolder = FileSystemTableSourceWithPartitionsITCase.createTempFolder();
    }

    @ParameterizedTest(name="Partition count: {0}")
    @ValueSource(ints={1, 2, 3, 4})
    void testPartitions(Integer partitionCount) throws IOException {
        this.writePartitionedTestFiles(partitionCount);
        this.createTestTable(partitionCount, Collections.emptyList());
        List<Row> actual = this.executeAndCollectResults("SELECT * FROM test_table WHERE f0=1;");
        Assertions.assertThat(actual).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, 4, 7, 10})});
        actual = this.executeAndCollectResults("SELECT * FROM test_table WHERE f0=2 AND f1=5;");
        Assertions.assertThat(actual).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{2, 5, 8, 11})});
        actual = this.executeAndCollectResults("SELECT * FROM test_table WHERE f0=2 OR f1=4;");
        Assertions.assertThat(actual).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 4, 7, 10}), Row.of((Object[])new Object[]{2, 5, 8, 11})});
        actual = this.executeAndCollectResults("SELECT * FROM test_table WHERE f0>1;");
        Assertions.assertThat(actual).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{2, 5, 8, 11}), Row.of((Object[])new Object[]{3, 6, 9, 12})});
        actual = this.executeAndCollectResults("SELECT * FROM test_table WHERE f0>0 AND f2<9;");
        Assertions.assertThat(actual).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 4, 7, 10}), Row.of((Object[])new Object[]{2, 5, 8, 11})});
    }

    @ParameterizedTest(name="Partition count: {0}")
    @ValueSource(ints={1, 2, 3, 4})
    void testPartitionsWithMetadataFields(Integer partitionCount) throws IOException {
        List<Schema.UnresolvedColumn> additionalColumns = Arrays.asList(new Schema.UnresolvedMetadataColumn("file.name", (AbstractDataType)DataTypes.STRING(), "file.name", false), new Schema.UnresolvedComputedColumn("v0", (Expression)new SqlCallExpression("f0 * f1 + f2 - f3")));
        this.writePartitionedTestFiles(partitionCount);
        this.createTestTable(partitionCount, additionalColumns);
        List<Row> actual = this.executeAndCollectResults("SELECT * FROM test_table WHERE f0=1;");
        Assertions.assertThat(actual).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, 4, 7, 10, "part0.csv", 1})});
    }

    private void writePartitionedTestFiles(Integer partitionCount) throws IOException {
        for (Row row : TEST_DATA) {
            LinkedHashMap<String, String> partitionSpec = new LinkedHashMap<String, String>();
            ArrayList<String> fileContent = new ArrayList<String>();
            for (int i = 0; i <= TEST_DATA.size(); ++i) {
                if (i < partitionCount) {
                    partitionSpec.put(String.format("f%d", i), String.valueOf(row.getField(i)));
                    continue;
                }
                fileContent.add(String.valueOf(row.getField(i)));
            }
            String partitionPath = PartitionPathUtils.generatePartitionPath(partitionSpec);
            File partitionSubDir = new File(this.tempFolder, partitionPath);
            partitionSubDir.mkdirs();
            Files.write(Paths.get(partitionSubDir.getPath(), "part0.csv"), Collections.singletonList(String.join((CharSequence)",", fileContent)), StandardOpenOption.CREATE);
        }
    }

    private void createTestTable(Integer partitionCount, List<Schema.UnresolvedColumn> additionalColumns) {
        String[] partitionKeys = (String[])IntStream.range(0, partitionCount).mapToObj(i -> String.format("f%d", i)).toArray(String[]::new);
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new Schema.UnresolvedPhysicalColumn("f0", (AbstractDataType)DataTypes.INT()));
        columns.add(new Schema.UnresolvedPhysicalColumn("f1", (AbstractDataType)DataTypes.INT()));
        columns.add(new Schema.UnresolvedPhysicalColumn("f2", (AbstractDataType)DataTypes.INT()));
        columns.add(new Schema.UnresolvedPhysicalColumn("f3", (AbstractDataType)DataTypes.INT()));
        columns.addAll(additionalColumns);
        this.tEnv().createTable(TABLE_NAME, TableDescriptor.forConnector((String)"filesystem").schema(Schema.newBuilder().fromColumns(columns).build()).format("testcsv").option(FileSystemConnectorOptions.PATH, (Object)this.tempFolder.getPath()).partitionedBy(partitionKeys).build());
    }

    private List<Row> executeAndCollectResults(String sql) {
        return CollectionUtil.iteratorToList((Iterator)this.tEnv().sqlQuery(sql).execute().collect());
    }
}

