/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataLong;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataString;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.utils.CatalogTableStatisticsConverter;
import org.apache.flink.table.planner.utils.StatisticsReportTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileSystemStatisticsReportTest
extends StatisticsReportTestBase {
    @Override
    @BeforeEach
    public void setup(@TempDir File file) throws Exception {
        super.setup(file);
        String filePath1 = this.createFileAndWriteData(file, "00-00.tmp", Arrays.asList("1,1,hi", "2,1,hello", "3,2,hello world"));
        String ddl1 = String.format("CREATE TABLE NonPartTable (\n  a bigint,\n  b int,\n  c varchar\n) with (\n 'connector' = 'filesystem', 'format' = 'testcsv', 'path' = '%s')", filePath1);
        this.tEnv.executeSql(ddl1);
        File partitionDataPath = new File(file, "partitionData");
        partitionDataPath.mkdirs();
        this.writeData(new File(partitionDataPath, "b=1"), Arrays.asList("1,1,hi", "2,1,hello"));
        this.writeData(new File(partitionDataPath, "b=2"), Collections.singletonList("3,2,hello world"));
        this.writeData(new File(partitionDataPath, "b=3"), Collections.singletonList("4,3,hello"));
        String ddl2 = String.format("CREATE TABLE PartTable (\n  a bigint,\n  b int,\n  c varchar\n) partitioned by(b) with (\n 'connector' = 'filesystem', 'format' = 'testcsv', 'path' = '%s')", partitionDataPath.toURI());
        this.tEnv.executeSql(ddl2);
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).createPartition(new ObjectPath(this.tEnv.getCurrentDatabase(), "PartTable"), new CatalogPartitionSpec(Collections.singletonMap("b", "1")), (CatalogPartition)new CatalogPartitionImpl(new HashMap(), ""), false);
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).createPartition(new ObjectPath(this.tEnv.getCurrentDatabase(), "PartTable"), new CatalogPartitionSpec(Collections.singletonMap("b", "2")), (CatalogPartition)new CatalogPartitionImpl(new HashMap(), ""), false);
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).createPartition(new ObjectPath(this.tEnv.getCurrentDatabase(), "PartTable"), new CatalogPartitionSpec(Collections.singletonMap("b", "3")), (CatalogPartition)new CatalogPartitionImpl(new HashMap(), ""), false);
        String filePath2 = this.createFileAndWriteData(file, "00-01.tmp", Arrays.asList("1,1,hi", "2,1,hello", "3,2,hello world"));
        String ddl3 = String.format("CREATE TABLE DisableSourceReportTable (\n  a bigint,\n  b int,\n  c varchar\n) with (\n 'connector' = 'filesystem', 'format' = 'testcsv', 'source.report-statistics' = 'NONE', 'path' = '%s')", filePath2);
        this.tEnv.executeSql(ddl3);
        String emptyPath = this.createFileAndWriteData(file, "00-02.tmp", Collections.emptyList());
        String ddl4 = String.format("CREATE TABLE emptyTable (\n  a bigint,\n  b int,\n  c varchar\n) with (\n 'connector' = 'filesystem', 'format' = 'testcsv', 'path' = '%s')", emptyPath);
        this.tEnv.executeSql(ddl4);
    }

    @Override
    protected String[] properties() {
        return new String[0];
    }

    private String createFileAndWriteData(File path, String fileName, List<String> data) throws IOException {
        String file = path.getAbsolutePath() + "/" + fileName;
        Files.write(new File(file).toPath(), String.join((CharSequence)"\n", data).getBytes(), new OpenOption[0]);
        return file;
    }

    private void writeData(File file, List<String> data) throws IOException {
        Files.write(file.toPath(), String.join((CharSequence)"\n", data).getBytes(), new OpenOption[0]);
    }

    @Test
    public void testCatalogStatisticsExist() throws Exception {
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).alterTableStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "NonPartTable"), new CatalogTableStatistics(10L, 1, 100L, 100L), false);
        FlinkStatistic statistic = this.getStatisticsFromOptimizedPlan("select * from NonPartTable");
        Assertions.assertThat((Object)statistic.getTableStats()).isEqualTo((Object)new TableStats(10L));
    }

    @Test
    public void testCatalogStatisticsDoNotExist() {
        FlinkStatistic statistic = this.getStatisticsFromOptimizedPlan("select * from NonPartTable");
        Assertions.assertThat((Object)statistic.getTableStats()).isEqualTo((Object)new TableStats(3L));
    }

    @Test
    public void testDisableSourceReport() {
        FlinkStatistic statistic = this.getStatisticsFromOptimizedPlan("select * from DisableSourceReportTable");
        Assertions.assertThat((Object)statistic.getTableStats()).isEqualTo((Object)TableStats.UNKNOWN);
    }

    @Test
    public void testFilterPushDownAndCatalogStatisticsExist() throws Exception {
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).alterTableStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "NonPartTable"), new CatalogTableStatistics(10L, 1, 100L, 100L), false);
        FlinkStatistic statistic = this.getStatisticsFromOptimizedPlan("select * from NonPartTable where a > 10");
        Assertions.assertThat((Object)statistic.getTableStats()).isEqualTo((Object)new TableStats(10L));
    }

    @Test
    public void testFilterPushDownAndCatalogStatisticsDoNotExist() {
        FlinkStatistic statistic = this.getStatisticsFromOptimizedPlan("select * from NonPartTable where a > 10");
        Assertions.assertThat((Object)statistic.getTableStats()).isEqualTo((Object)new TableStats(3L));
    }

    @Test
    public void testFilterPushDownAndReportStatisticsDisabled() {
        this.tEnv.getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_SOURCE_REPORT_STATISTICS_ENABLED, (Object)false);
        FlinkStatistic statistic = this.getStatisticsFromOptimizedPlan("select * from NonPartTable where a > 10");
        Assertions.assertThat((Object)statistic.getTableStats()).isEqualTo((Object)TableStats.UNKNOWN);
    }

    @Test
    public void testLimitPushDownAndCatalogStatisticsDoNotExist() {
        FlinkStatistic statistic = this.getStatisticsFromOptimizedPlan("select * from NonPartTable limit 1");
        Assertions.assertThat((Object)statistic.getTableStats()).isEqualTo((Object)new TableStats(1L));
    }

    @Test
    public void testNoPartitionPushDownAndCatalogStatisticsExist() throws Exception {
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).alterPartitionStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "PartTable"), new CatalogPartitionSpec(Collections.singletonMap("b", "1")), new CatalogTableStatistics(6L, 1, 100L, 100L), false);
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).alterPartitionStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "PartTable"), new CatalogPartitionSpec(Collections.singletonMap("b", "2")), new CatalogTableStatistics(3L, 1, 100L, 100L), false);
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).alterPartitionStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "PartTable"), new CatalogPartitionSpec(Collections.singletonMap("b", "3")), new CatalogTableStatistics(3L, 1, 100L, 100L), false);
        FlinkStatistic statistic = this.getStatisticsFromOptimizedPlan("select * from PartTable");
        Assertions.assertThat((Object)statistic.getTableStats()).isEqualTo((Object)new TableStats(12L));
    }

    @Test
    public void tesNoPartitionPushDownAndCatalogStatisticsPartialExist() throws Exception {
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).alterPartitionStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "PartTable"), new CatalogPartitionSpec(Collections.singletonMap("b", "1")), new CatalogTableStatistics(6L, 1, 100L, 100L), false);
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).alterPartitionStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "PartTable"), new CatalogPartitionSpec(Collections.singletonMap("b", "2")), new CatalogTableStatistics(3L, 1, 100L, 100L), false);
        FlinkStatistic statistic = this.getStatisticsFromOptimizedPlan("select * from PartTable");
        Assertions.assertThat((Object)statistic.getTableStats()).isEqualTo((Object)new TableStats(4L));
    }

    @Test
    public void testNoPartitionPushDownAndReportStatisticsDisabled() {
        this.tEnv.getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_SOURCE_REPORT_STATISTICS_ENABLED, (Object)false);
        FlinkStatistic statistic = this.getStatisticsFromOptimizedPlan("select * from PartTable");
        Assertions.assertThat((Object)statistic.getTableStats()).isEqualTo((Object)TableStats.UNKNOWN);
    }

    @Test
    public void testPartitionPushDownAndCatalogStatisticsExist() throws Exception {
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).alterPartitionStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "PartTable"), new CatalogPartitionSpec(Collections.singletonMap("b", "1")), new CatalogTableStatistics(6L, 1, 100L, 100L), false);
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).alterPartitionStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "PartTable"), new CatalogPartitionSpec(Collections.singletonMap("b", "2")), new CatalogTableStatistics(3L, 1, 100L, 100L), false);
        FlinkStatistic statistic = this.getStatisticsFromOptimizedPlan("select * from PartTable where b = 1");
        Assertions.assertThat((Object)statistic.getTableStats()).isEqualTo((Object)new TableStats(6L));
    }

    @Test
    public void testPartitionPushDownAndCatalogColumnStatisticsExist() throws Exception {
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).alterPartitionStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "PartTable"), new CatalogPartitionSpec(Collections.singletonMap("b", "1")), new CatalogTableStatistics(6L, 1, 100L, 100L), false);
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).alterPartitionStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "PartTable"), new CatalogPartitionSpec(Collections.singletonMap("b", "2")), new CatalogTableStatistics(3L, 1, 100L, 100L), false);
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).alterPartitionStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "PartTable"), new CatalogPartitionSpec(Collections.singletonMap("b", "3")), new CatalogTableStatistics(3L, 1, 100L, 100L), false);
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).alterPartitionColumnStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "PartTable"), new CatalogPartitionSpec(Collections.singletonMap("b", "1")), this.createSinglePartitionColumnStats(), false);
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).alterPartitionColumnStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "PartTable"), new CatalogPartitionSpec(Collections.singletonMap("b", "2")), this.createSinglePartitionColumnStats(), false);
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).alterPartitionColumnStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "PartTable"), new CatalogPartitionSpec(Collections.singletonMap("b", "3")), this.createSinglePartitionColumnStats(), false);
        FlinkStatistic statistic = this.getStatisticsFromOptimizedPlan("select * from PartTable where b < 3");
        Assertions.assertThat((Object)statistic.getTableStats()).isEqualTo((Object)new TableStats(9L, this.createMergedPartitionColumnStats()));
    }

    @Test
    public void testFilterPartitionPushDownPushDownAndCatalogStatisticsExist() throws Exception {
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).alterPartitionStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "PartTable"), new CatalogPartitionSpec(Collections.singletonMap("b", "1")), new CatalogTableStatistics(6L, 1, 100L, 100L), false);
        ((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElseThrow(Exception::new)).alterPartitionStatistics(new ObjectPath(this.tEnv.getCurrentDatabase(), "PartTable"), new CatalogPartitionSpec(Collections.singletonMap("b", "2")), new CatalogTableStatistics(3L, 1, 100L, 100L), false);
        FlinkStatistic statistic = this.getStatisticsFromOptimizedPlan("select * from PartTable where a > 10 and b = 1");
        Assertions.assertThat((Object)statistic.getTableStats()).isEqualTo((Object)new TableStats(6L));
    }

    @Test
    public void testFilterPartitionPushDownAndCatalogStatisticsDoNotExist() {
        FlinkStatistic statistic = this.getStatisticsFromOptimizedPlan("select * from PartTable where a > 10 and b = 1");
        Assertions.assertThat((Object)statistic.getTableStats()).isEqualTo((Object)new TableStats(2L));
    }

    @Test
    public void testFilterPartitionPushDownAndReportStatisticsDisabled() {
        this.tEnv.getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_SOURCE_REPORT_STATISTICS_ENABLED, (Object)false);
        FlinkStatistic statistic = this.getStatisticsFromOptimizedPlan("select * from PartTable where a > 10 and b = 1");
        Assertions.assertThat((Object)statistic.getTableStats()).isEqualTo((Object)TableStats.UNKNOWN);
    }

    @Test
    public void testFileSystemSourceWithoutData() {
        FlinkStatistic statistic = this.getStatisticsFromOptimizedPlan("select * from emptyTable");
        Assertions.assertThat((Object)statistic.getTableStats()).isEqualTo((Object)TableStats.UNKNOWN);
    }

    @Test
    public void testFileSystemSourceWithoutDataWithLimitPushDown() {
        FlinkStatistic statistic = this.getStatisticsFromOptimizedPlan("select * from emptyTable limit 1");
        Assertions.assertThat((Object)statistic.getTableStats()).isEqualTo((Object)new TableStats(1L));
    }

    private CatalogColumnStatistics createSinglePartitionColumnStats() {
        HashMap<String, Object> colStatsMap = new HashMap<String, Object>();
        CatalogColumnStatisticsDataLong longColStats = new CatalogColumnStatisticsDataLong(Long.valueOf(1L), Long.valueOf(10L), Long.valueOf(5L), Long.valueOf(5L));
        colStatsMap.put("a", longColStats);
        colStatsMap.put("b", longColStats);
        CatalogColumnStatisticsDataString stringColStats = new CatalogColumnStatisticsDataString(Long.valueOf(10L), Double.valueOf(10.0), Long.valueOf(5L), Long.valueOf(5L));
        colStatsMap.put("c", stringColStats);
        return new CatalogColumnStatistics(colStatsMap);
    }

    private Map<String, ColumnStats> createMergedPartitionColumnStats() {
        HashMap<String, Object> colStatsMap = new HashMap<String, Object>();
        CatalogColumnStatisticsDataLong longColStats = new CatalogColumnStatisticsDataLong(Long.valueOf(1L), Long.valueOf(10L), Long.valueOf(5L), Long.valueOf(10L));
        colStatsMap.put("a", longColStats);
        CatalogColumnStatisticsDataLong longColStats2 = new CatalogColumnStatisticsDataLong(Long.valueOf(1L), Long.valueOf(10L), Long.valueOf(10L), Long.valueOf(10L));
        colStatsMap.put("b", longColStats2);
        CatalogColumnStatisticsDataString stringColStats = new CatalogColumnStatisticsDataString(Long.valueOf(10L), Double.valueOf(10.0), Long.valueOf(5L), Long.valueOf(10L));
        colStatsMap.put("c", stringColStats);
        return CatalogTableStatisticsConverter.convertToColumnStatsMap(colStatsMap);
    }
}

