/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.file.testutils;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.file.table.FileSystemConnectorOptions;
import org.apache.flink.connector.file.table.FileSystemTableFactory;
import org.apache.flink.connector.file.table.FileSystemTableSource;
import org.apache.flink.connector.file.table.factories.BulkReaderFormatFactory;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.file.testutils.catalog.TestFileSystemCatalog;

@Internal
public class TestFileSystemTableFactory
extends FileSystemTableFactory {
    public static final String IDENTIFIER = "test-filesystem";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        boolean isFileSystemTable = TestFileSystemCatalog.isFileSystemTable(context.getCatalogTable().getOptions());
        if (!isFileSystemTable) {
            return FactoryUtil.createDynamicTableSource(null, (ObjectIdentifier)context.getObjectIdentifier(), (ResolvedCatalogTable)context.getCatalogTable(), Collections.emptyMap(), (ReadableConfig)context.getConfiguration(), (ClassLoader)context.getClassLoader(), (boolean)context.isTemporary());
        }
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        this.validate(helper);
        boolean isStreamingMode = context.getConfiguration().get(ExecutionOptions.RUNTIME_MODE) == RuntimeExecutionMode.STREAMING;
        Configuration tableOptions = Configuration.fromMap((Map)helper.getOptions().toMap());
        if (!isStreamingMode) {
            tableOptions.removeConfig(FileSystemConnectorOptions.SOURCE_MONITOR_INTERVAL);
        }
        return new FileSystemTableSource(context.getObjectIdentifier(), context.getPhysicalRowDataType(), context.getCatalogTable().getPartitionKeys(), (ReadableConfig)tableOptions, this.discoverDecodingFormat(context, BulkReaderFormatFactory.class), this.discoverDecodingFormat(context, DeserializationFormatFactory.class));
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        boolean isFileSystemTable = TestFileSystemCatalog.isFileSystemTable(context.getCatalogTable().getOptions());
        if (!isFileSystemTable) {
            return FactoryUtil.createDynamicTableSink(null, (ObjectIdentifier)context.getObjectIdentifier(), (ResolvedCatalogTable)context.getCatalogTable(), Collections.emptyMap(), (ReadableConfig)context.getConfiguration(), (ClassLoader)context.getClassLoader(), (boolean)context.isTemporary());
        }
        return super.createDynamicTableSink(context);
    }

    protected void validate(FactoryUtil.TableFactoryHelper helper) {
        helper.validateExcept(new String[]{(String)helper.getOptions().get(FactoryUtil.FORMAT) + ".", "partition.fields."});
        this.validateTimeZone((String)helper.getOptions().get(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_WATERMARK_TIME_ZONE));
    }
}

