/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.TableSymbol;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategiesTestBase;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.SymbolType;

class SymbolArgumentTypeStrategyTest
extends InputTypeStrategiesTestBase {
    private static final DataType SYMBOL_TYPE = new AtomicDataType((LogicalType)new SymbolType());
    private static final InputTypeStrategy STRATEGY = InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.symbol(TestEnum.class)});

    SymbolArgumentTypeStrategyTest() {
    }

    @Override
    protected Stream<InputTypeStrategiesTestBase.TestSpec> testData() {
        return Stream.of(InputTypeStrategiesTestBase.TestSpec.forStrategy("Valid argument", STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{SYMBOL_TYPE}).calledWithLiteralAt(0, (Object)TestEnum.A).expectSignature("f(<TestEnum>)"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Wrong enum", STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{SYMBOL_TYPE}).calledWithLiteralAt(0, (Object)InvalidEnum.A).expectErrorMessage("Unsupported argument symbol type. Expected symbol 'TestEnum' but actual symbol was 'InvalidEnum'."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Wrong type", STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.STRING()}).expectErrorMessage("Unsupported argument type. Expected symbol type 'TestEnum' but actual type was 'STRING'."));
    }

    private static enum TestEnum implements TableSymbol
    {
        A,
        B;

    }

    private static enum InvalidEnum implements TableSymbol
    {
        A;

    }
}

