/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategiesTestBase;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

class SubsequenceInputTypeStrategyTest
extends InputTypeStrategiesTestBase {
    SubsequenceInputTypeStrategyTest() {
    }

    @Override
    protected Stream<InputTypeStrategiesTestBase.TestSpec> testData() {
        return Stream.of(InputTypeStrategiesTestBase.TestSpec.forStrategy("A strategy used for IF ELSE with valid arguments", InputTypeStrategies.compositeSequence().argument((ArgumentTypeStrategy)InputTypeStrategies.logical((LogicalTypeRoot)LogicalTypeRoot.BOOLEAN)).subsequence(InputTypeStrategies.commonType((int)2)).finish()).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN(), DataTypes.SMALLINT(), DataTypes.DECIMAL((int)10, (int)2)}).expectSignature("f(<BOOLEAN>, <COMMON>, <COMMON>)").expectArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN(), DataTypes.DECIMAL((int)10, (int)2), DataTypes.DECIMAL((int)10, (int)2)}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Strategy fails if any of the nested strategies fail", InputTypeStrategies.compositeSequence().argument((ArgumentTypeStrategy)InputTypeStrategies.logical((LogicalTypeRoot)LogicalTypeRoot.BOOLEAN)).subsequence(InputTypeStrategies.commonType((int)2)).finish()).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN(), DataTypes.VARCHAR((int)3), DataTypes.DECIMAL((int)10, (int)2)}).expectErrorMessage("Could not find a common type for arguments: [VARCHAR(3), DECIMAL(10, 2)]"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Strategy with a varying argument", InputTypeStrategies.compositeSequence().argument((ArgumentTypeStrategy)InputTypeStrategies.logical((LogicalTypeRoot)LogicalTypeRoot.BOOLEAN)).subsequence(InputTypeStrategies.commonType((int)2)).finishWithVarying(InputTypeStrategies.varyingSequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.logical((LogicalTypeRoot)LogicalTypeRoot.BIGINT)}))).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN(), DataTypes.SMALLINT(), DataTypes.DECIMAL((int)10, (int)2), DataTypes.SMALLINT(), DataTypes.BIGINT(), DataTypes.TINYINT()}).expectSignature("f(<BOOLEAN>, <COMMON>, <COMMON>, <BIGINT>...)").expectArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN(), DataTypes.DECIMAL((int)10, (int)2), DataTypes.DECIMAL((int)10, (int)2), DataTypes.BIGINT(), DataTypes.BIGINT(), DataTypes.BIGINT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("A complex strategy with few sub sequences", InputTypeStrategies.compositeSequence().argument((ArgumentTypeStrategy)InputTypeStrategies.logical((LogicalTypeRoot)LogicalTypeRoot.BOOLEAN)).subsequence(InputTypeStrategies.commonType((int)2)).argument((ArgumentTypeStrategy)InputTypeStrategies.explicit((DataType)((DataType)DataTypes.TIME().notNull()))).subsequence(InputTypeStrategies.commonType((int)2)).finishWithVarying(InputTypeStrategies.varyingSequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.logical((LogicalTypeFamily)LogicalTypeFamily.TIMESTAMP), InputTypeStrategies.ANY}))).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN(), DataTypes.SMALLINT(), DataTypes.DECIMAL((int)10, (int)2), DataTypes.TIME().notNull(), DataTypes.TINYINT().notNull(), DataTypes.DECIMAL((int)13, (int)3).notNull(), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE().notNull(), DataTypes.SMALLINT(), DataTypes.BIGINT()}).expectSignature("f(<BOOLEAN>, <COMMON>, <COMMON>, TIME(0) NOT NULL, <COMMON>, <COMMON>, <TIMESTAMP>, <ANY>...)").expectArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN(), DataTypes.DECIMAL((int)10, (int)2), DataTypes.DECIMAL((int)10, (int)2), DataTypes.TIME().notNull(), DataTypes.DECIMAL((int)13, (int)3).notNull(), DataTypes.DECIMAL((int)13, (int)3).notNull(), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE().notNull(), DataTypes.SMALLINT(), DataTypes.BIGINT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("A strategy with named argument", InputTypeStrategies.compositeSequence().argument("arg1", (ArgumentTypeStrategy)InputTypeStrategies.logical((LogicalTypeRoot)LogicalTypeRoot.BOOLEAN)).subsequence(InputTypeStrategies.sequence(Arrays.asList("arg2", "arg3"), Arrays.asList(InputTypeStrategies.logical((LogicalTypeFamily)LogicalTypeFamily.INTEGER_NUMERIC), InputTypeStrategies.logical((LogicalTypeFamily)LogicalTypeFamily.INTEGER_NUMERIC)))).argument((ArgumentTypeStrategy)InputTypeStrategies.logical((LogicalTypeRoot)LogicalTypeRoot.INTEGER)).finish()).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN(), DataTypes.SMALLINT(), DataTypes.BIGINT(), DataTypes.INT()}).expectSignature("f(arg1 <BOOLEAN>, arg2 <INTEGER_NUMERIC>, arg3 <INTEGER_NUMERIC>, <INTEGER>)").expectArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN(), DataTypes.SMALLINT(), DataTypes.BIGINT(), DataTypes.INT()}));
    }
}

