/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import javax.annotation.Nullable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogStore;
import org.apache.flink.table.catalog.CatalogStoreHolder;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalogStore;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.utils.ExpressionResolverMocks;
import org.apache.flink.table.utils.ParserMock;

public final class CatalogManagerMocks {
    public static final String DEFAULT_CATALOG = (String)TableConfigOptions.TABLE_CATALOG_NAME.defaultValue();
    public static final String DEFAULT_DATABASE = (String)TableConfigOptions.TABLE_DATABASE_NAME.defaultValue();

    public static CatalogManager createEmptyCatalogManager() {
        return CatalogManagerMocks.createCatalogManager(null, null);
    }

    public static CatalogManager createCatalogManager(CatalogStore catalogStore) {
        return CatalogManagerMocks.createCatalogManager(CatalogStoreHolder.newBuilder().catalogStore(catalogStore).classloader(CatalogManagerMocks.class.getClassLoader()).config((ReadableConfig)new Configuration()).build());
    }

    public static CatalogManager createCatalogManager(@Nullable CatalogStoreHolder catalogStoreHolder) {
        return CatalogManagerMocks.createCatalogManager(null, catalogStoreHolder);
    }

    public static CatalogManager createCatalogManager(@Nullable Catalog catalog) {
        return CatalogManagerMocks.createCatalogManager(catalog, null);
    }

    public static CatalogManager createCatalogManager(@Nullable Catalog catalog, @Nullable CatalogStoreHolder catalogStoreHolder) {
        CatalogManager.Builder builder = CatalogManagerMocks.preparedCatalogManager();
        if (catalog != null) {
            builder.defaultCatalog(DEFAULT_CATALOG, catalog);
        }
        if (catalogStoreHolder != null) {
            builder.catalogStoreHolder(catalogStoreHolder);
        }
        CatalogManager catalogManager = builder.build();
        catalogManager.initSchemaResolver(true, ExpressionResolverMocks.dummyResolver(), (Parser)new ParserMock());
        return catalogManager;
    }

    public static CatalogManager.Builder preparedCatalogManager() {
        return CatalogManager.newBuilder().classLoader(CatalogManagerMocks.class.getClassLoader()).config((ReadableConfig)new Configuration()).defaultCatalog(DEFAULT_CATALOG, CatalogManagerMocks.createEmptyCatalog()).catalogStoreHolder(CatalogStoreHolder.newBuilder().classloader(CatalogManagerMocks.class.getClassLoader()).config((ReadableConfig)new Configuration()).catalogStore((CatalogStore)new GenericInMemoryCatalogStore()).build()).executionConfig(new ExecutionConfig());
    }

    public static Catalog createEmptyCatalog() {
        return new GenericInMemoryCatalog(DEFAULT_CATALOG, DEFAULT_DATABASE);
    }

    private CatalogManagerMocks() {
    }
}

