/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test.program;

import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.TemporalTableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.test.program.TestStep;

public final class TemporalFunctionTestStep
implements TestStep {
    public final FunctionBehavior behavior;
    public final String name;
    public final String table;
    public final Expression timeAttribute;
    public final Expression primaryKey;

    TemporalFunctionTestStep(FunctionBehavior behavior, String name, String table, Expression timeAttribute, Expression primaryKey) {
        this.behavior = behavior;
        this.name = name;
        this.table = table;
        this.timeAttribute = timeAttribute;
        this.primaryKey = primaryKey;
    }

    @Override
    public TestStep.TestKind getKind() {
        return TestStep.TestKind.TEMPORAL_FUNCTION;
    }

    public void apply(TableEnvironment env) {
        TemporalTableFunction function = env.from(this.table).createTemporalTableFunction(this.timeAttribute, this.primaryKey);
        if (this.behavior == FunctionBehavior.SYSTEM) {
            env.createTemporarySystemFunction(this.name, (UserDefinedFunction)function);
        } else {
            env.createTemporaryFunction(this.name, (UserDefinedFunction)function);
        }
    }

    static enum FunctionBehavior {
        SYSTEM,
        CATALOG;

    }
}

