/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;

@Internal
public final class ConstraintArgumentTypeStrategy
implements ArgumentTypeStrategy {
    private final String constraintMessage;
    private final Predicate<List<DataType>> evaluator;

    public ConstraintArgumentTypeStrategy(String constraintMessage, Predicate<List<DataType>> evaluator) {
        this.constraintMessage = constraintMessage;
        this.evaluator = evaluator;
    }

    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        List<DataType> actualDataTypes = callContext.getArgumentDataTypes();
        if (this.evaluator.test(actualDataTypes)) {
            return Optional.of(actualDataTypes.get(argumentPos));
        }
        return callContext.fail(throwOnFailure, this.constraintMessage, actualDataTypes.toArray());
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        return Signature.Argument.ofGroup("CONSTRAINT");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstraintArgumentTypeStrategy that = (ConstraintArgumentTypeStrategy)o;
        return this.constraintMessage.equals(that.constraintMessage) && this.evaluator.equals(that.evaluator);
    }

    public int hashCode() {
        return Objects.hash(this.constraintMessage, this.evaluator);
    }
}

