/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.api.session;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.gateway.api.endpoint.EndpointVersion;
import org.apache.flink.table.module.Module;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class SessionEnvironment {
    @Nullable
    private final String sessionName;
    private final EndpointVersion version;
    private final Map<String, CatalogCreator> registeredCatalogCreators;
    private final Map<String, ModuleCreator> registeredModuleCreators;
    @Nullable
    private final String defaultCatalog;
    private final Map<String, String> sessionConfig;

    @VisibleForTesting
    SessionEnvironment(@Nullable String sessionName, EndpointVersion version, Map<String, CatalogCreator> registeredCatalogCreators, Map<String, ModuleCreator> registeredModuleCreators, @Nullable String defaultCatalog, Map<String, String> sessionConfig) {
        this.sessionName = sessionName;
        this.version = version;
        this.registeredCatalogCreators = registeredCatalogCreators;
        this.registeredModuleCreators = registeredModuleCreators;
        this.defaultCatalog = defaultCatalog;
        this.sessionConfig = sessionConfig;
    }

    public Optional<String> getSessionName() {
        return Optional.ofNullable(this.sessionName);
    }

    public EndpointVersion getSessionEndpointVersion() {
        return this.version;
    }

    public Map<String, String> getSessionConfig() {
        return Collections.unmodifiableMap(this.sessionConfig);
    }

    public Map<String, CatalogCreator> getRegisteredCatalogCreators() {
        return Collections.unmodifiableMap(this.registeredCatalogCreators);
    }

    public Map<String, ModuleCreator> getRegisteredModuleCreators() {
        return Collections.unmodifiableMap(this.registeredModuleCreators);
    }

    public Optional<String> getDefaultCatalog() {
        return Optional.ofNullable(this.defaultCatalog);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SessionEnvironment)) {
            return false;
        }
        SessionEnvironment that = (SessionEnvironment)o;
        return Objects.equals(this.sessionName, that.sessionName) && Objects.equals(this.version, that.version) && Objects.equals(this.registeredCatalogCreators, that.registeredCatalogCreators) && Objects.equals(this.registeredModuleCreators, that.registeredModuleCreators) && Objects.equals(this.defaultCatalog, that.defaultCatalog) && Objects.equals(this.sessionConfig, that.sessionConfig);
    }

    public int hashCode() {
        return Objects.hash(this.sessionName, this.version, this.registeredCatalogCreators, this.registeredModuleCreators, this.defaultCatalog, this.sessionConfig);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @PublicEvolving
    public static class Builder {
        @Nullable
        private String sessionName;
        private EndpointVersion version;
        private final Map<String, String> sessionConfig = new HashMap<String, String>();
        private final Map<String, CatalogCreator> registeredCatalogCreators = new HashMap<String, CatalogCreator>();
        private final Map<String, ModuleCreator> registeredModuleCreators = new HashMap<String, ModuleCreator>();
        @Nullable
        private String defaultCatalog;

        public Builder setSessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        public Builder setSessionEndpointVersion(EndpointVersion version) {
            this.version = version;
            return this;
        }

        public Builder addSessionConfig(Map<String, String> sessionConfig) {
            this.sessionConfig.putAll(sessionConfig);
            return this;
        }

        public Builder setDefaultCatalog(@Nullable String defaultCatalog) {
            this.defaultCatalog = defaultCatalog;
            return this;
        }

        public Builder registerCatalog(String catalogName, Catalog catalog) {
            if (this.registeredCatalogCreators.containsKey(catalogName)) {
                throw new ValidationException(String.format("A catalog with name '%s' already exists.", catalogName));
            }
            this.registeredCatalogCreators.put(catalogName, (configuration, classLoader) -> catalog);
            return this;
        }

        public Builder registerCatalogCreator(String catalogName, CatalogCreator catalogCreator) {
            if (this.registeredCatalogCreators.containsKey(catalogName)) {
                throw new ValidationException(String.format("A catalog with name '%s' already exists.", catalogName));
            }
            this.registeredCatalogCreators.put(catalogName, catalogCreator);
            return this;
        }

        public Builder registerModuleAtHead(String moduleName, Module module) {
            if (this.registeredModuleCreators.containsKey(moduleName)) {
                throw new ValidationException(String.format("A module with name '%s' already exists", moduleName));
            }
            this.registeredModuleCreators.put(moduleName, (configuration, classLoader) -> module);
            return this;
        }

        public Builder registerModuleCreatorAtHead(String moduleName, ModuleCreator moduleCreator) {
            if (this.registeredModuleCreators.containsKey(moduleName)) {
                throw new ValidationException(String.format("A module with name '%s' already exists", moduleName));
            }
            this.registeredModuleCreators.put(moduleName, moduleCreator);
            return this;
        }

        public SessionEnvironment build() {
            return new SessionEnvironment(this.sessionName, (EndpointVersion)Preconditions.checkNotNull((Object)this.version), this.registeredCatalogCreators, this.registeredModuleCreators, this.defaultCatalog, this.sessionConfig);
        }
    }

    @PublicEvolving
    public static interface CatalogCreator {
        public Catalog create(ReadableConfig var1, ClassLoader var2);
    }

    @PublicEvolving
    public static interface ModuleCreator {
        public Module create(ReadableConfig var1, ClassLoader var2);
    }
}

