/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb.snapshot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.state.FullSnapshotResources;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyValueStateIterator;
import org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.StreamCompressionDecorator;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueSnapshotRestoreWrapper;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueStateSnapshot;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.state.rocksdb.RocksDBKeyedStateBackend;
import org.apache.flink.state.rocksdb.RocksIteratorWrapper;
import org.apache.flink.state.rocksdb.iterator.RocksQueueIterator;
import org.apache.flink.state.rocksdb.iterator.RocksStatesPerKeyGroupMergeIterator;
import org.apache.flink.state.rocksdb.iterator.RocksTransformingIteratorWrapper;
import org.apache.flink.state.rocksdb.iterator.SingleStateIterator;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.ResourceGuard;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksIterator;
import org.rocksdb.Snapshot;

public class RocksDBFullSnapshotResources<K>
implements FullSnapshotResources<K> {
    private final List<StateMetaInfoSnapshot> stateMetaInfoSnapshots;
    private final ResourceGuard.Lease lease;
    private final Snapshot snapshot;
    private final RocksDB db;
    private final List<MetaData> metaData;
    @Nonnegative
    private final int keyGroupPrefixBytes;
    private final KeyGroupRange keyGroupRange;
    private final TypeSerializer<K> keySerializer;
    private final StreamCompressionDecorator streamCompressionDecorator;
    private final List<HeapPriorityQueueStateSnapshot<?>> heapPriorityQueuesSnapshots;

    public RocksDBFullSnapshotResources(ResourceGuard.Lease lease, Snapshot snapshot, List<RocksDBKeyedStateBackend.RocksDbKvStateInfo> metaDataCopy, List<HeapPriorityQueueStateSnapshot<?>> heapPriorityQueuesSnapshots, List<StateMetaInfoSnapshot> stateMetaInfoSnapshots, RocksDB db, int keyGroupPrefixBytes, KeyGroupRange keyGroupRange, TypeSerializer<K> keySerializer, StreamCompressionDecorator streamCompressionDecorator) {
        this.lease = lease;
        this.snapshot = snapshot;
        this.stateMetaInfoSnapshots = stateMetaInfoSnapshots;
        this.heapPriorityQueuesSnapshots = heapPriorityQueuesSnapshots;
        this.db = db;
        this.keyGroupPrefixBytes = keyGroupPrefixBytes;
        this.keyGroupRange = keyGroupRange;
        this.keySerializer = keySerializer;
        this.streamCompressionDecorator = streamCompressionDecorator;
        this.metaData = this.fillMetaData(metaDataCopy);
    }

    public static <K> RocksDBFullSnapshotResources<K> create(LinkedHashMap<String, RocksDBKeyedStateBackend.RocksDbKvStateInfo> kvStateInformation, Map<String, HeapPriorityQueueSnapshotRestoreWrapper<?>> registeredPQStates, RocksDB db, ResourceGuard rocksDBResourceGuard, KeyGroupRange keyGroupRange, TypeSerializer<K> keySerializer, int keyGroupPrefixBytes, StreamCompressionDecorator keyGroupCompressionDecorator) throws IOException {
        ArrayList<StateMetaInfoSnapshot> stateMetaInfoSnapshots = new ArrayList<StateMetaInfoSnapshot>(kvStateInformation.size());
        ArrayList<RocksDBKeyedStateBackend.RocksDbKvStateInfo> metaDataCopy = new ArrayList<RocksDBKeyedStateBackend.RocksDbKvStateInfo>(kvStateInformation.size());
        for (RocksDBKeyedStateBackend.RocksDbKvStateInfo rocksDbKvStateInfo : kvStateInformation.values()) {
            stateMetaInfoSnapshots.add(rocksDbKvStateInfo.metaInfo.snapshot());
            metaDataCopy.add(rocksDbKvStateInfo);
        }
        ArrayList heapPriorityQueuesSnapshots = new ArrayList(registeredPQStates.size());
        for (HeapPriorityQueueSnapshotRestoreWrapper<?> heapPriorityQueueSnapshotRestoreWrapper : registeredPQStates.values()) {
            stateMetaInfoSnapshots.add(heapPriorityQueueSnapshotRestoreWrapper.getMetaInfo().snapshot());
            heapPriorityQueuesSnapshots.add(heapPriorityQueueSnapshotRestoreWrapper.stateSnapshot());
        }
        ResourceGuard.Lease lease = rocksDBResourceGuard.acquireResource();
        Snapshot snapshot = db.getSnapshot();
        return new RocksDBFullSnapshotResources<K>(lease, snapshot, metaDataCopy, heapPriorityQueuesSnapshots, stateMetaInfoSnapshots, db, keyGroupPrefixBytes, keyGroupRange, keySerializer, keyGroupCompressionDecorator);
    }

    private List<MetaData> fillMetaData(List<RocksDBKeyedStateBackend.RocksDbKvStateInfo> metaDataCopy) {
        ArrayList<MetaData> metaData = new ArrayList<MetaData>(metaDataCopy.size());
        for (RocksDBKeyedStateBackend.RocksDbKvStateInfo rocksDbKvStateInfo : metaDataCopy) {
            StateSnapshotTransformer stateSnapshotTransformer = null;
            if (rocksDbKvStateInfo.metaInfo instanceof RegisteredKeyValueStateBackendMetaInfo) {
                stateSnapshotTransformer = ((RegisteredKeyValueStateBackendMetaInfo)rocksDbKvStateInfo.metaInfo).getStateSnapshotTransformFactory().createForSerializedState().orElse(null);
            }
            metaData.add(new MetaData(rocksDbKvStateInfo, stateSnapshotTransformer));
        }
        return metaData;
    }

    public KeyValueStateIterator createKVStateIterator() throws IOException {
        CloseableRegistry closeableRegistry = new CloseableRegistry();
        try {
            ReadOptions readOptions = new ReadOptions();
            closeableRegistry.registerCloseable(() -> ((ReadOptions)readOptions).close());
            readOptions.setSnapshot(this.snapshot);
            List<Tuple2<RocksIteratorWrapper, Integer>> kvStateIterators = this.createKVStateIterators(closeableRegistry, readOptions);
            List<SingleStateIterator> heapPriorityQueueIterators = this.createHeapPriorityQueueIterators();
            return new RocksStatesPerKeyGroupMergeIterator(closeableRegistry, kvStateIterators, heapPriorityQueueIterators, this.keyGroupPrefixBytes);
        }
        catch (Throwable t) {
            IOUtils.closeQuietly((AutoCloseable)closeableRegistry);
            throw new IOException("Error creating merge iterator", t);
        }
    }

    private List<SingleStateIterator> createHeapPriorityQueueIterators() {
        int kvStateId = this.metaData.size();
        ArrayList<SingleStateIterator> queuesIterators = new ArrayList<SingleStateIterator>(this.heapPriorityQueuesSnapshots.size());
        for (HeapPriorityQueueStateSnapshot<?> queuesSnapshot : this.heapPriorityQueuesSnapshots) {
            queuesIterators.add(new RocksQueueIterator(queuesSnapshot, this.keyGroupRange, this.keyGroupPrefixBytes, kvStateId++));
        }
        return queuesIterators;
    }

    private List<Tuple2<RocksIteratorWrapper, Integer>> createKVStateIterators(CloseableRegistry closeableRegistry, ReadOptions readOptions) throws IOException {
        ArrayList<Tuple2<RocksIteratorWrapper, Integer>> kvStateIterators = new ArrayList<Tuple2<RocksIteratorWrapper, Integer>>(this.metaData.size());
        int kvStateId = 0;
        for (MetaData metaDataEntry : this.metaData) {
            RocksIteratorWrapper rocksIteratorWrapper = RocksDBFullSnapshotResources.createRocksIteratorWrapper(this.db, metaDataEntry.rocksDbKvStateInfo.columnFamilyHandle, metaDataEntry.stateSnapshotTransformer, readOptions);
            kvStateIterators.add((Tuple2<RocksIteratorWrapper, Integer>)Tuple2.of((Object)rocksIteratorWrapper, (Object)kvStateId));
            closeableRegistry.registerCloseable((AutoCloseable)rocksIteratorWrapper);
            ++kvStateId;
        }
        return kvStateIterators;
    }

    private static RocksIteratorWrapper createRocksIteratorWrapper(RocksDB db, ColumnFamilyHandle columnFamilyHandle, StateSnapshotTransformer<byte[]> stateSnapshotTransformer, ReadOptions readOptions) {
        RocksIterator rocksIterator = db.newIterator(columnFamilyHandle, readOptions);
        return stateSnapshotTransformer == null ? new RocksIteratorWrapper(rocksIterator) : new RocksTransformingIteratorWrapper(rocksIterator, stateSnapshotTransformer);
    }

    public List<StateMetaInfoSnapshot> getMetaInfoSnapshots() {
        return this.stateMetaInfoSnapshots;
    }

    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public StreamCompressionDecorator getStreamCompressionDecorator() {
        return this.streamCompressionDecorator;
    }

    public void release() {
        this.db.releaseSnapshot(this.snapshot);
        IOUtils.closeQuietly((AutoCloseable)this.snapshot);
        IOUtils.closeQuietly((AutoCloseable)this.lease);
    }

    private static class MetaData {
        final RocksDBKeyedStateBackend.RocksDbKvStateInfo rocksDbKvStateInfo;
        final StateSnapshotTransformer<byte[]> stateSnapshotTransformer;

        private MetaData(RocksDBKeyedStateBackend.RocksDbKvStateInfo rocksDbKvStateInfo, StateSnapshotTransformer<byte[]> stateSnapshotTransformer) {
            this.rocksDbKvStateInfo = rocksDbKvStateInfo;
            this.stateSnapshotTransformer = stateSnapshotTransformer;
        }
    }
}

