/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import org.apache.flink.annotation.Internal;
import org.forstdb.ColumnFamilyHandle;
import org.forstdb.RocksDB;

@Internal
public enum ForStProperty {
    NumImmutableMemTable("num-immutable-mem-table", PropertyType.NUMBER),
    MemTableFlushPending("mem-table-flush-pending", PropertyType.NUMBER),
    CompactionPending("compaction-pending", PropertyType.NUMBER),
    BackgroundErrors("background-errors", PropertyType.NUMBER),
    CurSizeActiveMemTable("cur-size-active-mem-table", PropertyType.NUMBER),
    CurSizeAllMemTables("cur-size-all-mem-tables", PropertyType.NUMBER),
    SizeAllMemTables("size-all-mem-tables", PropertyType.NUMBER),
    NumEntriesActiveMemTable("num-entries-active-mem-table", PropertyType.NUMBER),
    NumEntriesImmMemTables("num-entries-imm-mem-tables", PropertyType.NUMBER),
    NumDeletesActiveMemTable("num-deletes-active-mem-table", PropertyType.NUMBER),
    NumDeletesImmMemTables("num-deletes-imm-mem-tables", PropertyType.NUMBER),
    EstimateNumKeys("estimate-num-keys", PropertyType.NUMBER),
    EstimateTableReadersMem("estimate-table-readers-mem", PropertyType.NUMBER),
    NumSnapshots("num-snapshots", PropertyType.NUMBER),
    NumLiveVersions("num-live-versions", PropertyType.NUMBER),
    EstimateLiveDataSize("estimate-live-data-size", PropertyType.NUMBER),
    TotalSstFilesSize("total-sst-files-size", PropertyType.NUMBER),
    LiveSstFilesSize("live-sst-files-size", PropertyType.NUMBER),
    EstimatePendingCompactionBytes("estimate-pending-compaction-bytes", PropertyType.NUMBER),
    NumRunningCompactions("num-running-compactions", PropertyType.NUMBER),
    NumRunningFlushes("num-running-flushes", PropertyType.NUMBER),
    ActualDelayedWriteRate("actual-delayed-write-rate", PropertyType.NUMBER),
    IsWriteStopped("is-write-stopped", PropertyType.NUMBER),
    BlockCacheCapacity("block-cache-capacity", PropertyType.NUMBER),
    BlockCacheUsage("block-cache-usage", PropertyType.NUMBER),
    BlockCachePinnedUsage("block-cache-pinned-usage", PropertyType.NUMBER),
    NumFilesAtLevel0("num-files-at-level0", PropertyType.STRING),
    NumFilesAtLevel1("num-files-at-level1", PropertyType.STRING),
    NumFilesAtLevel2("num-files-at-level2", PropertyType.STRING),
    NumFilesAtLevel3("num-files-at-level3", PropertyType.STRING),
    NumFilesAtLevel4("num-files-at-level4", PropertyType.STRING),
    NumFilesAtLevel5("num-files-at-level5", PropertyType.STRING),
    NumFilesAtLevel6("num-files-at-level6", PropertyType.STRING);

    private static final String ROCKS_DB_PROPERTY_FORMAT = "rocksdb.%s";
    private static final String CONFIG_KEY_FORMAT = "state.backend.forst.metrics.%s";
    private final String property;
    private final PropertyType type;

    private ForStProperty(String property, PropertyType type) {
        this.property = property;
        this.type = type;
    }

    public String getForStProperty() {
        return String.format(ROCKS_DB_PROPERTY_FORMAT, this.property);
    }

    public long getNumericalPropertyValue(RocksDB rocksDB, ColumnFamilyHandle handle) throws Exception {
        String forStProperty = this.getForStProperty();
        switch (this.type) {
            case NUMBER: {
                return rocksDB.getLongProperty(handle, forStProperty);
            }
            case STRING: {
                return Long.parseLong(rocksDB.getProperty(handle, forStProperty));
            }
        }
        throw new RuntimeException(String.format("ForSt property type: %s not supported", new Object[]{this.type}));
    }

    public String getConfigKey() {
        return String.format(CONFIG_KEY_FORMAT, this.property);
    }

    private static enum PropertyType {
        NUMBER,
        STRING;

    }
}

