/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.v2.State;
import org.apache.flink.api.common.state.v2.StateIterator;
import org.apache.flink.core.state.InternalStateFuture;
import org.apache.flink.runtime.asyncprocessing.StateRequestHandler;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.state.forst.ContextKey;
import org.apache.flink.state.forst.ForStDBIterRequest;
import org.apache.flink.state.forst.ForStMapIterator;
import org.apache.flink.state.forst.ForStMapState;
import org.forstdb.RocksIterator;

public class ForStDBMapValueIterRequest<K, N, UK, UV>
extends ForStDBIterRequest<K, N, UK, UV, UV> {
    private final InternalStateFuture<StateIterator<UV>> future;

    public ForStDBMapValueIterRequest(ContextKey<K, N> contextKey, ForStMapState<K, N, UK, UV> table, StateRequestHandler stateRequestHandler, @Nullable RocksIterator rocksIterator, InternalStateFuture<StateIterator<UV>> future) {
        super(contextKey, table, stateRequestHandler, rocksIterator);
        this.future = future;
    }

    @Override
    public void completeStateFutureExceptionally(String message, Throwable ex) {
        this.future.completeExceptionally(message, ex);
    }

    @Override
    public Collection<UV> deserializeElement(List<ForStDBIterRequest.RawEntry> entries, int userKeyOffset) throws IOException {
        ArrayList deserializedEntries = new ArrayList(entries.size());
        for (ForStDBIterRequest.RawEntry en : entries) {
            Object userValue = this.deserializeUserValue(en.rawValueBytes);
            if (userValue == null) continue;
            deserializedEntries.add(userValue);
        }
        return deserializedEntries;
    }

    @Override
    public void buildIteratorAndCompleteFuture(Collection<UV> partialResult, boolean encounterEnd) {
        ForStMapIterator<UV> stateIterator = new ForStMapIterator<UV>((State)this.table, StateRequestType.MAP_ITER_VALUE, StateRequestType.ITERATOR_LOADING, this.stateRequestHandler, partialResult, encounterEnd, this.rocksIterator);
        this.future.complete(stateIterator);
    }
}

