/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.asyncprocessing.StateRequestHandler;
import org.apache.flink.state.forst.ContextKey;
import org.apache.flink.state.forst.ForStMapState;
import org.apache.flink.util.Preconditions;
import org.forstdb.RocksDB;
import org.forstdb.RocksIterator;

public abstract class ForStDBIterRequest<K, N, UK, UV, R>
implements Closeable {
    @Nonnull
    final ContextKey<K, N> contextKey;
    final ForStMapState<K, N, UK, UV> table;
    final StateRequestHandler stateRequestHandler;
    final int keyGroupPrefixBytes;
    @Nullable
    RocksIterator rocksIterator;

    public ForStDBIterRequest(ContextKey<K, N> contextKey, ForStMapState<K, N, UK, UV> table, StateRequestHandler stateRequestHandler, RocksIterator rocksIterator) {
        this.contextKey = contextKey;
        this.table = table;
        this.stateRequestHandler = stateRequestHandler;
        this.keyGroupPrefixBytes = table.getKeyGroupPrefixBytes();
        this.rocksIterator = rocksIterator;
    }

    protected UV deserializeUserValue(byte[] valueBytes) throws IOException {
        return this.table.deserializeValue(valueBytes);
    }

    protected UK deserializeUserKey(byte[] userKeyBytes, int userKeyOffset) throws IOException {
        return this.table.deserializeUserKey(userKeyBytes, userKeyOffset);
    }

    protected byte[] getKeyPrefixBytes() throws IOException {
        Preconditions.checkState((this.contextKey.getUserKey() == null ? 1 : 0) != 0);
        return this.table.serializeKey(this.contextKey);
    }

    protected static boolean startWithKeyPrefix(byte[] keyPrefixBytes, byte[] rawKeyBytes, int kgPrefixBytes) {
        if (rawKeyBytes.length < keyPrefixBytes.length) {
            return false;
        }
        int i = keyPrefixBytes.length;
        while (--i >= kgPrefixBytes) {
            if (rawKeyBytes[i] == keyPrefixBytes[i]) continue;
            return false;
        }
        return true;
    }

    public void process(RocksDB db, int cacheSizeLimit) throws IOException {
        byte[] prefix = this.getKeyPrefixBytes();
        int userKeyOffset = prefix.length;
        if (this.rocksIterator == null) {
            this.rocksIterator = db.newIterator(this.table.getColumnFamilyHandle());
            this.rocksIterator.seek(prefix);
        }
        ArrayList<RawEntry> entries = new ArrayList<RawEntry>(cacheSizeLimit);
        boolean encounterEnd = false;
        while (this.rocksIterator.isValid() && entries.size() < cacheSizeLimit) {
            byte[] key = this.rocksIterator.key();
            if (!ForStDBIterRequest.startWithKeyPrefix(prefix, key, this.keyGroupPrefixBytes)) {
                encounterEnd = true;
                this.rocksIterator.close();
                this.rocksIterator = null;
                break;
            }
            entries.add(new RawEntry(key, this.rocksIterator.value()));
            this.rocksIterator.next();
        }
        if (!(encounterEnd || entries.size() >= cacheSizeLimit && this.rocksIterator.isValid())) {
            encounterEnd = true;
            this.rocksIterator.close();
            this.rocksIterator = null;
        }
        Collection<R> deserializedEntries = this.deserializeElement(entries, userKeyOffset);
        this.buildIteratorAndCompleteFuture(deserializedEntries, encounterEnd);
    }

    public abstract void completeStateFutureExceptionally(String var1, Throwable var2);

    public abstract Collection<R> deserializeElement(List<RawEntry> var1, int var2) throws IOException;

    public abstract void buildIteratorAndCompleteFuture(Collection<R> var1, boolean var2);

    @Override
    public void close() throws IOException {
        if (this.rocksIterator != null) {
            this.rocksIterator.close();
            this.rocksIterator = null;
        }
    }

    static class RawEntry {
        final byte[] rawKeyBytes;
        final byte[] rawValueBytes;

        public RawEntry(byte[] rawKeyBytes, byte[] rawValueBytes) {
            this.rawKeyBytes = rawKeyBytes;
            this.rawValueBytes = rawValueBytes;
        }
    }
}

