/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.runtime;

import java.util.stream.StreamSupport;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.runtime.OperatorIDPair;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.state.api.runtime.OperatorIDGenerator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.v2.DiscardingSink;
import org.junit.Assert;
import org.junit.Test;

public class OperatorIDGeneratorTest {
    private static final String UID = "uid";
    private static final String OPERATOR_NAME = "operator";

    @Test
    public void testOperatorIdMatchesUid() {
        OperatorID expectedId = OperatorIDGeneratorTest.getOperatorID();
        OperatorID generatedId = OperatorIDGenerator.fromUid((String)UID);
        Assert.assertEquals((Object)expectedId, (Object)generatedId);
    }

    private static OperatorID getOperatorID() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(1);
        env.fromData((Object[])new Integer[]{1, 2, 3}).uid(UID).name(OPERATOR_NAME).disableChaining().sinkTo((Sink)new DiscardingSink());
        JobGraph graph = env.getStreamGraph().getJobGraph(env.getClass().getClassLoader(), new JobID());
        JobVertex vertex = StreamSupport.stream(graph.getVertices().spliterator(), false).filter(node -> node.getName().contains(OPERATOR_NAME)).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find vertex"));
        return ((OperatorIDPair)vertex.getOperatorIDs().get(0)).getGeneratedOperatorID();
    }
}

