/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.core.fs.Path;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.SavepointType;
import org.apache.flink.runtime.checkpoint.SnapshotType;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.state.api.output.SnapshotUtils;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamTaskStateInitializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SnapshotUtilsTest {
    private static final List<String> EXPECTED_CALL_OPERATOR_SNAPSHOT = Arrays.asList("prepareSnapshotPreBarrier", "snapshotState", "notifyCheckpointComplete");
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private static final List<String> ACTUAL_ORDER_TRACKING = Collections.synchronizedList(new ArrayList(EXPECTED_CALL_OPERATOR_SNAPSHOT.size()));
    private static SnapshotType actualSnapshotType;

    @Test
    public void testSnapshotUtilsLifecycleWithDefaultSavepointFormatType() throws Exception {
        this.testSnapshotUtilsLifecycleWithSavepointFormatType(SavepointFormatType.DEFAULT);
    }

    @Test
    public void testSnapshotUtilsLifecycleWithCanonicalSavepointFormatType() throws Exception {
        this.testSnapshotUtilsLifecycleWithSavepointFormatType(SavepointFormatType.CANONICAL);
    }

    @Test
    public void testSnapshotUtilsLifecycleWithNativeSavepointFormatType() throws Exception {
        this.testSnapshotUtilsLifecycleWithSavepointFormatType(SavepointFormatType.NATIVE);
    }

    private void testSnapshotUtilsLifecycleWithSavepointFormatType(SavepointFormatType savepointFormatType) throws Exception {
        ACTUAL_ORDER_TRACKING.clear();
        LifecycleOperator operator = new LifecycleOperator();
        Path path = new Path(this.folder.newFolder().getAbsolutePath());
        SnapshotUtils.snapshot((StreamOperator)operator, (int)0, (long)0L, (boolean)true, (boolean)false, (Configuration)new Configuration(), (Path)path, (SavepointFormatType)savepointFormatType);
        Assert.assertEquals((Object)SavepointType.savepoint((SavepointFormatType)savepointFormatType), (Object)actualSnapshotType);
        Assert.assertEquals(EXPECTED_CALL_OPERATOR_SNAPSHOT, ACTUAL_ORDER_TRACKING);
    }

    private static class LifecycleOperator
    implements StreamOperator<Void> {
        private static final long serialVersionUID = 1L;

        private LifecycleOperator() {
        }

        public void open() throws Exception {
            ACTUAL_ORDER_TRACKING.add("open");
        }

        public void finish() throws Exception {
            ACTUAL_ORDER_TRACKING.add("finish");
        }

        public void close() throws Exception {
            ACTUAL_ORDER_TRACKING.add("close");
        }

        public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
            ACTUAL_ORDER_TRACKING.add("prepareSnapshotPreBarrier");
        }

        public OperatorSnapshotFutures snapshotState(long checkpointId, long timestamp, CheckpointOptions checkpointOptions, CheckpointStreamFactory storageLocation) throws Exception {
            ACTUAL_ORDER_TRACKING.add("snapshotState");
            actualSnapshotType = checkpointOptions.getCheckpointType();
            return new OperatorSnapshotFutures();
        }

        public void initializeState(StreamTaskStateInitializer streamTaskStateManager) throws Exception {
            ACTUAL_ORDER_TRACKING.add("initializeState");
        }

        public void setKeyContextElement1(StreamRecord<?> record) throws Exception {
            ACTUAL_ORDER_TRACKING.add("setKeyContextElement1");
        }

        public void setKeyContextElement2(StreamRecord<?> record) throws Exception {
            ACTUAL_ORDER_TRACKING.add("setKeyContextElement2");
        }

        public OperatorMetricGroup getMetricGroup() {
            ACTUAL_ORDER_TRACKING.add("getMetricGroup");
            return null;
        }

        public OperatorID getOperatorID() {
            ACTUAL_ORDER_TRACKING.add("getOperatorID");
            return null;
        }

        public void notifyCheckpointComplete(long checkpointId) throws Exception {
            ACTUAL_ORDER_TRACKING.add("notifyCheckpointComplete");
        }

        public void notifyCheckpointAborted(long checkpointId) {
        }

        public void setCurrentKey(Object key) {
            ACTUAL_ORDER_TRACKING.add("setCurrentKey");
        }

        public Object getCurrentKey() {
            ACTUAL_ORDER_TRACKING.add("getCurrentKey");
            return null;
        }
    }
}

