/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output;

import java.util.Collections;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.io.FirstAttemptInitializationContext;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointMetadata;
import org.apache.flink.state.api.output.SavepointOutputFormat;
import org.apache.flink.state.api.runtime.OperatorIDGenerator;
import org.apache.flink.state.api.runtime.SavepointLoader;
import org.apache.flink.streaming.util.MockStreamingRuntimeContext;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SavepointOutputFormatTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test(expected=IllegalStateException.class)
    public void testSavepointOutputFormatOnlyWorksWithParallelismOne() throws Exception {
        Path path = new Path(this.temporaryFolder.newFolder().getAbsolutePath());
        SavepointOutputFormat format = this.createSavepointOutputFormat(path);
        format.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)2));
    }

    @Test
    public void testSavepointOutputFormat() throws Exception {
        Path path = new Path(this.temporaryFolder.newFolder().getAbsolutePath());
        SavepointOutputFormat format = this.createSavepointOutputFormat(path);
        CheckpointMetadata metadata = this.createSavepoint();
        format.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
        format.writeRecord(metadata);
        format.close();
        CheckpointMetadata metadataOnDisk = SavepointLoader.loadSavepointMetadata((String)path.getPath());
        Assert.assertEquals((String)"Incorrect checkpoint id", (long)metadata.getCheckpointId(), (long)metadataOnDisk.getCheckpointId());
        Assert.assertEquals((String)"Incorrect number of operator states in savepoint", (long)metadata.getOperatorStates().size(), (long)metadataOnDisk.getOperatorStates().size());
        Assert.assertEquals((String)"Incorrect operator state in savepoint", metadata.getOperatorStates().iterator().next(), metadataOnDisk.getOperatorStates().iterator().next());
    }

    private CheckpointMetadata createSavepoint() {
        OperatorState operatorState = new OperatorState(null, null, OperatorIDGenerator.fromUid((String)"uid"), 1, 128);
        operatorState.putState(0, OperatorSubtaskState.builder().build());
        return new CheckpointMetadata(0L, Collections.singleton(operatorState), Collections.emptyList());
    }

    private SavepointOutputFormat createSavepointOutputFormat(Path path) throws Exception {
        MockStreamingRuntimeContext ctx = new MockStreamingRuntimeContext(false, 1, 0);
        SavepointOutputFormat format = new SavepointOutputFormat(path);
        format.setRuntimeContext((RuntimeContext)ctx);
        return format;
    }
}

