/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api;

import java.io.IOException;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.state.api.OperatorIdentifier;
import org.apache.flink.state.api.SavepointReader;
import org.apache.flink.state.api.SavepointReaderITTestBase;
import org.apache.flink.streaming.api.datastream.DataStream;

public class SavepointReaderUidHashITCase
extends SavepointReaderITTestBase {
    private static final ListStateDescriptor<Integer> list = new ListStateDescriptor("list", Types.INT);
    private static final ListStateDescriptor<Integer> union = new ListStateDescriptor("union", Types.INT);
    private static final MapStateDescriptor<Integer, String> broadcast = new MapStateDescriptor("broadcast", Types.INT, Types.STRING);

    public SavepointReaderUidHashITCase() {
        super(list, union, broadcast);
    }

    @Override
    public DataStream<Integer> readListState(SavepointReader savepoint) throws IOException {
        return savepoint.readListState(SavepointReaderUidHashITCase.getUidHashFromUid("stateful-operator"), "list", Types.INT);
    }

    @Override
    public DataStream<Integer> readUnionState(SavepointReader savepoint) throws IOException {
        return savepoint.readUnionState(SavepointReaderUidHashITCase.getUidHashFromUid("stateful-operator"), "union", Types.INT);
    }

    @Override
    public DataStream<Tuple2<Integer, String>> readBroadcastState(SavepointReader savepoint) throws IOException {
        return savepoint.readBroadcastState(SavepointReaderUidHashITCase.getUidHashFromUid("stateful-operator"), "broadcast", Types.INT, Types.STRING);
    }

    private static OperatorIdentifier getUidHashFromUid(String uid) {
        return OperatorIdentifier.forUidHash((String)OperatorIdentifier.forUid((String)uid).getOperatorId().toHexString());
    }
}

