/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.api.operation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.table.gateway.api.operation.OperationStatus;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OperationStatusTest {
    @Test
    public void testSupportedTransition() {
        for (OperationStatusTransition translation : this.getSupportedOperationStatusTransition()) {
            Assertions.assertTrue((boolean)OperationStatus.isValidStatusTransition((OperationStatus)translation.from, (OperationStatus)translation.to));
        }
    }

    @Test
    public void testUnsupportedTransition() {
        Set<OperationStatusTransition> supported = this.getSupportedOperationStatusTransition();
        for (OperationStatus from : OperationStatus.values()) {
            for (OperationStatus to : OperationStatus.values()) {
                if (supported.contains(new OperationStatusTransition(from, to))) continue;
                Assertions.assertFalse((boolean)OperationStatus.isValidStatusTransition((OperationStatus)from, (OperationStatus)to));
            }
        }
    }

    private Set<OperationStatusTransition> getSupportedOperationStatusTransition() {
        return new HashSet<OperationStatusTransition>(Arrays.asList(new OperationStatusTransition(OperationStatus.INITIALIZED, OperationStatus.PENDING), new OperationStatusTransition(OperationStatus.PENDING, OperationStatus.RUNNING), new OperationStatusTransition(OperationStatus.RUNNING, OperationStatus.FINISHED), new OperationStatusTransition(OperationStatus.INITIALIZED, OperationStatus.CANCELED), new OperationStatusTransition(OperationStatus.PENDING, OperationStatus.CANCELED), new OperationStatusTransition(OperationStatus.RUNNING, OperationStatus.CANCELED), new OperationStatusTransition(OperationStatus.INITIALIZED, OperationStatus.TIMEOUT), new OperationStatusTransition(OperationStatus.PENDING, OperationStatus.TIMEOUT), new OperationStatusTransition(OperationStatus.RUNNING, OperationStatus.TIMEOUT), new OperationStatusTransition(OperationStatus.INITIALIZED, OperationStatus.ERROR), new OperationStatusTransition(OperationStatus.PENDING, OperationStatus.ERROR), new OperationStatusTransition(OperationStatus.RUNNING, OperationStatus.ERROR), new OperationStatusTransition(OperationStatus.INITIALIZED, OperationStatus.CLOSED), new OperationStatusTransition(OperationStatus.PENDING, OperationStatus.CLOSED), new OperationStatusTransition(OperationStatus.RUNNING, OperationStatus.CLOSED), new OperationStatusTransition(OperationStatus.CANCELED, OperationStatus.CLOSED), new OperationStatusTransition(OperationStatus.TIMEOUT, OperationStatus.CLOSED), new OperationStatusTransition(OperationStatus.ERROR, OperationStatus.CLOSED), new OperationStatusTransition(OperationStatus.FINISHED, OperationStatus.CLOSED)));
    }

    private static class OperationStatusTransition {
        OperationStatus from;
        OperationStatus to;

        public OperationStatusTransition(OperationStatus from, OperationStatus to) {
            this.from = from;
            this.to = to;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OperationStatusTransition)) {
                return false;
            }
            OperationStatusTransition that = (OperationStatusTransition)o;
            return this.from == that.from && this.to == that.to;
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to);
        }
    }
}

