/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.connector.kafka.source.reader.deserializer.KafkaRecordDeserializationSchema;
import org.apache.flink.connector.kafka.util.JacksonMapperFactory;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.flink.util.Collector;

@PublicEvolving
public class JSONKeyValueDeserializationSchema
implements KafkaRecordDeserializationSchema<ObjectNode> {
    private static final long serialVersionUID = 1509391548173891955L;
    private final boolean includeMetadata;
    private ObjectMapper mapper;

    public JSONKeyValueDeserializationSchema(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.mapper = JacksonMapperFactory.createObjectMapper();
    }

    @Override
    public void deserialize(ConsumerRecord<byte[], byte[]> record, Collector<ObjectNode> out) throws IOException {
        ObjectNode node = this.mapper.createObjectNode();
        if (record.key() != null) {
            node.set("key", (JsonNode)this.mapper.readValue(record.key(), JsonNode.class));
        }
        if (record.value() != null) {
            node.set("value", (JsonNode)this.mapper.readValue(record.value(), JsonNode.class));
        }
        if (this.includeMetadata) {
            node.putObject("metadata").put("offset", record.offset()).put("topic", record.topic()).put("partition", record.partition());
        }
        out.collect((Object)node);
    }

    public TypeInformation<ObjectNode> getProducedType() {
        return TypeExtractor.getForClass(ObjectNode.class);
    }
}

