/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.BufferSupplier;

public class ChunkedBytesStream
extends FilterInputStream {
    private final BufferSupplier bufferSupplier;
    private byte[] intermediateBuf;
    protected int count = 0;
    protected int pos = 0;
    private final ByteBuffer intermediateBufRef;
    private final boolean delegateSkipToSourceStream;

    public ChunkedBytesStream(InputStream in, BufferSupplier bufferSupplier, int intermediateBufSize, boolean delegateSkipToSourceStream) {
        super(in);
        this.bufferSupplier = bufferSupplier;
        this.intermediateBufRef = bufferSupplier.get(intermediateBufSize);
        if (!this.intermediateBufRef.hasArray() || this.intermediateBufRef.arrayOffset() != 0) {
            throw new IllegalArgumentException("provided ByteBuffer lacks array or has non-zero arrayOffset");
        }
        this.intermediateBuf = this.intermediateBufRef.array();
        this.delegateSkipToSourceStream = delegateSkipToSourceStream;
    }

    private byte[] getBufIfOpen() throws IOException {
        byte[] buffer = this.intermediateBuf;
        if (buffer == null) {
            throw new IOException("Stream closed");
        }
        return buffer;
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.getBufIfOpen()[this.pos++] & 0xFF;
    }

    InputStream getInIfOpen() throws IOException {
        InputStream input = this.in;
        if (input == null) {
            throw new IOException("Stream closed");
        }
        return input;
    }

    int fill() throws IOException {
        byte[] buffer = this.getBufIfOpen();
        this.count = this.pos = 0;
        int n = this.getInIfOpen().read(buffer, this.pos, buffer.length - this.pos);
        if (n > 0) {
            this.count = n + this.pos;
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        byte[] mybuf = this.intermediateBuf;
        this.intermediateBuf = null;
        InputStream input = this.in;
        this.in = null;
        if (mybuf != null) {
            this.bufferSupplier.release(this.intermediateBufRef);
        }
        if (input != null) {
            input.close();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        InputStream input;
        this.getBufIfOpen();
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = 0;
        do {
            int nread;
            if ((nread = this.read1(b, off + n, len - n)) <= 0) {
                return n == 0 ? nread : n;
            }
            if ((n += nread) < len) continue;
            return n;
        } while ((input = this.in) == null || input.available() > 0);
        return n;
    }

    private int read1(byte[] b, int off, int len) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            if (len >= this.getBufIfOpen().length) {
                return this.getInIfOpen().read(b, off, len);
            }
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.getBufIfOpen(), this.pos, b, off, cnt);
        this.pos += cnt;
        return cnt;
    }

    @Override
    public long skip(long toSkip) throws IOException {
        this.getBufIfOpen();
        if (toSkip <= 0L) {
            return 0L;
        }
        long remaining = toSkip;
        int avail = this.count - this.pos;
        int bytesSkipped = (int)Math.min((long)avail, remaining);
        this.pos += bytesSkipped;
        remaining -= (long)bytesSkipped;
        while (remaining > 0L) {
            if (this.delegateSkipToSourceStream) {
                long delegateBytesSkipped = this.getInIfOpen().skip(remaining);
                if (delegateBytesSkipped == 0L) {
                    if (this.read() == -1) break;
                    --remaining;
                } else if (delegateBytesSkipped > remaining || delegateBytesSkipped < 0L) {
                    throw new IOException("Unable to skip exactly");
                }
                remaining -= delegateBytesSkipped;
                continue;
            }
            if (this.pos >= this.count) {
                this.fill();
                if (this.pos >= this.count) break;
            }
            avail = this.count - this.pos;
            bytesSkipped = (int)Math.min((long)avail, remaining);
            this.pos += bytesSkipped;
            remaining -= (long)bytesSkipped;
        }
        return toSkip - remaining;
    }

    public InputStream sourceStream() {
        return this.in;
    }

    @Override
    public synchronized int available() throws IOException {
        int n = this.count - this.pos;
        int avail = this.getInIfOpen().available();
        return n > Integer.MAX_VALUE - avail ? Integer.MAX_VALUE : n + avail;
    }
}

