/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.KafkaException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.config.ConfigException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.DoubleSerializer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.FloatSerializer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.LongSerializer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.Serde;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.Serdes;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.Serializer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.ShortSerializer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.UUIDSerializer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListSerializer<Inner>
implements Serializer<List<Inner>> {
    final Logger log = LoggerFactory.getLogger(ListSerializer.class);
    private static final List<Class<? extends Serializer<?>>> FIXED_LENGTH_SERIALIZERS = Arrays.asList(ShortSerializer.class, IntegerSerializer.class, FloatSerializer.class, LongSerializer.class, DoubleSerializer.class, UUIDSerializer.class);
    private Serializer<Inner> inner;
    private Serdes.ListSerde.SerializationStrategy serStrategy;

    public ListSerializer() {
    }

    public ListSerializer(Serializer<Inner> inner) {
        if (inner == null) {
            throw new IllegalArgumentException("ListSerializer requires \"serializer\" parameter to be provided during initialization");
        }
        this.inner = inner;
        this.serStrategy = FIXED_LENGTH_SERIALIZERS.contains(inner.getClass()) ? Serdes.ListSerde.SerializationStrategy.CONSTANT_SIZE : Serdes.ListSerde.SerializationStrategy.VARIABLE_SIZE;
    }

    public Serializer<Inner> getInnerSerializer() {
        return this.inner;
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        if (this.inner != null) {
            this.log.error("Could not configure ListSerializer as the parameter has already been set -- inner: {}", this.inner);
            throw new ConfigException("List serializer was already initialized using a non-default constructor");
        }
        String innerSerdePropertyName = isKey ? "default.list.key.serde.inner" : "default.list.value.serde.inner";
        Object innerSerdeClassOrName = configs.get(innerSerdePropertyName);
        if (innerSerdeClassOrName == null) {
            throw new ConfigException("Not able to determine the serializer class because it was neither passed via the constructor nor set in the config.");
        }
        try {
            if (innerSerdeClassOrName instanceof String) {
                this.inner = Utils.newInstance((String)innerSerdeClassOrName, Serde.class).serializer();
            } else if (innerSerdeClassOrName instanceof Class) {
                this.inner = ((Serde)Utils.newInstance((Class)innerSerdeClassOrName)).serializer();
            } else {
                throw new KafkaException("Could not create a serializer class instance using \"" + innerSerdePropertyName + "\" property.");
            }
            this.inner.configure(configs, isKey);
            this.serStrategy = FIXED_LENGTH_SERIALIZERS.contains(this.inner.getClass()) ? Serdes.ListSerde.SerializationStrategy.CONSTANT_SIZE : Serdes.ListSerde.SerializationStrategy.VARIABLE_SIZE;
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException(innerSerdePropertyName, innerSerdeClassOrName, "Serializer class " + innerSerdeClassOrName + " could not be found.");
        }
    }

    private void serializeNullIndexList(DataOutputStream out, List<Inner> data) throws IOException {
        int i = 0;
        ArrayList<Integer> nullIndexList = new ArrayList<Integer>();
        ListIterator<Inner> it = data.listIterator();
        while (it.hasNext()) {
            if (it.next() == null) {
                nullIndexList.add(i);
            }
            ++i;
        }
        out.writeInt(nullIndexList.size());
        Iterator iterator = nullIndexList.iterator();
        while (iterator.hasNext()) {
            int nullIndex = (Integer)iterator.next();
            out.writeInt(nullIndex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serialize(String topic, List<Inner> data) {
        if (data == null) {
            return null;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Object object;
            try (DataOutputStream out = new DataOutputStream(baos);){
                out.writeByte(this.serStrategy.ordinal());
                if (this.serStrategy == Serdes.ListSerde.SerializationStrategy.CONSTANT_SIZE) {
                    this.serializeNullIndexList(out, data);
                }
                int size = data.size();
                out.writeInt(size);
                for (Inner entry : data) {
                    if (entry == null) {
                        if (this.serStrategy != Serdes.ListSerde.SerializationStrategy.VARIABLE_SIZE) continue;
                        out.writeInt(-1);
                        continue;
                    }
                    byte[] bytes = this.inner.serialize(topic, entry);
                    if (this.serStrategy == Serdes.ListSerde.SerializationStrategy.VARIABLE_SIZE) {
                        out.writeInt(bytes.length);
                    }
                    out.write(bytes);
                }
                object = baos.toByteArray();
            }
            return object;
        }
        catch (IOException e) {
            this.log.error("Failed to serialize list due to", (Throwable)e);
            this.log.trace("List that could not be serialized: {}", data);
            throw new KafkaException("Failed to serialize List", e);
        }
    }

    @Override
    public void close() {
        if (this.inner != null) {
            this.inner.close();
        }
    }
}

