/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.security.kerberos;

import java.io.IOException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.kerberos.BadFormatString;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.kerberos.NoMatchingRule;

class KerberosRule {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("([^$]*)(\\$(\\d*))?");
    private static final Pattern NON_SIMPLE_PATTERN = Pattern.compile("[/@]");
    private final String defaultRealm;
    private final boolean isDefault;
    private final int numOfComponents;
    private final String format;
    private final Pattern match;
    private final Pattern fromPattern;
    private final String toPattern;
    private final boolean repeat;
    private final boolean toLowerCase;
    private final boolean toUpperCase;

    KerberosRule(String defaultRealm) {
        this.defaultRealm = defaultRealm;
        this.isDefault = true;
        this.numOfComponents = 0;
        this.format = null;
        this.match = null;
        this.fromPattern = null;
        this.toPattern = null;
        this.repeat = false;
        this.toLowerCase = false;
        this.toUpperCase = false;
    }

    KerberosRule(String defaultRealm, int numOfComponents, String format, String match, String fromPattern, String toPattern, boolean repeat, boolean toLowerCase, boolean toUpperCase) {
        this.defaultRealm = defaultRealm;
        this.isDefault = false;
        this.numOfComponents = numOfComponents;
        this.format = format;
        this.match = match == null ? null : Pattern.compile(match);
        this.fromPattern = fromPattern == null ? null : Pattern.compile(fromPattern);
        this.toPattern = toPattern;
        this.repeat = repeat;
        this.toLowerCase = toLowerCase;
        this.toUpperCase = toUpperCase;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.isDefault) {
            buf.append("DEFAULT");
        } else {
            buf.append("RULE:[");
            buf.append(this.numOfComponents);
            buf.append(':');
            buf.append(this.format);
            buf.append(']');
            if (this.match != null) {
                buf.append('(');
                buf.append(this.match);
                buf.append(')');
            }
            if (this.fromPattern != null) {
                buf.append("s/");
                buf.append(this.fromPattern);
                buf.append('/');
                buf.append(this.toPattern);
                buf.append('/');
                if (this.repeat) {
                    buf.append('g');
                }
            }
            if (this.toLowerCase) {
                buf.append("/L");
            }
            if (this.toUpperCase) {
                buf.append("/U");
            }
        }
        return buf.toString();
    }

    static String replaceParameters(String format, String[] params) throws BadFormatString {
        Matcher match = PARAMETER_PATTERN.matcher(format);
        int start = 0;
        StringBuilder result = new StringBuilder();
        while (start < format.length() && match.find(start)) {
            result.append(match.group(1));
            String paramNum = match.group(3);
            if (paramNum != null) {
                try {
                    int num = Integer.parseInt(paramNum);
                    if (num < 0 || num >= params.length) {
                        throw new BadFormatString("index " + num + " from " + format + " is outside of the valid range 0 to " + (params.length - 1));
                    }
                    result.append(params[num]);
                }
                catch (NumberFormatException nfe) {
                    throw new BadFormatString("bad format in username mapping in " + paramNum, nfe);
                }
            }
            start = match.end();
        }
        return result.toString();
    }

    static String replaceSubstitution(String base, Pattern from, String to, boolean repeat) {
        Matcher match = from.matcher(base);
        if (repeat) {
            return match.replaceAll(to);
        }
        return match.replaceFirst(to);
    }

    String apply(String[] params) throws IOException {
        String result = null;
        if (this.isDefault) {
            if (this.defaultRealm.equals(params[0])) {
                result = params[1];
            }
        } else if (params.length - 1 == this.numOfComponents) {
            String base = KerberosRule.replaceParameters(this.format, params);
            if (this.match == null || this.match.matcher(base).matches()) {
                result = this.fromPattern == null ? base : KerberosRule.replaceSubstitution(base, this.fromPattern, this.toPattern, this.repeat);
            }
        }
        if (result != null && NON_SIMPLE_PATTERN.matcher(result).find()) {
            throw new NoMatchingRule("Non-simple name " + result + " after auth_to_local rule " + this);
        }
        if (this.toLowerCase && result != null) {
            result = result.toLowerCase(Locale.ENGLISH);
        } else if (this.toUpperCase && result != null) {
            result = result.toUpperCase(Locale.ENGLISH);
        }
        return result;
    }
}

