/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.DescribeGroupsRequestData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.DescribeGroupsResponse;

public class DescribeGroupsRequest
extends AbstractRequest {
    private final DescribeGroupsRequestData data;

    private DescribeGroupsRequest(DescribeGroupsRequestData data, short version) {
        super(ApiKeys.DESCRIBE_GROUPS, version);
        this.data = data;
    }

    @Override
    public DescribeGroupsRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        DescribeGroupsResponseData describeGroupsResponseData = new DescribeGroupsResponseData();
        this.data.groups().forEach(groupId -> describeGroupsResponseData.groups().add(DescribeGroupsResponse.groupError(groupId, error)));
        if (this.version() >= 1) {
            describeGroupsResponseData.setThrottleTimeMs(throttleTimeMs);
        }
        return new DescribeGroupsResponse(describeGroupsResponseData);
    }

    public static DescribeGroupsRequest parse(ByteBuffer buffer, short version) {
        return new DescribeGroupsRequest(new DescribeGroupsRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeGroupsRequest> {
        private final DescribeGroupsRequestData data;

        public Builder(DescribeGroupsRequestData data) {
            super(ApiKeys.DESCRIBE_GROUPS);
            this.data = data;
        }

        @Override
        public DescribeGroupsRequest build(short version) {
            return new DescribeGroupsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

