/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractRequest;

public abstract class AbstractControlRequest
extends AbstractRequest {
    public static final long UNKNOWN_BROKER_EPOCH = -1L;

    protected AbstractControlRequest(ApiKeys api, short version) {
        super(api, version);
    }

    public abstract int controllerId();

    public abstract boolean isKRaftController();

    public abstract int controllerEpoch();

    public abstract long brokerEpoch();

    public static abstract class Builder<T extends AbstractRequest>
    extends AbstractRequest.Builder<T> {
        protected final int controllerId;
        protected final int controllerEpoch;
        protected final long brokerEpoch;
        protected final boolean kraftController;

        protected Builder(ApiKeys api, short version, int controllerId, int controllerEpoch, long brokerEpoch) {
            this(api, version, controllerId, controllerEpoch, brokerEpoch, false);
        }

        protected Builder(ApiKeys api, short version, int controllerId, int controllerEpoch, long brokerEpoch, boolean kraftController) {
            super(api, version);
            this.controllerId = controllerId;
            this.controllerEpoch = controllerEpoch;
            this.brokerEpoch = brokerEpoch;
            this.kraftController = kraftController;
        }

        public int controllerId() {
            return this.controllerId;
        }

        public int controllerEpoch() {
            return this.controllerEpoch;
        }

        public long brokerEpoch() {
            return this.brokerEpoch;
        }
    }

    public static enum Type {
        UNKNOWN(0),
        INCREMENTAL(1),
        FULL(2);

        private final byte type;

        private Type(int type) {
            this.type = (byte)type;
        }

        public byte toByte() {
            return this.type;
        }

        public static Type fromByte(byte type) {
            for (Type t : Type.values()) {
                if (t.type != type) continue;
                return t;
            }
            return UNKNOWN;
        }
    }
}

