/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.ByteUtils;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class ConsumerProtocolSubscription
implements ApiMessage {
    List<String> topics;
    ByteBuffer userData;
    TopicPartitionCollection ownedPartitions;
    int generationId;
    String rackId;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(Type.STRING), ""), new Field("user_data", Type.NULLABLE_BYTES, ""));
    public static final Schema SCHEMA_1 = new Schema(new Field("topics", new ArrayOf(Type.STRING), ""), new Field("user_data", Type.NULLABLE_BYTES, ""), new Field("owned_partitions", new ArrayOf(TopicPartition.SCHEMA_1), ""));
    public static final Schema SCHEMA_2 = new Schema(new Field("topics", new ArrayOf(Type.STRING), ""), new Field("user_data", Type.NULLABLE_BYTES, ""), new Field("owned_partitions", new ArrayOf(TopicPartition.SCHEMA_1), ""), new Field("generation_id", Type.INT32, ""));
    public static final Schema SCHEMA_3 = new Schema(new Field("topics", new ArrayOf(Type.STRING), ""), new Field("user_data", Type.NULLABLE_BYTES, ""), new Field("owned_partitions", new ArrayOf(TopicPartition.SCHEMA_1), ""), new Field("generation_id", Type.INT32, ""), new Field("rack_id", Type.NULLABLE_STRING, ""));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public ConsumerProtocolSubscription(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ConsumerProtocolSubscription() {
        this.topics = new ArrayList<String>(0);
        this.userData = null;
        this.ownedPartitions = new TopicPartitionCollection(0);
        this.generationId = -1;
        this.rackId = null;
    }

    @Override
    public short apiKey() {
        return -1;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        AbstractCollection newCollection = new ArrayList<String>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topics element was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topics element had invalid length " + length);
            }
            ((ArrayList)newCollection).add((String)_readable.readString(length));
        }
        this.topics = newCollection;
        int length = _readable.readInt();
        this.userData = length < 0 ? null : _readable.readByteBuffer(length);
        if (_version >= 1) {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field ownedPartitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new TopicPartitionCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                ((ImplicitLinkedHashCollection)newCollection).add((TopicPartition)new TopicPartition(_readable, _version));
            }
            this.ownedPartitions = newCollection;
        } else {
            this.ownedPartitions = new TopicPartitionCollection(0);
        }
        this.generationId = _version >= 2 ? _readable.readInt() : -1;
        if (_version >= 3) {
            length = _readable.readShort();
            if (length < 0) {
                this.rackId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field rackId had invalid length " + length);
                }
                this.rackId = _readable.readString(length);
            }
        } else {
            this.rackId = null;
        }
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        RawTaggedFieldWriter _rawWriter;
        int _numTaggedFields = 0;
        _writable.writeInt(this.topics.size());
        for (String topicsElement : this.topics) {
            byte[] _stringBytes = _cache.getSerializedValue(topicsElement);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
        }
        if (this.userData == null) {
            _writable.writeInt(-1);
        } else {
            _writable.writeInt(this.userData.remaining());
            _writable.writeByteBuffer(this.userData);
        }
        if (_version >= 1) {
            _writable.writeInt(this.ownedPartitions.size());
            for (TopicPartition ownedPartitionsElement : this.ownedPartitions) {
                ownedPartitionsElement.write(_writable, _cache, _version);
            }
        }
        if (_version >= 2) {
            _writable.writeInt(this.generationId);
        }
        if (_version >= 3) {
            if (this.rackId == null) {
                _writable.writeShort((short)-1);
            } else {
                byte[] _stringBytes = _cache.getSerializedValue(this.rackId);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
        }
        if ((_numTaggedFields += (_rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields)).numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        for (String topicsElement : this.topics) {
            byte[] _stringBytes = topicsElement.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicsElement' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(topicsElement, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
        }
        if (this.userData == null) {
            _size.addBytes(4);
        } else {
            _size.addZeroCopyBytes(this.userData.remaining());
            _size.addBytes(4);
        }
        if (_version >= 1) {
            _size.addBytes(4);
            for (TopicPartition ownedPartitionsElement : this.ownedPartitions) {
                ownedPartitionsElement.addSize(_size, _cache, _version);
            }
        }
        if (_version >= 2) {
            _size.addBytes(4);
        }
        if (_version >= 3) {
            if (this.rackId == null) {
                _size.addBytes(2);
            } else {
                byte[] _stringBytes = this.rackId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'rackId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.rackId, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConsumerProtocolSubscription)) {
            return false;
        }
        ConsumerProtocolSubscription other = (ConsumerProtocolSubscription)obj;
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (!Objects.equals(this.userData, other.userData)) {
            return false;
        }
        if (this.ownedPartitions == null ? other.ownedPartitions != null : !this.ownedPartitions.equals(other.ownedPartitions)) {
            return false;
        }
        if (this.generationId != other.generationId) {
            return false;
        }
        if (this.rackId == null ? other.rackId != null : !this.rackId.equals(other.rackId)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData);
        hashCode = 31 * hashCode + (this.ownedPartitions == null ? 0 : this.ownedPartitions.hashCode());
        hashCode = 31 * hashCode + this.generationId;
        hashCode = 31 * hashCode + (this.rackId == null ? 0 : this.rackId.hashCode());
        return hashCode;
    }

    @Override
    public ConsumerProtocolSubscription duplicate() {
        ConsumerProtocolSubscription _duplicate = new ConsumerProtocolSubscription();
        ArrayList<String> newTopics = new ArrayList<String>(this.topics.size());
        for (String _element : this.topics) {
            newTopics.add(_element);
        }
        _duplicate.topics = newTopics;
        _duplicate.userData = this.userData == null ? null : this.userData.duplicate();
        TopicPartitionCollection newOwnedPartitions = new TopicPartitionCollection(this.ownedPartitions.size());
        for (TopicPartition _element : this.ownedPartitions) {
            newOwnedPartitions.add(_element.duplicate());
        }
        _duplicate.ownedPartitions = newOwnedPartitions;
        _duplicate.generationId = this.generationId;
        _duplicate.rackId = this.rackId == null ? null : this.rackId;
        return _duplicate;
    }

    public String toString() {
        return "ConsumerProtocolSubscription(topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", userData=" + this.userData + ", ownedPartitions=" + MessageUtil.deepToString(this.ownedPartitions.iterator()) + ", generationId=" + this.generationId + ", rackId=" + (this.rackId == null ? "null" : "'" + this.rackId.toString() + "'") + ")";
    }

    public List<String> topics() {
        return this.topics;
    }

    public ByteBuffer userData() {
        return this.userData;
    }

    public TopicPartitionCollection ownedPartitions() {
        return this.ownedPartitions;
    }

    public int generationId() {
        return this.generationId;
    }

    public String rackId() {
        return this.rackId;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ConsumerProtocolSubscription setTopics(List<String> v) {
        this.topics = v;
        return this;
    }

    public ConsumerProtocolSubscription setUserData(ByteBuffer v) {
        this.userData = v;
        return this;
    }

    public ConsumerProtocolSubscription setOwnedPartitions(TopicPartitionCollection v) {
        this.ownedPartitions = v;
        return this;
    }

    public ConsumerProtocolSubscription setGenerationId(int v) {
        this.generationId = v;
        return this;
    }

    public ConsumerProtocolSubscription setRackId(String v) {
        this.rackId = v;
        return this;
    }

    public static class TopicPartitionCollection
    extends ImplicitLinkedHashMultiCollection<TopicPartition> {
        public TopicPartitionCollection() {
        }

        public TopicPartitionCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public TopicPartitionCollection(Iterator<TopicPartition> iterator) {
            super(iterator);
        }

        @Override
        public TopicPartition find(String topic) {
            TopicPartition _key = new TopicPartition();
            _key.setTopic(topic);
            return this.find(_key);
        }

        @Override
        public List<TopicPartition> findAll(String topic) {
            TopicPartition _key = new TopicPartition();
            _key.setTopic(topic);
            return this.findAll(_key);
        }

        public TopicPartitionCollection duplicate() {
            TopicPartitionCollection _duplicate = new TopicPartitionCollection(this.size());
            for (TopicPartition _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class TopicPartition
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String topic;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public TopicPartition(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public TopicPartition() {
            this.topic = "";
            this.partitions = new ArrayList<Integer>(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicPartition");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TopicPartition");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionsElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicPartition");
            }
            byte[] _stringBytes = this.topic.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
            _size.addBytes(4);
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof TopicPartition)) {
                return false;
            }
            TopicPartition other = (TopicPartition)obj;
            return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicPartition)) {
                return false;
            }
            TopicPartition other = (TopicPartition)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            return hashCode;
        }

        @Override
        public TopicPartition duplicate() {
            TopicPartition _duplicate = new TopicPartition();
            _duplicate.topic = this.topic;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicPartition(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicPartition setTopic(String v) {
            this.topic = v;
            return this;
        }

        public TopicPartition setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("topic", Type.STRING, ""), new Field("partitions", new ArrayOf(Type.INT32), "")));
            SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

