/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common;

import java.util.Map;
import java.util.Objects;

public final class MetricName {
    private final String name;
    private final String group;
    private final String description;
    private Map<String, String> tags;
    private int hash = 0;

    public MetricName(String name, String group, String description, Map<String, String> tags) {
        this.name = Objects.requireNonNull(name);
        this.group = Objects.requireNonNull(group);
        this.description = Objects.requireNonNull(description);
        this.tags = Objects.requireNonNull(tags);
    }

    public String name() {
        return this.name;
    }

    public String group() {
        return this.group;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String description() {
        return this.description;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + this.group.hashCode();
        result = 31 * result + this.name.hashCode();
        this.hash = result = 31 * result + this.tags.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetricName other = (MetricName)obj;
        return this.group.equals(other.group) && this.name.equals(other.name) && this.tags.equals(other.tags);
    }

    public String toString() {
        return "MetricName [name=" + this.name + ", group=" + this.group + ", description=" + this.description + ", tags=" + this.tags + "]";
    }
}

