/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.events;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;

public class CommitApplicationEvent
extends ApplicationEvent {
    private final CompletableFuture<Void> future;
    private final Map<TopicPartition, OffsetAndMetadata> offsets;

    public CommitApplicationEvent(Map<TopicPartition, OffsetAndMetadata> offsets) {
        super(ApplicationEvent.Type.COMMIT);
        this.offsets = offsets;
        Optional<Exception> exception = this.isValid(offsets);
        if (exception.isPresent()) {
            throw new RuntimeException(exception.get());
        }
        this.future = new CompletableFuture();
    }

    public CompletableFuture<Void> future() {
        return this.future;
    }

    public Map<TopicPartition, OffsetAndMetadata> offsets() {
        return this.offsets;
    }

    private Optional<Exception> isValid(Map<TopicPartition, OffsetAndMetadata> offsets) {
        for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : offsets.entrySet()) {
            TopicPartition topicPartition = entry.getKey();
            OffsetAndMetadata offsetAndMetadata = entry.getValue();
            if (offsetAndMetadata.offset() >= 0L) continue;
            return Optional.of(new IllegalArgumentException("Invalid offset: " + offsetAndMetadata.offset()));
        }
        return Optional.empty();
    }

    @Override
    public String toString() {
        return "CommitApplicationEvent(offsets=" + this.offsets + ")";
    }
}

