/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.ApiVersions;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.ClientUtils;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.CommonClientConfigs;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.Metadata;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.NetworkClient;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.FetchConfig;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.FetchMetricsManager;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.FetchMetricsRegistry;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.IsolationLevel;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.config.AbstractConfig;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.metrics.MetricConfig;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.metrics.Metrics;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.metrics.Sensor;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.Deserializer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.LogContext;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Time;

public final class ConsumerUtils {
    public static final String CONSUMER_JMX_PREFIX = "kafka.consumer";
    public static final String CONSUMER_METRIC_GROUP_PREFIX = "consumer";
    public static final int CONSUMER_MAX_INFLIGHT_REQUESTS_PER_CONNECTION = 100;
    private static final String CONSUMER_CLIENT_ID_METRIC_TAG = "client-id";

    public static ConsumerNetworkClient createConsumerNetworkClient(ConsumerConfig config, Metrics metrics, LogContext logContext, ApiVersions apiVersions, Time time, Metadata metadata, Sensor throttleTimeSensor, long retryBackoffMs) {
        NetworkClient netClient = ClientUtils.createNetworkClient(config, metrics, CONSUMER_METRIC_GROUP_PREFIX, logContext, apiVersions, time, 100, metadata, throttleTimeSensor);
        int heartbeatIntervalMs = config.getInt("heartbeat.interval.ms");
        return new ConsumerNetworkClient(logContext, netClient, metadata, time, retryBackoffMs, config.getInt("request.timeout.ms"), heartbeatIntervalMs);
    }

    public static LogContext createLogContext(ConsumerConfig config, GroupRebalanceConfig groupRebalanceConfig) {
        String groupId = String.valueOf(groupRebalanceConfig.groupId);
        String clientId = config.getString("client.id");
        String groupInstanceId = groupRebalanceConfig.groupInstanceId.orElse(null);
        String logPrefix = groupInstanceId != null ? String.format("[Consumer instanceId=%s, clientId=%s, groupId=%s] ", groupInstanceId, clientId, groupId) : String.format("[Consumer clientId=%s, groupId=%s] ", clientId, groupId);
        return new LogContext(logPrefix);
    }

    public static IsolationLevel createIsolationLevel(ConsumerConfig config) {
        String s = config.getString("isolation.level").toUpperCase(Locale.ROOT);
        return IsolationLevel.valueOf(s);
    }

    public static SubscriptionState createSubscriptionState(ConsumerConfig config, LogContext logContext) {
        String s = config.getString("auto.offset.reset").toUpperCase(Locale.ROOT);
        OffsetResetStrategy strategy = OffsetResetStrategy.valueOf(s);
        return new SubscriptionState(logContext, strategy);
    }

    public static Metrics createMetrics(ConsumerConfig config, Time time) {
        String clientId = config.getString("client.id");
        Map<String, String> metricsTags = Collections.singletonMap(CONSUMER_CLIENT_ID_METRIC_TAG, clientId);
        MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples")).timeWindow(config.getLong("metrics.sample.window.ms"), TimeUnit.MILLISECONDS).recordLevel(Sensor.RecordingLevel.forName(config.getString("metrics.recording.level"))).tags(metricsTags);
        List<MetricsReporter> reporters = CommonClientConfigs.metricsReporters(clientId, (AbstractConfig)config);
        KafkaMetricsContext metricsContext = new KafkaMetricsContext(CONSUMER_JMX_PREFIX, config.originalsWithPrefix("metrics.context."));
        return new Metrics(metricConfig, reporters, time, metricsContext);
    }

    public static FetchMetricsManager createFetchMetricsManager(Metrics metrics) {
        Set<String> metricsTags = Collections.singleton(CONSUMER_CLIENT_ID_METRIC_TAG);
        FetchMetricsRegistry metricsRegistry = new FetchMetricsRegistry(metricsTags, CONSUMER_METRIC_GROUP_PREFIX);
        return new FetchMetricsManager(metrics, metricsRegistry);
    }

    public static <K, V> FetchConfig<K, V> createFetchConfig(ConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        IsolationLevel isolationLevel = ConsumerUtils.createIsolationLevel(config);
        return new FetchConfig<K, V>(config, keyDeserializer, valueDeserializer, isolationLevel);
    }

    public static <K, V> List<ConsumerInterceptor<K, V>> createConsumerInterceptors(ConsumerConfig config) {
        return ClientUtils.createConfiguredInterceptors(config, "interceptor.classes", ConsumerInterceptor.class);
    }

    public static <K> Deserializer<K> createKeyDeserializer(ConsumerConfig config, Deserializer<K> keyDeserializer) {
        String clientId = config.getString("client.id");
        if (keyDeserializer == null) {
            keyDeserializer = config.getConfiguredInstance("key.deserializer", Deserializer.class);
            keyDeserializer.configure(config.originals(Collections.singletonMap("client.id", clientId)), true);
        } else {
            config.ignore("key.deserializer");
        }
        return keyDeserializer;
    }

    public static <V> Deserializer<V> createValueDeserializer(ConsumerConfig config, Deserializer<V> valueDeserializer) {
        String clientId = config.getString("client.id");
        if (valueDeserializer == null) {
            valueDeserializer = config.getConfiguredInstance("value.deserializer", Deserializer.class);
            valueDeserializer.configure(config.originals(Collections.singletonMap("client.id", clientId)), false);
        } else {
            config.ignore("value.deserializer");
        }
        return valueDeserializer;
    }
}

