/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.TransactionListing;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.KafkaFuture;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.internals.KafkaFutureImpl;

@InterfaceStability.Evolving
public class ListTransactionsResult {
    private final KafkaFuture<Map<Integer, KafkaFutureImpl<Collection<TransactionListing>>>> future;

    ListTransactionsResult(KafkaFuture<Map<Integer, KafkaFutureImpl<Collection<TransactionListing>>>> future) {
        this.future = future;
    }

    public KafkaFuture<Collection<TransactionListing>> all() {
        return this.allByBrokerId().thenApply(map -> {
            ArrayList allListings = new ArrayList();
            for (Collection listings : map.values()) {
                allListings.addAll(listings);
            }
            return allListings;
        });
    }

    public KafkaFuture<Map<Integer, KafkaFuture<Collection<TransactionListing>>>> byBrokerId() {
        KafkaFutureImpl<Map<Integer, KafkaFuture<Collection<TransactionListing>>>> result = new KafkaFutureImpl<Map<Integer, KafkaFuture<Collection<TransactionListing>>>>();
        this.future.whenComplete((brokerFutures, exception) -> {
            if (brokerFutures != null) {
                HashMap brokerFuturesCopy = new HashMap(brokerFutures.size());
                brokerFuturesCopy.putAll(brokerFutures);
                result.complete(brokerFuturesCopy);
            } else {
                result.completeExceptionally((Throwable)exception);
            }
        });
        return result;
    }

    public KafkaFuture<Map<Integer, Collection<TransactionListing>>> allByBrokerId() {
        KafkaFutureImpl<Map<Integer, Collection<TransactionListing>>> allFuture = new KafkaFutureImpl<Map<Integer, Collection<TransactionListing>>>();
        HashMap allListingsMap = new HashMap();
        this.future.whenComplete((map, topLevelException) -> {
            if (topLevelException != null) {
                allFuture.completeExceptionally((Throwable)topLevelException);
                return;
            }
            HashSet remainingResponses = new HashSet(map.keySet());
            map.forEach((brokerId, future) -> future.whenComplete((listings, brokerException) -> {
                if (brokerException != null) {
                    allFuture.completeExceptionally((Throwable)brokerException);
                } else if (!allFuture.isDone()) {
                    allListingsMap.put(brokerId, listings);
                    remainingResponses.remove(brokerId);
                    if (remainingResponses.isEmpty()) {
                        allFuture.complete(allListingsMap);
                    }
                }
            }));
        });
        return allFuture;
    }
}

