/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.kwps.v2;

import com.google.common.collect.ImmutableSet;
import com.mapr.db.exceptions.AccessDeniedException;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.proto.Security;
import com.mapr.kwps.BrokerDescriptor;
import com.mapr.kwps.BrokerWatcher;
import com.mapr.kwps.KTopicDescriptor;
import com.mapr.kwps.KTopicsAdmin;
import com.mapr.kwps.KwpsCommon;
import com.mapr.kwps.VolumeManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.MarlinIOException;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.StreamDescriptor;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.Streams;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.TopicDescriptor;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.impl.admin.MStreamDescriptor;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.impl.admin.MarlinAdminClientImpl;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.impl.admin.MarlinAdminImpl;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.impl.admin.TopicFeedInfo;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.AdminClient;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.TopicExistsException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTopicsAdminV2
implements KTopicsAdmin,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(KafkaTopicsAdminV2.class);
    private static final Properties ADMIN_PROPS = new Properties();
    protected MarlinAdminClientImpl adminClient;
    protected final MarlinAdminImpl maprAdmin;
    protected final MapRFileSystem mfs;
    protected final VolumeManager volMgr;
    protected final String maprUser;
    protected final String thisUser;

    public KafkaTopicsAdminV2() throws IOException {
        this("mapr", null);
    }

    public KafkaTopicsAdminV2(@NonNull Security.CredentialsMsg userCredentials) throws IOException {
        this("mapr", userCredentials);
        if (userCredentials == null) {
            throw new NullPointerException("userCredentials is marked non-null but is null");
        }
    }

    public KafkaTopicsAdminV2(@NonNull String maprUser) throws IOException {
        this(maprUser, null);
        if (maprUser == null) {
            throw new NullPointerException("maprUser is marked non-null but is null");
        }
    }

    public KafkaTopicsAdminV2(@NonNull String maprUser, Security.CredentialsMsg userCredentials) throws IOException {
        if (maprUser == null) {
            throw new NullPointerException("maprUser is marked non-null but is null");
        }
        this.maprUser = maprUser;
        this.adminClient = (MarlinAdminClientImpl)AdminClient.create(ADMIN_PROPS);
        this.maprAdmin = (MarlinAdminImpl)this.adminClient.getMapRAdmin();
        this.mfs = this.maprAdmin.getMaprfs();
        this.volMgr = new VolumeManager(this.mfs, userCredentials);
        this.thisUser = this.mfs.getUserInfo().getUserName();
        log.debug("KafkaTopicsAdmin user: {}, MapR user: {}", (Object)this.thisUser, (Object)maprUser);
    }

    @Override
    public void close() throws IOException {
        this.adminClient.close();
    }

    public void createTopic(KTopicDescriptor ktopicDesc) throws IOException {
        String topicName = ktopicDesc.getTopic();
        String streamPath = KwpsCommon.getStreamPath((String)topicName);
        if (this.mfs.exists(new Path(streamPath))) {
            throw new TopicExistsException("The topic '" + topicName + "'already exists.");
        }
        String volumePath = KwpsCommon.getStreamParentPath((String)topicName);
        String volumeName = KwpsCommon.getVolumeName((String)topicName);
        if (ktopicDesc.isOwnVolume()) {
            this.volMgr.createVolume(volumeName, volumePath);
        } else {
            this.mfs.mkdirs(new Path(volumePath));
        }
        try {
            StreamDescriptor streamDesc = Streams.newStreamDescriptor();
            if (ktopicDesc.hasTtl()) {
                streamDesc.setTimeToLiveSec(ktopicDesc.getTtl());
            }
            if (ktopicDesc.hasCompression()) {
                streamDesc.setCompressionAlgo(ktopicDesc.getCompression().name());
            } else {
                streamDesc.setCompressionAlgo(KTopicDescriptor.CompressionType.off.name());
            }
            ((MStreamDescriptor)streamDesc).setKafkaTopic(true);
            streamDesc.setTopicPerms("u:" + this.thisUser + " | u:" + this.maprUser);
            if (ktopicDesc.hasAdminPerms()) {
                streamDesc.setAdminPerms(ktopicDesc.getAdminPerms());
            }
            if (ktopicDesc.hasConsumePerms()) {
                streamDesc.setConsumePerms(ktopicDesc.getConsumePerms());
            }
            if (ktopicDesc.hasProducePerms()) {
                streamDesc.setProducePerms(ktopicDesc.getProducePerms());
            }
            this.maprAdmin.createStream(streamPath, streamDesc);
        }
        catch (Exception e) {
            log.error("Failed to create stream: " + streamPath, (Throwable)e);
            this.cleanupCreate(ktopicDesc, volumePath);
            throw e;
        }
        try {
            TopicDescriptor topicDesc = Streams.newTopicDescriptor();
            if (ktopicDesc.hasPartitions()) {
                topicDesc.setPartitions(ktopicDesc.getPartitions());
            }
            this.maprAdmin.createTopic(streamPath, topicName, topicDesc);
        }
        catch (Exception e) {
            log.error("Failed to create topic: " + topicName, (Throwable)e);
            this.cleanupCreate(ktopicDesc, volumePath);
            throw e;
        }
    }

    public void editTopic(KTopicDescriptor ktopicDesc) throws IOException {
        String topicName = ktopicDesc.getTopic();
        String streamPath = KwpsCommon.getStreamPath((String)topicName);
        if (!this.mfs.exists(new Path(streamPath))) {
            throw new UnknownTopicOrPartitionException("The topic '" + topicName + "' does not exist.");
        }
        try {
            if (ktopicDesc.hasTtl() || ktopicDesc.hasCompression()) {
                boolean updateStream = false;
                StreamDescriptor streamDesc = Streams.newStreamDescriptor();
                if (ktopicDesc.hasTtl()) {
                    updateStream = true;
                    streamDesc.setTimeToLiveSec(ktopicDesc.getTtl());
                }
                if (ktopicDesc.hasCompression()) {
                    streamDesc.setCompressionAlgo(ktopicDesc.getCompression().name());
                } else if (updateStream) {
                    StreamDescriptor oldSDesc = this.maprAdmin.getStreamDescriptor(streamPath);
                    streamDesc.setCompressionAlgo(oldSDesc.getCompressionAlgo());
                }
                this.maprAdmin.editStream(streamPath, streamDesc);
            }
            if (ktopicDesc.hasPartitions()) {
                this.maprAdmin.editTopic(streamPath, topicName, ktopicDesc.getPartitions());
            }
        }
        catch (AccessDeniedException e) {
            throw (TopicAuthorizationException)new TopicAuthorizationException("The current user does not have permission to edit topic " + topicName, (Set<String>)ImmutableSet.of((Object)topicName)).initCause(e);
        }
    }

    public KTopicDescriptor getTopicDescriptor(String topicName) throws IOException {
        return this.getTopicDescriptorInternal(topicName);
    }

    private KTopicDescriptor getTopicDescriptorInternal(String topicName) throws IOException {
        KTopicDescriptor ktopicDesc = new KTopicDescriptor(topicName);
        String streamPath = KwpsCommon.getStreamPath((String)topicName);
        try {
            MapRFileStatus fStatus = this.mfs.getMapRFileStatus(new Path(streamPath));
            ktopicDesc.setOwner(fStatus.getOwner());
        }
        catch (FileNotFoundException | IllegalArgumentException e) {
            throw new UnknownTopicOrPartitionException("The topic '" + topicName + "' does not exist.", e);
        }
        StreamDescriptor streamDesc = this.maprAdmin.getStreamDescriptor(streamPath);
        ktopicDesc.setTtl(streamDesc.getTimeToLiveSec());
        ktopicDesc.setCompression(streamDesc.getCompressionAlgo());
        ktopicDesc.setAdminPerms(streamDesc.getAdminPerms());
        ktopicDesc.setConsumePerms(streamDesc.getConsumePerms());
        ktopicDesc.setAdminPerms(streamDesc.getProducePerms());
        try {
            TopicDescriptor topicDesc = this.maprAdmin.getTopicDescriptor(streamPath, topicName);
            ktopicDesc.setPartitions(topicDesc.getPartitions());
            String topicFullName = streamPath + ":" + topicName;
            List<TopicFeedInfo> tlist = this.maprAdmin.infoTopic(topicFullName);
            long topicSize = 0L;
            for (TopicFeedInfo topicFeedInfo : tlist) {
                topicSize += topicFeedInfo.stat().getPhysicalSize();
            }
            ktopicDesc.setSize(topicSize);
        }
        catch (MarlinIOException e) {
            if (e.getErrorCode() == 13) {
                log.debug("Current user doesn't have topic perm!", (Throwable)e);
            }
            throw e;
        }
        boolean isVol = this.volMgr.isVolume(topicName);
        ktopicDesc.setOwnVolume(isVol);
        return ktopicDesc;
    }

    public boolean deleteTopic(String topicName) throws IOException {
        boolean isVol = this.volMgr.isVolume(topicName);
        if (isVol) {
            return this.volMgr.deleteVolume(topicName);
        }
        Path volumePath = new Path(KwpsCommon.getStreamParentPath((String)topicName));
        if (!this.mfs.exists(volumePath)) {
            throw new UnknownTopicOrPartitionException("The topic '" + topicName + "' does not exist.");
        }
        return this.mfs.delete(volumePath, true);
    }

    public Iterable<KTopicDescriptor> listTopics() throws IOException {
        return this.listTopics(null);
    }

    public Iterable<KTopicDescriptor> listTopics(String topicNameRegex) throws IOException {
        boolean allTopics = topicNameRegex == null;
        LinkedList<KTopicDescriptor> topicList = new LinkedList<KTopicDescriptor>();
        MapRFileStatus[] all = null;
        try {
            all = this.mfs.listStatus(KwpsCommon.KWPS_TOPICS_FOLDER_PATH);
        }
        catch (FileNotFoundException e) {
            new IOException("Kafka topics folder '/var/mapr/mapr.kwps.root/topics/' doesn't exist on the cluster.", e);
        }
        Pattern topicRegex = allTopics ? null : Pattern.compile(topicNameRegex);
        for (MapRFileStatus fStatus : all) {
            Path fPath = fStatus.getPath();
            if (fStatus.isDirectory()) {
                String topicName = fPath.getName();
                if (!allTopics && !topicRegex.matcher(topicName).matches()) continue;
                KTopicDescriptor topicDesc = this.getTopicDescriptorInternal(topicName);
                topicList.add(topicDesc);
                continue;
            }
            log.warn("Unknown file '{}' in Kafka topics folder!", (Object)fPath);
        }
        return topicList;
    }

    public Map<String, String> getConnectionProperties() throws IOException {
        return this.getConnectionProperties(Optional.empty());
    }

    public Map<String, String> getConnectionProperties(Optional<String> kafkaCluster) throws IOException {
        Map map;
        block8: {
            BrokerWatcher watcher = this.newBrokerWatcher(kafkaCluster);
            try {
                watcher.connect();
                map = watcher.getConnectionProperties();
                if (watcher == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (watcher != null) {
                        try {
                            watcher.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new IOException(e);
                }
            }
            watcher.close();
        }
        return map;
    }

    private void cleanupCreate(KTopicDescriptor ktopicDesc, String volumePath) throws IOException {
        try {
            if (ktopicDesc.isOwnVolume()) {
                this.volMgr.deleteVolume(ktopicDesc.getTopic());
            } else {
                this.mfs.delete(new Path(volumePath), true);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Failed to delete partial topic metadata.", e);
        }
    }

    public void linkTopic(String topicName, String topicTarget) throws IOException {
        throw new UnsupportedOperationException("linkTopic() isn't implemented yet.");
    }

    public BrokerDescriptor getController(Optional<String> kafkaCluster) throws IOException {
        BrokerDescriptor brokerDescriptor;
        block8: {
            BrokerWatcher watcher = this.newBrokerWatcher(kafkaCluster);
            try {
                watcher.connect();
                brokerDescriptor = watcher.getController();
                if (watcher == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (watcher != null) {
                        try {
                            watcher.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new IOException(e);
                }
            }
            watcher.close();
        }
        return brokerDescriptor;
    }

    public Iterable<BrokerDescriptor> listBrokers(Optional<String> kafkaCluster) throws IOException {
        Iterable iterable;
        block8: {
            BrokerWatcher watcher = this.newBrokerWatcher(kafkaCluster);
            try {
                watcher.connect();
                iterable = watcher.getBrokers();
                if (watcher == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (watcher != null) {
                        try {
                            watcher.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new IOException(e);
                }
            }
            watcher.close();
        }
        return iterable;
    }

    public void notifyMetadataChange(Optional<String> kafkaCluster) throws IOException {
        try (BrokerWatcher watcher = this.newBrokerWatcher(kafkaCluster);){
            watcher.connect();
            watcher.notifyMetadataChange();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new IOException(e);
        }
    }

    private BrokerWatcher newBrokerWatcher(Optional<String> kafkaCluster) throws IOException {
        String zkClusterName = this.mfs.getDefaultClusterName();
        String zkConnectString = this.mfs.getZkConnectString();
        return new BrokerWatcher(zkConnectString, zkClusterName, kafkaCluster);
    }
}

